/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: sm1elem.h,v 1.1.22.1 2004/07/09 01:57:34 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
 
#ifndef _SM1ELEM_H_
#define _SM1ELEM_H_

#include "sm1parse.h"

class CSmil1AddGroup;
class CSmil1Region;
class CSmil1RootLayout;
class CSmil1Source;
class CSmil1MetaValues;
class CSmil1EndLayout;
class CSmil1SourceUpdate;
class CSmil1TimelineElement;

class CSmil1ElementHandler
{
public:
    virtual HX_RESULT handleAddGroup(CSmil1AddGroup* pAddGroup) = 0;
    virtual HX_RESULT handleRootLayout(CSmil1RootLayout* pRootLayout) = 0;
    virtual HX_RESULT handleRegion(CSmil1Region* pRegion) = 0;
    virtual HX_RESULT handleSource(CSmil1Source* pSource) = 0;
    virtual HX_RESULT handleMeta(CSmil1Meta* pMeta) = 0;
    virtual HX_RESULT handleEndLayout(CSmil1EndLayout* pEndLayout) = 0;
    virtual HX_RESULT handleRendererPreFetch(CSmil1RendererPreFetch* pRend) = 0;
    virtual HX_RESULT handleSourceUpdate(CSmil1SourceUpdate* pUpdate) = 0;
};

class CSmil1Element
{
public:
    CSmil1Element			(SMIL1Node* pNode);
    virtual ~CSmil1Element		();

    virtual void addDuration		(UINT32 ulDuration);
    virtual void addElement		(CSmil1Element* pElement,
    					UINT32& ulStartTime,
					UINT32& ulDuration);
    virtual HX_RESULT handleElement	() { return HXR_OK; }

    UINT32 m_ulClipBegin;	// start of clip
    UINT32 m_ulClipEnd;		// clip end time
    UINT32 m_ulBeginOffset;	// clip delay
    UINT32 m_ulDuration;	// clip duration
    UINT32 m_ulMaxDuration;
    UINT32 m_ulTimestamp;	// timestamp to send packet
    UINT32 m_ulEndOffset;
    UINT32 m_ulEndSync;
    UINT32 m_ulDelay;		// presentation delay
    BOOL   m_bInsertedIntoTimeline; // TRUE when inserted
    BOOL   m_bIndefiniteDuration;
    UINT32 m_ulRepeatValue;
 
    CHXString m_title;

    SMILEventSourceTag m_nBeginEventSourceTag;
    CHXString m_BeginEventSourceID;
    UINT32 m_ulBeginEventClockValue;

    SMILEventSourceTag m_nEndEventSourceTag;
    CHXString m_EndEventSourceID;
    UINT32 m_ulEndEventClockValue;
    
    SMILEventSourceTag m_nEndsyncEventSourceTag;
    CHXString m_EndsyncEventSourceID;

    SMIL1Node* m_pNode;
    CSmil1TimelineElement* m_pTimelineElement;
    CSmil1ElementHandler* m_pHandler;
    CHXSimpleList* m_pHyperlinks;
};

class CSmil1AddGroup: public CSmil1Element
{
public:
    CSmil1AddGroup			();
    virtual ~CSmil1AddGroup		();

    virtual HX_RESULT handleElement	();
    IHXValues* m_pValues;
    int m_nGroup;
    int m_nTotalTracks;
    int m_nInitTracks;
    UINT32 m_ulDuration;
};

class CSmil1RootLayout: public CSmil1Element
{
public:
    CSmil1RootLayout			(SMIL1Node* pNode);
    virtual ~CSmil1RootLayout		();

    virtual HX_RESULT handleElement	();

    UINT32 m_ulHeight;
    UINT32 m_ulWidth;
    BOOL m_bWidthUnspecified;
    BOOL m_bHeightUnspecified;
    HXxColor m_ulBgColor;
    CHXString m_overflow;
    CHXString m_title;
};

class CSmil1Region: public CSmil1Element
{
public:
    CSmil1Region				(SMIL1Node* pNode);
    virtual ~CSmil1Region		();

    virtual HX_RESULT handleElement	();
    CHXString m_left;
    CHXString m_top;
    CHXString m_height;
    CHXString m_width;
    INT32 m_zIndex;
    CHXString m_fit;
    HXxColor m_ulBgColor;
    BOOL m_bBgColorSet;

private:
};

class CSmil1Meta: public CSmil1Element
{
public:
    CSmil1Meta				(SMIL1Node* pNode);
    virtual ~CSmil1Meta			();

    virtual HX_RESULT handleElement	();

    CHXString m_name;
    CHXString m_content;
};

class CSmil1RendererPreFetch: public CSmil1Element
{
public:
    CSmil1RendererPreFetch		(SMIL1Node* pNode);
    virtual ~CSmil1RendererPreFetch	();

    virtual HX_RESULT handleElement	();

    CHXString m_mimeType;
};

class CSmil1EndLayout: public CSmil1Element
{
public:
    CSmil1EndLayout			();
    virtual ~CSmil1EndLayout		();

    virtual HX_RESULT handleElement	();
};

class CSmil1MetaValues: public CSmil1Element
{
public:
    CSmil1MetaValues			();
    virtual ~CSmil1MetaValues		();

    IHXValues* m_pValues;
};

class CSmil1Source: public CSmil1Element
{
public:
    CSmil1Source				(SMIL1Node* pNode);
    virtual ~CSmil1Source		();

    virtual HX_RESULT handleElement	();
    void setRange			(const char* pRange);

    CHXString m_src;
    CHXString m_region;
    CHXString m_fill;
};

class CSmil1SourceUpdate: public CSmil1Element
{
public:
    CSmil1SourceUpdate			();
    virtual ~CSmil1SourceUpdate		();

    virtual HX_RESULT handleElement	();

    CHXString m_srcID;
    UINT32 m_ulUpdatedDuration;
    UINT32 m_ulUpdatedDelay;
};

class CSmil1AAnchorElement: public CSmil1Element
{
public:
    CSmil1AAnchorElement			(SMIL1Node* pNode);
    virtual ~CSmil1AAnchorElement	();

    virtual BOOL isCurrentLink		(UINT32 ulTime,
					UINT32 ulXOffset,
					UINT32 ulYOffset,
					HXxRect regionRect);
    virtual void rescale		(double dXScale,
					double dYScale,
					BOOL bResetOriginalCoords);
    virtual void rescaleAbsolute(double dXScale, double dYScale);

    CHXString m_href;
    CHXString m_show;
};

class CSmil1AnchorElement: public CSmil1AAnchorElement
{
public:
    CSmil1AnchorElement			(SMIL1Node* pNode);
    virtual ~CSmil1AnchorElement		();

    virtual BOOL isCurrentLink		(UINT32 ulTime,
					UINT32 ulXOffset,
					UINT32 ulYOffset,
					HXxRect regionRect);
    virtual void rescale		(double dXScale,
					double dYScale,
					BOOL bResetOriginalCoords);
    virtual void rescaleAbsolute(double dXScale, double dYScale);

    BOOL m_bTimeValueSet;
    BOOL m_bCoordsSet;
    UINT32 m_ulLeftX;
    UINT32 m_ulOriginalLeftX;
    BOOL m_bLeftXIsPercent;
    UINT32 m_ulTopY;
    UINT32 m_ulOriginalTopY;
    BOOL m_bTopYIsPercent;
    UINT32 m_ulRightX;
    UINT32 m_ulOriginalRightX;
    BOOL m_bRightXIsPercent;
    UINT32 m_ulBottomY;
    UINT32 m_ulOriginalBottomY;
    BOOL m_bBottomYIsPercent;
    CHXString m_fragmentID;
    INT32 m_zIndex;
};

class CSmil1ParElement: public CSmil1Element
{
public:
    CSmil1ParElement		(SMIL1Node* pNode);
    virtual ~CSmil1ParElement	();
};

class CSmil1SeqElement: public CSmil1Element
{
public:
    CSmil1SeqElement		(SMIL1Node* pNode);
    virtual ~CSmil1SeqElement	();
};

#endif /* _SM1ELEM_H_ */

