/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rltxthdr.cpp,v 1.1.2.1 2004/07/09 01:50:34 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/////////////////////////////////////////////////////////////////////////////
//
//  RLTXTHDR.CPP
//
//  RealTextHeader class implementation.
//
//  	A class RealTextHeader object holds the location, size, background
//  	color,...etc for the space on the screen where the text is to be
//  	rendered
//

#include <stdlib.h>	 //For atol(..).
#include <string.h>



#include "hxtypes.h"
#include "hxwintyp.h" //For struct HXxWindow

#include "rt_types.h" //for _CHAR, RED_GREEN_OR_BLUE, COLORTYPE

#include "atocolor.h" //for string-to-COLORTYPE conversion functions.

#include "atotime.h"

#include "rt_string.h" //for stringCompare(...)

#include "parsing.h" //for text-parsing functions.

#include "rltxthdr.h"

#ifdef _MACINTOSH

#include <ctype.h>

#endif

#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

extern INT32 g_nRefCount_rtff;

/////////////////////////////////////////////////////////////////////////////
// Method:
//	RealTextHeader constructor
// Purpose:
//	Initializes all data members to default values.
//
RealTextHeader::RealTextHeader() : m_ulDuration(0L)

{
    g_nRefCount_rtff++;
}



/////////////////////////////////////////////////////////////////////////////
// Method:
//	RealTextHeader destructor
// Purpose:
//	janitorial function.
//
RealTextHeader::~RealTextHeader()
{
    g_nRefCount_rtff--;
}



/////////////////////////////////////////////////////////////////////////////
// Method:
//	RealTextHeader GetEndTime(_CHAR* buf)
// Purpose:
//	Takes a NULL-terminated string and looks for "DURATION=t" or
//	"ENDTIME=t" in the string, where "t" is passed to
//	convertTimeStringToULONG32(..) which converts a string of the form:
//	 "[[[[[[[h]h]:]m]m]:]s]s[.[m[m[m]]]]" into (ULONG32) milliseconds.
//
ULONG32 RealTextHeader::GetEndTime(_CHAR* buf)
{
    ULONG32 timeInMsec = 0L;
    ULONG32 slen = strlen(buf);
    ULONG32 indx=0;
    for(; indx<slen; indx++)
    {
	_CHAR ch=buf[indx];
	BOOL b_Endtime_or_Duration_found = FALSE;
	ULONG32 ulEorDLen = 0L;
	if('E'==ch  ||  'e'==ch  &&  (slen-indx >= 9))
	{
	    //Allow for non-case sensitive string comparing to
	    // "ENDTIME" or "DURATION":
	    if(	    ('N'==buf[indx+1]  ||  'n'==buf[indx+1])  &&
		    ('D'==buf[indx+2]  ||  'd'==buf[indx+2])  &&
		    ('T'==buf[indx+3]  ||  't'==buf[indx+3])  &&
		    ('I'==buf[indx+4]  ||  'i'==buf[indx+4])  &&
		    ('M'==buf[indx+5]  ||  'm'==buf[indx+5])  &&
		    ('E'==buf[indx+6]  ||  'e'==buf[indx+6])    )
	    {
		b_Endtime_or_Duration_found = TRUE;
		ulEorDLen = strlen("endtime");
	    }
	}
	else if('D'==ch  ||  'd'==ch  &&  (slen-indx >= 10))
	{
	    if(	    ('U'==buf[indx+1]  ||  'u'==buf[indx+1])  &&
		    ('R'==buf[indx+2]  ||  'r'==buf[indx+2])  &&
		    ('A'==buf[indx+3]  ||  'a'==buf[indx+3])  &&
		    ('T'==buf[indx+4]  ||  't'==buf[indx+4])  &&
		    ('I'==buf[indx+5]  ||  'i'==buf[indx+5])  &&
		    ('O'==buf[indx+6]  ||  'o'==buf[indx+6])  &&
		    ('N'==buf[indx+7]  ||  'n'==buf[indx+7])    )
	    {
		b_Endtime_or_Duration_found = TRUE;
		ulEorDLen = strlen("duration");
	    }
	}
	if(b_Endtime_or_Duration_found)
	{
	    ULONG32 timeValInMillisec = 0L;
	    //added the following while loop
	    // to allow spaces between "ENDTIME" (or "DURATION") and '=':
	    ULONG32 tempIndex = indx + ulEorDLen;
	    while(tempIndex<slen)
	    {
		ch = buf[tempIndex];
		if(' '==ch  ||  '\n'==ch  ||  '\r'==ch  ||  '\t'==ch)
		{
		    tempIndex++;
		}
		else if('='==ch)
		{
		    tempIndex++;
		    break;
		}
		else //not an expected character, so quit.
		{
		    return 0L;
		}
	    }
	    //added the following while loop
	    // to allow spaces between '=' and time-value:
	    while(tempIndex<slen)
	    {
		ch = buf[tempIndex];
		if(' '==ch  ||  '\n'==ch  ||  '\r'==ch  ||  '\t'==ch)
		{
		    tempIndex++;
		}
		else
		{
		    break; //we're at the start of time-value string.
		}
	    }
	    if(tempIndex>=slen)
	    {
		return 0L; //end of buffer was reached.
	    }

	    for(ULONG32 indx2=tempIndex; indx2<slen; indx2++)
	    {
		_CHAR ch = buf[indx2];
		if(' '==ch  ||  '\n'==ch  ||  '\r'==ch  ||  '\t'==ch  ||
			'>'==ch  ||  '/'==ch)
		{
		    _CHAR savedEndChar = ch;
		    buf[indx2] = '\0';
		    if(convertTimeStringToULONG32(&buf[tempIndex],
			    indx2-tempIndex, //changed from: (indx+8), 
    			    timeValInMillisec))
		    {
			buf[indx2] = savedEndChar;
			m_ulDuration = timeValInMillisec;
			return timeValInMillisec;
		    }
		    buf[indx2] = savedEndChar;
		    break;
		}
	    }
	    
	    return 0L; //error.
	}
	else if('>' == ch)
	{
	    //we've hit the end of the <WINDOW ...> tag,
	    // so quit looking for "endtime" or "duration".
	    return 0L;
	}
    }
    return 0L; //error
}
	

/* //Commented out the following for now...
BOOL RealTextHeader::convertTimeStringToULONG32(_CHAR* pTimeBuf, ULONG32 timeBufLen, 
	ULONG32& timeValInMillisec)
{
    _CHAR* pTimeBuffer = pTimeBuf;
    ULONG32 timeBufferLen = timeBufLen;
    _CHAR savedEndChar = '\0';	//for restoring '\"' char at end, if found.

    ULONG32 days_, hours_, minutes_, seconds_, milliseconds_;
    days_ = hours_ = minutes_ = seconds_ = milliseconds_ = 0L;

    LONG32 bufIndx;

    BOOL bDotEncounteredAlready = FALSE;
    LONG32 indexOfDot = -1;
    BOOL endCharWasChanged = FALSE;

    timeValInMillisec=0;

    if(!pTimeBuffer  ||  timeBufLen<1)
    {
	return FALSE;
    }

    savedEndChar = pTimeBuffer[timeBufferLen-1];

    //Get rid of start & terminating quotation mark, if they exist:
    if('\"' == pTimeBuffer[0])
    {
	pTimeBuffer++;
	timeBufferLen--;
	//Added this check to kill bug if (pTimeBuffer==")
	// and got shortened to an empty string:
	if(!timeBufferLen)
	{
	    return FALSE;
	}
    }
    if('\"' == pTimeBuffer[timeBufferLen-1])
    {
	pTimeBuffer[timeBufferLen-1] = '\0'; //get rid of end '\"'.
	timeBufferLen--;
	endCharWasChanged = TRUE;
    }
    
    //Work from right to left, searching first for milliseconds and then for
    //	seconds (or seconds only if no '.' found):
    BOOL bColonWasFound = FALSE;
    for(bufIndx=timeBufferLen-1; 0L<=bufIndx; bufIndx--)
    {
	_CHAR ch = toupper(pTimeBuffer[bufIndx]);
	if('0' > ch  ||  '9' < ch)
	{
	    if(' '==ch  ||  '\t'==ch  ||  '\n'==ch  ||  '\r'==ch)
	    {
		//Added everything up to "break;" to
		// handle (valid) strings with leading space(s) like " 39":
		//previous found was seconds_, so translate into ULONG:
		seconds_ = atol(&pTimeBuffer[bufIndx+1L]);
		timeValInMillisec += seconds_*1000; //converts seconds to ms.
		break; //we're done; we found seconds only.
	    }
	    else if('.' == ch)
	    {
		if(bDotEncounteredAlready)
		{
		    //Make sure pColorNm is in original state:
		    if(endCharWasChanged)
		    {
			pTimeBuffer[timeBufferLen-1] = savedEndChar;
		    }
		    if(indexOfDot >= 0)
		    {
			pTimeBuffer[indexOfDot] = '.';
		    }
		    //this second '.' is unexpected, so return with
		    //  timeValInMillisec set to whatever was read so far:
		    return FALSE;
		}

		bDotEncounteredAlready = TRUE;
		indexOfDot = bufIndx;
		pTimeBuffer[bufIndx] = '\0'; //end the buffr at the '.' .

		//previously-read #'s are milliseconds, so count them:
		//added "-1" to fix bug if buf ends with ".":
		if(1L > timeBufferLen-bufIndx)
		{
		    milliseconds_ = 0L;
		}
		else
		{
		    //Now, make sure that more than three digits (base 10)
		    //	are not present, e.g., reduce "46371" to "463" since
		    //	we only allow millisecond precision (3 digits past
		    //	the decimal point:
		    _CHAR chTmp = '\0';
		    ULONG32 ulNumDecimalDigitsFound = timeBufferLen-1 - bufIndx;
#if !defined(NUM_DECIMAL_DIGITS_OF_SECONDS)
# define NUM_DECIMAL_DIGITS_OF_SECONDS 3L
#endif
		    if(NUM_DECIMAL_DIGITS_OF_SECONDS <
			    ulNumDecimalDigitsFound)
		    {
			chTmp = pTimeBuffer[bufIndx+1L];
			pTimeBuffer[bufIndx+NUM_DECIMAL_DIGITS_OF_SECONDS+1]=
				'\0';
		    }
		    milliseconds_ = atol(&pTimeBuffer[bufIndx+1L]);
		    //Added this to fix "y.x" being converted
		    // to y00x instead of yx00 milliseconds:
		    if(ulNumDecimalDigitsFound < NUM_DECIMAL_DIGITS_OF_SECONDS)
		    {
			for(ULONG32 ulDiff=NUM_DECIMAL_DIGITS_OF_SECONDS
				-ulNumDecimalDigitsFound; ulDiff>0; ulDiff--)
			{
			    milliseconds_ *= 10;
			}
		    }

		    if(NUM_DECIMAL_DIGITS_OF_SECONDS <
			    ulNumDecimalDigitsFound)
		    {
			//restore the changed char in the pTimeBuffer:
			pTimeBuffer[
				bufIndx+NUM_DECIMAL_DIGITS_OF_SECONDS+1]=
				chTmp;
		    }
		}
		
		timeValInMillisec = milliseconds_;
	    } //end "else if('.' == ch)".
	    else if(':' == ch)
	    {
		bColonWasFound = TRUE;
		//previous found was seconds_, so translate into ULONG:
		seconds_ = atol(&pTimeBuffer[bufIndx+1L]);
		timeValInMillisec += seconds_*1000; //converts seconds to ms.
		break; //done with "seconds_[.milliseconds_]" part.
	    }
	    else
	    {
		//Make sure pColorNm is in original state:
		if(endCharWasChanged)
		{
		    pTimeBuffer[timeBufferLen-1] = savedEndChar;
		}
		if(indexOfDot >= 0)
		{
		    pTimeBuffer[indexOfDot] = '.';
		}
		//this char is unexpected, so return FALSE with
		//  timeValInMillisec set to whatever was read so far:
		return FALSE;
	    }
	} //end of "ch is a non-number" condition.
	else if(0L == bufIndx) //we're done with the buffer:
	{
	    //previous found was seconds_, so translate into ULONG:
	    seconds_ = atol(pTimeBuffer);
	    timeValInMillisec += seconds_*1000; //converts seconds to ms.
	    break; //done with "seconds_[.milliseconds_]" part.
	}
    } //end "for(bufIndx=timeBufferLen-1; ...".

    if(bColonWasFound) //then get the "minutes" part:
    {
	bColonWasFound = FALSE;
	//We've got the ":seconds.msecs" part, so lets get the hours part:
	for(bufIndx--; 0L<=bufIndx; bufIndx--)
	{
	    _CHAR ch = toupper(pTimeBuffer[bufIndx]);
	    if('0' > ch  ||  '9' < ch)
	    {
		if(' ' == ch  ||  '.' == ch)
		{
		    break;
		}
		else if(':' == ch)
		{
		    bColonWasFound = TRUE;
		    //previous found was seconds_, so translate into ULONG:
		    // (Note: this will do atol("min:sec") which ignores
		    // everything at & beyond the first non-num (":") char):
		    minutes_ = atol(&pTimeBuffer[bufIndx+1L]);
		    timeValInMillisec += minutes_*60000; //minutes to msec
		    break; //done w/ "minutes_:seconds_[milliseconds_]" part.
		}
		else  //unexpected char found, so quit parsing:
		{
		    //Make sure pTimeBuffer is in original state:
		    if(endCharWasChanged)
		    {
			pTimeBuffer[timeBufferLen-1] = savedEndChar;
		    }
		    if(indexOfDot >= 0)
		    {
			pTimeBuffer[indexOfDot] = '.';
		    }
		    //this char is unexpected, so return FALSE with
		    //  timeValInMillisec set to whatever was read so far:
		    return FALSE;
		}
	    } //end of "ch is a non-number" condition.
	    else if(0L == bufIndx) //we're done with the buffer:
	    {
		//previous found was seconds_, so translate into ULONG:
		minutes_ = atol(pTimeBuffer);
		timeValInMillisec += minutes_*60000; //minutes to msec
		break; //done w/ "minutes_:seconds_[milliseconds_]" part.
	    }
	} //end "for(; ...".
    } //end "if(bColonWasFound) //then get the "minutes" part:".
    if(bColonWasFound) //then get the "hours" part:
    {
	bColonWasFound = FALSE;
	//We've got the ":minutes.seconds.msec" part, so lets get the hours:
	for(bufIndx--; 0L<=bufIndx; bufIndx--)
	{
	    _CHAR ch = toupper(pTimeBuffer[bufIndx]);
	    if('0' > ch  ||  '9' < ch)
	    {
		if(' ' == ch  ||  '.' == ch)
		{
		    break;
		}
		else if(':' == ch)
		{
		    bColonWasFound = TRUE;
		    //previous found was minutes_, so translate into ULONG:
		    // (Note: this will do atol("hrs:min:sec") which ignores
		    // everything at & beyond the first non-num (":") char):
		    hours_ = atol(&pTimeBuffer[bufIndx+1L]);
		    timeValInMillisec += hours_*3600000; //hours to msec
		    break;//done w/ "hours_:minutes_:seconds_[milliseconds_]"
		}
		else  //unexpected char found, so quit parsing:
		{
		    //Make sure pTimeBuffer is in original state:
		    if(endCharWasChanged)
		    {
			pTimeBuffer[timeBufferLen-1] = savedEndChar;
		    }
		    if(indexOfDot >= 0)
		    {
			pTimeBuffer[indexOfDot] = '.';
		    }
		    //this char is unexpected, so return FALSE with
		    //  timeValInMillisec set to whatever was read so far:
		    return FALSE;
		}
	    } //end of "ch is a non-number" condition.
	    else if(0L == bufIndx) //we're done with the buffer:
	    {
		//previous found was seconds_, so translate into ULONG:
		hours_ = atol(pTimeBuffer);
		timeValInMillisec += hours_*3600000; //hours to msec
		break; //done w/ "hours_:minutes_:seconds_[milliseconds_]".
	    }
	} //end "for(; ...".
    } //end "if(bColonWasFound) //then get the "hours" part:".

    if(endCharWasChanged)
    {
	timeBufferLen++;
	//Restore the orignial pColorNm, in case end quote char was removed:
	pTimeBuffer[timeBufferLen-1] = savedEndChar;
    }
    
    if(indexOfDot >= 0)
    {
        pTimeBuffer[indexOfDot] = '.';
    }

    return TRUE;

} //end convertTimeStringToULONG32() function body.
*/
