/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rtwin.h,v 1.1.2.2 2004/07/09 01:50:49 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/////////////////////////////////////////////////////////////////////////////
//
// RTWIN.H
//
// Function:
//	BOOL OnPaint(TextWindow* pTextWindow, void* pDC, void* pPaintstruct
//		ULONG32 timeOfLastTimeSynch);
// Purpose:
//  This function does the actual rendering of text by doing a TextOut() of
//	all text in all TextContainers in the TextContainerList of textWindow
//	whose text is visible in the rectangle to be updated
//	This Function is called from WM_PAINT and hdc and ps are from
//	BeginPaint(); ps holds the invalid rectangle to be updated: 
// Returns:
//	Returns FALSE on error, TRUE otherwise. 
//
//
// Function:
//	BOOL PaintBackground(TextWindow* pTextWindow, void* pPaintstruct);
// Purpose:
//  This function paints the background of the window at the given rectangle
//	of pPaintstruct.
//	This Function is called from WM_PAINT, and pPaintstruct is (in Windows)
//	from  BeginPaint(); pPaintstruct holds the invalid rectangle to be
//	painted.
// Returns:
//	Returns FALSE on error, TRUE otherwise. 
//

#if !defined(_RTWIN_H_)
#define _RTWIN_H_

#define HANDLE_TRANSPARENT_WINDOW_BACKGROUND
#define XXXMEH_BACKGROUND_NO_GDI

//[XXXEH- We'll support this optimization in the other platforms after
// we get them working well with the basic draw code:]
#if defined(_WINDOWS)  ||  defined(_MACINTOSH) || defined(_MAC_UNIX)
//Define this to do scrolling rather than repainting window each time:
#define DO_CPU_FRIENDLY_SCROLLING
#endif

#if defined(DO_CPU_FRIENDLY_SCROLLING)
//If the following is defined, then a larger offscreen window is created and
// drawn into, and "scrolling" is handled by Blt()ing from a different source
// rectangle within that window until the edge is reached at which point the
// whole window is refreshed and the process starts over:
#define SCROLLINGVERSION_SCROLL_BY_MOVING_WINDOW
//If the following is defined, then ScrollDC() is used to do the scrolling:
#if !defined(SCROLLINGVERSION_SCROLL_BY_MOVING_WINDOW)
#define SCROLLINGVERSION_SCROLLDC
#endif //!defined(MOVE_WINDOW_TO_SCROLL_VERSION).
#define MAX_MSEC_BETWEEN_NON_SCROLLWINDOW_DRAWS  10000
#endif //defined(DO_CPU_FRIENDLY_SCROLLING)


#if !defined(WIDTHBYTES)
#define WIDTHBYTES(i)	((ULONG32)((i+31)&(~31))/8)	/* ULONG aligned ! */
#endif



#if defined(_WINDOWS)
COLORREF convertCOLORTYPEtoWinBGRColor(
	COLORTYPE RGBVal);
#endif


// MBCS helper macros
#define IS_UNICODE_CHARSET(CS)    (!(!((CS)&HX_UNICODE_CHARSET)))
#define IS_DBCS_CHARSET(CS)       (!(!((CS)&HX_DBCS_CHARSET)))
#define IS_MULTI_BYTE_CHARSET(CS) (IS_UNICODE_CHARSET(CS)||IS_DBCS_CHARSET(CS))


BOOL OnPaint(TextWindow* pTextWindow, void* pVoid, void* pPaintstruct,
#if defined(_UNIX) && (!(defined(_BEOS))) && (!(defined(_MAC_UNIX)))
	HXBitmapInfoHeader *pHeader,
#endif
	ULONG32 timeOfLastTimeSynch,
	BOOL bSomeonesBeginOrEndTimeWasCrossedOverSinceLastDraw,
	INT16 xScrollWindowAmt, INT16 yScrollWindowAmt);

// /This is OnPaint() for plain text: uses OS's native text handler to format
// and output plain text:
BOOL DrawPlainText(TextWindow* pTextWindow, void* pVoid, void* pPaintstruct,
	ULONG32 ulTimeOfCurrentDraw);


BOOL PaintBackground(TextWindow* pTextWindow, void* pPaintstruct);

#if defined(_WINDOWS)
BOOL PaintRectangle(TextWindow* pTextWindow, RECT& updateRect,
		    COLORREF rectColor, UINT32 ulOpacity,
		    BOOL bIsPaintBackgroundCall=FALSE);
#endif

BOOL ApplyTextOpacity(
#if defined(_MACINTOSH)
					  GWorldPtr   pTheMacGWorld,
					  INT32       lTotalOffscrnHeight,
#else
					  TextWindow* pTextWindow,
#endif
                      INT32       lX,
                      INT32       lY,
                      INT32       lW,
                      INT32       lH,
                      BOOL        bRowsInverted,
                      UINT32      ulColor,
                      UINT32      ulOpacity);
BOOL DoesChromaKeyChannelMatch(UINT32 ulColor,
                               UINT32 ulChromaKey,
                               UINT32 ulChromaKeyTol);
BOOL DoesChromaKeyMatch(UINT32 ulColor,
                        UINT32 ulChromaKey,
                        UINT32 ulChromaKeyTol);
                        
#if defined(_MACINTOSH)
// /NOTE: this is cross-platform-capable code, but only Mac needs to call it
// so it's in mac:mrtwin.cpp only:
BOOL applyBGOpacity(UINT32 ulOpacity, UINT32 ulBGColorNoAlpha,
	UINT32* pulBits, UINT32 ulBufferSizeIn4byteUnits,
	BOOL bSetEvenIfFullyOpaque);
#endif /* _MACINTOSH. */



#endif
