/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxstatuspositionfield.cpp,v 1.13.2.4 2004/07/09 01:48:55 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxstatuspositionfield.h"

#include "hxplayer.h"

#include "hxplayer-i18n.h"

/* We need to update at least once every 1000 ms (1 sec) */
#define POS_LABEL_UPDATE_INTERVAL 750 /* in ms */

static void hxstatus_display_position_field_class_init  (HXStatusDisplayPositionFieldClass* klass);
static void hxstatus_display_position_field_init        (HXStatusDisplayPositionField* status,
                                                         HXStatusDisplayPositionFieldClass* klass);
static void hxstatus_display_position_field_set_player  (HXStatusDisplay* status,
                                                         HXPlayer* player);

static HXStatusDisplayClass* g_parent_class = NULL;

GType
hxstatus_display_position_field_get_type (void)
{
    static GType hxstatus_display_position_field_type = 0;

    if (!hxstatus_display_position_field_type)
    {
	static const GTypeInfo hxstatus_display_position_field_info =
	    {
		sizeof (HXStatusDisplayPositionFieldClass),
		NULL,		/* base_init */
		NULL,		/* base_finalize */
		(GClassInitFunc) hxstatus_display_position_field_class_init,
		NULL,		/* class_finalize */
		NULL,		/* class_data */
		sizeof (HXStatusDisplayPositionField),
		0,		/* n_preallocs */
		(GInstanceInitFunc) hxstatus_display_position_field_init,
		NULL,           /* value_table */
	    };

	hxstatus_display_position_field_type = g_type_register_static (HX_TYPE_STATUS_DISPLAY, "HXStatusDisplayPositionField",
                                                     &hxstatus_display_position_field_info, (GTypeFlags)0);
    }

    return hxstatus_display_position_field_type;
}

static void
position_label_size_request(GtkWidget*        /* widget */,
                            GtkRequisition*   requisition,
                            HXStatusDisplayPositionField* status)
{
    gint label_width = requisition->width;
    
    if(label_width > status->preferred_width)
    {
        /* Make this width the new high water mark, so that we don't
           change our size for small changes related to the use of
           the variable width font in the label.. */
        status->preferred_width = label_width + 8;
        gtk_widget_set_size_request(GTK_WIDGET(status->position_label),
                                    status->preferred_width,
                                    requisition->height);
    }
}


GtkWidget*
hxstatus_display_position_field_new(void)
{
    HXStatusDisplayPositionField* status = (HXStatusDisplayPositionField*)g_object_new(HX_TYPE_STATUS_DISPLAY_POSITION_FIELD, NULL);

    status->position_label = gtk_label_new("0:00 / 0:00");
    gtk_misc_set_alignment(GTK_MISC(status->position_label), 1.0, 0.5);
    gtk_widget_show(status->position_label);
    g_signal_connect(status->position_label,
                     "size_request",
                     G_CALLBACK(position_label_size_request),
                     status);
        
    gtk_container_add(GTK_CONTAINER(status), status->position_label);
        
    return GTK_WIDGET(status);
}


static void
hxstatus_display_position_field_init(HXStatusDisplayPositionField* status, HXStatusDisplayPositionFieldClass* /* klass */)
{
    status->position_label = NULL;
    status->preferred_width = 0;
    status->seek_signal_handler = -1;        
}

static gchar*
get_formatted_time_from_milliseconds(guint remainder, gboolean show_hours)
{
    gint hours;
    gint minutes;
    gint seconds;
    gint milliseconds;
    gchar* formatted_time;

    // XXXRGG: Deal with longer clips?
    milliseconds = remainder % 1000;
    remainder /= 1000;

    seconds = remainder % 60;
    remainder /= 60;
    
    minutes = remainder % 60;
    remainder /= 60;

    hours = remainder;
    
    if(show_hours)
    {
        formatted_time = g_strdup_printf("%d:%02d:%02d",
                                         hours,
                                         minutes,
                                         seconds);
    }
    else
    {
        formatted_time = g_strdup_printf("%d:%02d",
                                         minutes,
                                         seconds);
    }
    
    return formatted_time;
}

/* A callback to gtk_timeout_add() */
static gboolean
hxstatus_display_position_field_update(gpointer user_data)
{
    gchar* len_string = NULL;
    gchar* pos_string = NULL;
    gchar* position;
    guint pos;
    guint len;
    gboolean show_hours = FALSE;

    HXStatusDisplayPositionField* status_position_field = HX_STATUS_DISPLAY_POSITION_FIELD(user_data);
    HXStatusDisplay* status = HX_STATUS_DISPLAY(user_data);
        
    g_return_val_if_fail(status_position_field->position_label != NULL, TRUE);

    if(status->player)
    {
        if(hx_player_is_live(status->player))
        {
            len_string = g_strdup(_("Live"));
        }
        else if(hx_player_is_indefinite_duration(status->player))
        {
            len_string = NULL;
        }
        else
        {
            len = hx_player_get_length(HX_PLAYER(status->player));        
            if(len > (60 * 60 * 1000))
            {
                show_hours = TRUE;
            }

            len_string = get_formatted_time_from_milliseconds(len, show_hours);
        }

        pos = hx_player_get_position(HX_PLAYER(status->player));
        if(pos > (60 * 60 * 1000))
        {
            show_hours = TRUE;
        }
        
        pos_string = get_formatted_time_from_milliseconds(pos, show_hours);

        if(len_string)
        {
            position = g_strdup_printf("%s / %s", pos_string, len_string);
        }
        else
        {
            position = g_strdup(pos_string);
        }
    
        gtk_label_set_text(GTK_LABEL(status_position_field->position_label), position);

        g_free(len_string);    
        g_free(pos_string);
        g_free(position);
    }
    else
    {
        gtk_label_set_text(GTK_LABEL(status_position_field->position_label),
                           "0:00 / 0:00");
    }

    return TRUE; // don't remove
}

static void
hxstatus_display_position_field_seek(HXStatusDisplayPositionField* status)
{
    hxstatus_display_position_field_update(status);
}

static void
hxstatus_display_position_field_class_init (HXStatusDisplayPositionFieldClass* klass)
{
    HXStatusDisplayClass* status_class = HX_STATUS_DISPLAY_CLASS(klass);
    g_parent_class = (HXStatusDisplayClass*)gtk_type_class(HX_TYPE_STATUS_DISPLAY);    

    status_class->set_player = hxstatus_display_position_field_set_player;
}

/* Function to hook up status display to player:
 * ============================================
 */

static void
hxstatus_display_position_field_set_player(HXStatusDisplay* status, HXPlayer* player)
{        
    HXStatusDisplayPositionField* status_position = HX_STATUS_DISPLAY_POSITION_FIELD(status);

    if(status_position->seek_signal_handler >= 0 && status->player)
    {
        g_signal_handler_disconnect(G_OBJECT(status->player),
                                    status_position->seek_signal_handler);
        
        status_position->seek_signal_handler = -1;        
    }
    
    if(player)
    {        
        /* Hook up to the player */
        status_position->seek_signal_handler = 
            g_signal_connect_swapped(G_OBJECT(player),
                                     "seek",
                                     G_CALLBACK(hxstatus_display_position_field_seek),
                                     status);
    }

    HX_STATUS_DISPLAY_CLASS(g_parent_class)->set_player(status, player);

    if(player)
    {
        hxstatus_display_set_timer(status,
                                   POS_LABEL_UPDATE_INTERVAL,
                                   hxstatus_display_position_field_update,
                                   status,
                                   TRUE,
                                   TRUE);
    }
}

