/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie <ashie@homa.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmark-separator-menu-item.c,v 1.3 2005/07/18 23:08:16 ikezoe Exp $
 */

#include "kz-bookmark-separator-menu-item.h"

#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "gobject-utils.h"
#include "kazehakase.h"
#include "gtk-utils.h"
#include "utils.h"


static void     kz_bookmark_separator_menu_item_class_init       (KzBookmarkSeparatorMenuItemClass *klass);
static void     kz_bookmark_separator_menu_item_init             (KzBookmarkSeparatorMenuItem *menu);

KZ_OBJECT_GET_TYPE(kz_bookmark_separator_menu_item, "KzBookmarkSeparatorMenuItem", KzBookmarkSeparatorMenuItem,
		   kz_bookmark_separator_menu_item_class_init, kz_bookmark_separator_menu_item_init,
		   KZ_TYPE_BOOKMARK_BASE_MENU_ITEM)

static void
kz_bookmark_separator_menu_item_class_init (KzBookmarkSeparatorMenuItemClass *klass)
{
	GTK_CONTAINER_CLASS (klass)->child_type = NULL;
}


static void
kz_bookmark_separator_menu_item_init (KzBookmarkSeparatorMenuItem *menu)
{
}


GtkWidget *
kz_bookmark_separator_menu_item_new (KzWindow *kz, KzBookmark *bookmark)
{
	KzBookmarkSeparatorMenuItem *menu;

	g_return_val_if_fail(KZ_IS_WINDOW(kz), NULL);
	g_return_val_if_fail(KZ_IS_BOOKMARK(bookmark), NULL);
	g_return_val_if_fail(kz_bookmark_is_separator(bookmark), NULL);

	menu = g_object_new(KZ_TYPE_BOOKMARK_SEPARATOR_MENU_ITEM,
			   "kz-window", kz,
			   "bookmark",  bookmark,
			   NULL);

	return GTK_WIDGET(menu);
}

