/*  Window monitor / application launcher
 *  Copyright (C) 2005-2006 UCHINO Satoshi.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include <vector>
#include <set>
#include <string>
#include "clientmgr.h"
#include "iconmgr.h"
#include "tmpfilemgr.h"

using namespace std;

class Launcher {
  ClientMgr& clientMgr;
  IconMgr& iconMgr;
  TmpFileMgr& tmpFileMgr;

  struct Item {
    string desktopfileid;   // Desktop-File Id
    string commandline;	// command line
    string icon;	// icon
  };
  typedef vector<Item> Launchers;

  Launchers launchers;

  const string desktopEntrySection;
  set<string> keySet;
  set<string> intKeySet;

  inline unsigned long getId(Launchers::size_type pos) {return pos + 1;};
  inline Launchers::size_type getPos(unsigned long id) {return id  - 1;};
  unsigned long add(Item& item);
  bool sendMenuItems(const string& prefix, unsigned long clientPtr, const string& localePref, const ClientMgr::IconPref* iconPref);
  bool sendMenuItem(const string& prefix, const string& filename, unsigned long clientPtr, const string& localePref, const ClientMgr::IconPref* iconPref);
  bool sendIcon(unsigned long id, string& iconname, unsigned long clientPtr, const ClientMgr::IconPref& iconPref);

 public:
  Launcher(ClientMgr& clientMgr, IconMgr& iconMgr, TmpFileMgr& tmpFileMgr);
  ~Launcher();
  bool launch(unsigned long id);
  bool sendAllMenuItems(unsigned long clientPtr);
  bool sendMenuIcons(unsigned long clientPtr);
};
