;;; ujisx0212ex.el --- tables between UCS and JIS X 0212 Extenstion -*- coding: iso-2022-jp-2 -*-

;; Copyright (C) 2004  ARISAWA Akihiro

;; Author: ARISAWA Akihiro <ari@mbf.sphere.ne.jp>
;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;           ISO10646, Unicode, JIS X 0212, IBM extension characters

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(defvar unicode-assoc-for-jisx0212ex
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      (
       ;; IBM extension characters
       (?$(Dss(B . "0x2170") ; SMALL ROMAN NUMERAL ONE
       (?$(Dst(B . "0x2171") ; SMALL ROMAN NUMERAL TWO
       (?$(Dsu(B . "0x2172") ; SMALL ROMAN NUMERAL THREE
       (?$(Dsv(B . "0x2173") ; SMALL ROMAN NUMERAL FOUR
       (?$(Dsw(B . "0x2174") ; SMALL ROMAN NUMERAL FIVE
       (?$(Dsx(B . "0x2175") ; SMALL ROMAN NUMERAL SIX
       (?$(Dsy(B . "0x2176") ; SMALL ROMAN NUMERAL SEVEN
       (?$(Dsz(B . "0x2177") ; SMALL ROMAN NUMERAL EIGHT
       (?$(Ds{(B . "0x2178") ; SMALL ROMAN NUMERAL NINE
       (?$(Ds|(B . "0x2179") ; SMALL ROMAN NUMERAL TEN
       (?$(Ds}(B . "0x2160") ; ROMAN NUMERAL ONE
       (?$(Ds~(B . "0x2161") ; ROMAN NUMERAL TWO
       (?$(Dt!(B . "0x2162") ; ROMAN NUMERAL THREE
       (?$(Dt"(B . "0x2163") ; ROMAN NUMERAL FOUR
       (?$(Dt#(B . "0x2164") ; ROMAN NUMERAL FIVE
       (?$(Dt$(B . "0x2165") ; ROMAN NUMERAL SIX
       (?$(Dt%(B . "0x2166") ; ROMAN NUMERAL SEVEN
       (?$(Dt&(B . "0x2167") ; ROMAN NUMERAL EIGHT
       (?$(Dt'(B . "0x2168") ; ROMAN NUMERAL NINE
       (?$(Dt((B . "0x2169") ; ROMAN NUMERAL TEN
       (?$(Dt)(B . "0xFF07") ; FULLWIDTH APOSTROPHE
       (?$(Dt*(B . "0xFF02") ; FULLWIDTH QUOTATION MARK
       (?$(Dt+(B . "0x3231") ; PARENTHESIZED IDEOGRAPH STOCK
       (?$(Dt,(B . "0x2116") ; NUMERO SIGN
       (?$(Dt-(B . "0x2121") ; TELEPHONE SIGN
       (?$(Dt.(B . "0x70BB") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt/(B . "0x4EFC") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt0(B . "0x50F4") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt1(B . "0x51EC") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt2(B . "0x5307") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt3(B . "0x5324") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt4(B . "0xFA0E") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dt5(B . "0x548A") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt6(B . "0x5759") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt7(B . "0xFA0F") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dt8(B . "0xFA10") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dt9(B . "0x589E") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt:(B . "0x5BEC") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt;(B . "0x5CF5") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt<(B . "0x5D53") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt=(B . "0xFA11") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dt>(B . "0x5FB7") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt?(B . "0x6085") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt@(B . "0x6120") ; CJK UNIFIED IDEOGRAPH
       (?$(DtA(B . "0x654E") ; CJK UNIFIED IDEOGRAPH
       (?$(DtB(B . "0x663B") ; CJK UNIFIED IDEOGRAPH
       (?$(DtC(B . "0x6665") ; CJK UNIFIED IDEOGRAPH
       (?$(DtD(B . "0xFA12") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(DtE(B . "0xF929") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(DtF(B . "0x6801") ; CJK UNIFIED IDEOGRAPH
       (?$(DtG(B . "0xFA13") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(DtH(B . "0xFA14") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(DtI(B . "0x6A6B") ; CJK UNIFIED IDEOGRAPH
       (?$(DtJ(B . "0x6AE2") ; CJK UNIFIED IDEOGRAPH
       (?$(DtK(B . "0x6DF8") ; CJK UNIFIED IDEOGRAPH
       (?$(DtL(B . "0x6DF2") ; CJK UNIFIED IDEOGRAPH
       (?$(DtM(B . "0x7028") ; CJK UNIFIED IDEOGRAPH
       (?$(DtN(B . "0xFA15") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(DtO(B . "0xFA16") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(DtP(B . "0x7501") ; CJK UNIFIED IDEOGRAPH
       (?$(DtQ(B . "0x7682") ; CJK UNIFIED IDEOGRAPH
       (?$(DtR(B . "0x769E") ; CJK UNIFIED IDEOGRAPH
       (?$(DtS(B . "0xFA17") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(DtT(B . "0x7930") ; CJK UNIFIED IDEOGRAPH
       (?$(DtU(B . "0xFA18") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(DtV(B . "0xFA19") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(DtW(B . "0xFA1A") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(DtX(B . "0xFA1B") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(DtY(B . "0x7AE7") ; CJK UNIFIED IDEOGRAPH
       (?$(DtZ(B . "0xFA1C") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dt[(B . "0xFA1D") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dt\(B . "0x7DA0") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt](B . "0x7DD6") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt^(B . "0xFA1E") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dt_(B . "0x8362") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt`(B . "0xFA1F") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dta(B . "0x85B0") ; CJK UNIFIED IDEOGRAPH
       (?$(Dtb(B . "0xFA20") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dtc(B . "0xFA21") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dtd(B . "0x8807") ; CJK UNIFIED IDEOGRAPH
       (?$(Dte(B . "0xFA22") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dtf(B . "0x8B7F") ; CJK UNIFIED IDEOGRAPH
       (?$(Dtg(B . "0x8CF4") ; CJK UNIFIED IDEOGRAPH
       (?$(Dth(B . "0x8D76") ; CJK UNIFIED IDEOGRAPH
       (?$(Dti(B . "0xFA23") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dtj(B . "0xFA24") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dtk(B . "0xFA25") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dtl(B . "0x90DE") ; CJK UNIFIED IDEOGRAPH
       (?$(Dtm(B . "0xFA26") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dtn(B . "0x9115") ; CJK UNIFIED IDEOGRAPH
       (?$(Dto(B . "0xFA27") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dtp(B . "0xFA28") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dtq(B . "0x9592") ; CJK UNIFIED IDEOGRAPH
       (?$(Dtr(B . "0xF9DC") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dts(B . "0xFA29") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dtt(B . "0x973B") ; CJK UNIFIED IDEOGRAPH
       (?$(Dtu(B . "0x974D") ; CJK UNIFIED IDEOGRAPH
       (?$(Dtv(B . "0x9751") ; CJK UNIFIED IDEOGRAPH
       (?$(Dtw(B . "0xFA2A") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dtx(B . "0xFA2B") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dty(B . "0xFA2C") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dtz(B . "0x999E") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt{(B . "0x9AD9") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt|(B . "0x9B72") ; CJK UNIFIED IDEOGRAPH
       (?$(Dt}(B . "0xFA2D") ; CJK COMPATIBILITY IDEOGRAPH
       (?$(Dt~(B . "0x9ED1") ; CJK UNIFIED IDEOGRAPH
      ))))

(tae-declare-translation
 'unicode-translation-rule-for-jisx0212ex
 unicode-assoc-for-jisx0212ex)

(provide 'ujisx0212ex)
;;; ujisx0212ex.el ends here
