/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
**
**   Created : 
**        by : Varol Okan
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
*****************************************************************************/

#include <qlistview.h>
#include <qcolordialog.h>

#include "dialogmovie.h"
#include "modifiers.h"

void DialogGeometry::initMe(QRect rect, ImageManipulator *pMan)
{
  m_pEditX->setText (QString ("%1").arg(rect.x()));
  m_pEditY->setText (QString ("%1").arg(rect.y()));
  m_pEditWidth ->setText (QString ("%1").arg(rect.width()));
  m_pEditHeight->setText (QString ("%1").arg(rect.height()));

  if ( ! pMan ) 
    return;
//	printf ("DialogGeometry::initMe count<%d>\n", pMan->listColorKeys.count());
  uint t;
  QColor theColor;
  for (t=0;t<pMan->listColorKeys.count();t++)	{
    theColor = QColor ( pMan->listColorKeys[t]->theColor );
    new ListViewColorItem ( m_pListViewCK, theColor, theColor.name ( ), QString ("%1").arg ( pMan->listColorKeys[t]->fDeltaColor ) );
  }

  connect ( m_pButtonAddCK, SIGNAL ( clicked ( ) ), this, SLOT ( slotAddColorKey    ( ) ) );
  connect ( m_pButtonDelCK, SIGNAL ( clicked ( ) ), this, SLOT ( slotDelColorKey    ( ) ) );
  connect ( m_pButtonCK,    SIGNAL ( clicked ( ) ), this, SLOT ( slotBrowseColorKey ( ) ) );

  m_rectGeometry = rect;
}

void DialogGeometry::slotWidth()
{
	if (m_pCheckAspect->isChecked())	{
		float fAspect = (float)m_rectGeometry.height() / (float)m_rectGeometry.width();
		int iWidth = m_pEditWidth->text().toInt();
		m_pEditHeight->setText (QString ("%1").arg((int)(fAspect * iWidth)));
	}
}

void DialogGeometry::slotHeight()
{
	if (m_pCheckAspect->isChecked())	{
		float fAspect = (float)m_rectGeometry.width() / (float)m_rectGeometry.height();
		int iHeight = m_pEditHeight->text().toInt();
		m_pEditWidth->setText (QString ("%1").arg((int)(fAspect * iHeight)));
	}
}

void DialogGeometry::slotAddColorKey ()
{
	float fDelta = m_pEditCK->text().toFloat();
	//QListViewItem *pItem = 
	new ListViewColorItem (m_pListViewCK, m_pButtonCK->paletteBackgroundColor(), QString (m_pButtonCK->paletteBackgroundColor().name ()), QString ("%1").arg(fDelta) );
}

void DialogGeometry::slotDelColorKey ()
{
	QListViewItem *pItem = m_pListViewCK->selectedItem ();
	// First we check if anything has been selected.
	if ( ! pItem )
		return;
	delete pItem;
}

void DialogGeometry::slotBrowseColorKey ( )
{
  QColor theColor = QColorDialog::getColor ( m_pButtonCK->paletteBackgroundColor ( ) );
  m_pButtonCK->setPaletteBackgroundColor   ( theColor );
}

