

#ifndef REPLAYGAINPLUGINLOADER_H
#define REPLAYGAINPLUGINLOADER_H

#include "pluginloaderbase.h"


/**
 * @short The complete data, how to use the backend
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ReplayGainPlugin
{
public:
    /**
     * Constructor
     */
    ReplayGainPlugin();

    /**
     * Destructor
     */
    virtual ~ReplayGainPlugin();

    QString filePathName; // the file name of th plugin (needed to detect write permissions)

    struct Info
    {
        int version;    // the version of our plugin (v0.2.1 = 201, v11.3 = 110300)
        QString name;   // the name of our plugin
        QString author; // the author of the plugin
        QString about;  // a short information aboue the plugin
    } info;

    struct ReplayGain
    {
        //PluginLoaderBase::FeatureLevel level;
        int rank;
        QString bin;
        QString param;
        QString silent_param;
        QStringList mime_types;
        QString in_files;
        QString output_single;
        QString output_multiple;
        QString force;
        QString skip;
        QString track; // TODO remove track and album (put them into param)
        QString album;
        QString remove;

        /*struct Test // obsolete
        {
            bool enabled;
            QString param;
            QString output_track;
            QString output_album;
        } test;*/
    } replaygain;
};

/**
 * @short The plugin loader for the replaygain plugins
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ReplayGainPluginLoader : public PluginLoaderBase
{
    Q_OBJECT
public:
    /**
     * Constructor
     */
    ReplayGainPluginLoader();

    /**
     * Destructor
     */
    virtual ~ReplayGainPluginLoader();

    /** is this file a replaygain plugin and loadable? */
    int verifyFile( QString );
    /** load a given file */
    ReplayGainPlugin* loadFile( QString );
};

#endif // REPLAYGAINPLUGINLOADER_H
