/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "fadedesktop_options.h"

static int FadedesktopOptionsDisplayPrivateIndex;

static CompMetadata fadedesktopOptionsMetadata;

static CompPluginVTable *fadedesktopPluginVTable = NULL;
CompPluginVTable fadedesktopOptionsVTable;

#define FADEDESKTOP_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, FadedesktopOptions, o)
#define FADEDESKTOP_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, FadedesktopOptions, o)

typedef struct _FadedesktopOptionsDisplay
{
    int screenPrivateIndex;

} FadedesktopOptionsDisplay;

typedef struct _FadedesktopOptionsScreen
{
    CompOption opt[FadedesktopScreenOptionNum];
    fadedesktopScreenOptionChangeNotifyProc notify[FadedesktopScreenOptionNum];
} FadedesktopOptionsScreen;

int fadedesktopGetFadetime (CompScreen *s)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    return os->opt[FadedesktopScreenOptionFadetime].value.i;
}

CompOption * fadedesktopGetFadetimeOption (CompScreen *s)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[FadedesktopScreenOptionFadetime];
}

void fadedesktopSetFadetimeNotify (CompScreen *s, fadedesktopScreenOptionChangeNotifyProc notify)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    os->notify[FadedesktopScreenOptionFadetime] = notify;
}

CompMatch * fadedesktopGetWindowMatch (CompScreen *s)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[FadedesktopScreenOptionWindowMatch].value.match;
}

CompOption * fadedesktopGetWindowMatchOption (CompScreen *s)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[FadedesktopScreenOptionWindowMatch];
}

void fadedesktopSetWindowMatchNotify (CompScreen *s, fadedesktopScreenOptionChangeNotifyProc notify)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    os->notify[FadedesktopScreenOptionWindowMatch] = notify;
}

CompOption * fadedesktopGetScreenOption (CompScreen *s, FadedesktopScreenOptions num)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo fadedesktopOptionsScreenOptionInfo[] = {
    { "fadetime", "int", "<min>1</min><max>5000</max>", 0, 0 },
    { "window_match", "match", 0, 0, 0 },
};

static Bool fadedesktopOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, FadedesktopScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case FadedesktopScreenOptionFadetime:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FadedesktopScreenOptionFadetime])
                (*os->notify[FadedesktopScreenOptionFadetime]) (s, o, FadedesktopScreenOptionFadetime);
            return TRUE;
        }
        break;
     case FadedesktopScreenOptionWindowMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FadedesktopScreenOptionWindowMatch])
                (*os->notify[FadedesktopScreenOptionWindowMatch]) (s, o, FadedesktopScreenOptionWindowMatch);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * fadedesktopOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    *count = FadedesktopScreenOptionNum;
    return os->opt;
}

static Bool fadedesktopOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    FadedesktopOptionsScreen *os;
    
    FADEDESKTOP_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(FadedesktopOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &fadedesktopOptionsMetadata, fadedesktopOptionsScreenOptionInfo, os->opt, FadedesktopScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void fadedesktopOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    FADEDESKTOP_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, FadedesktopScreenOptionNum);

    free (os);
}

static Bool fadedesktopOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    FadedesktopOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(FadedesktopOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[FadedesktopOptionsDisplayPrivateIndex].ptr = od;

    
    return TRUE;
}

static void fadedesktopOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    FADEDESKTOP_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);
    free (od);
}

static Bool fadedesktopOptionsInit (CompPlugin *p)
{
    FadedesktopOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (FadedesktopOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&fadedesktopOptionsMetadata, "fadedesktop",0, 0, fadedesktopOptionsScreenOptionInfo, FadedesktopScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&fadedesktopOptionsMetadata, "fadedesktop");
    if (fadedesktopPluginVTable && fadedesktopPluginVTable->init)
        return fadedesktopPluginVTable->init (p);
    return TRUE;
}

static void fadedesktopOptionsFini (CompPlugin *p)
{
    if (fadedesktopPluginVTable && fadedesktopPluginVTable->fini)
        fadedesktopPluginVTable->fini (p);

    if (FadedesktopOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (FadedesktopOptionsDisplayPrivateIndex);

    compFiniMetadata (&fadedesktopOptionsMetadata);
}

static CompBool fadedesktopOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) fadedesktopOptionsInitDisplay,
        (InitPluginObjectProc) fadedesktopOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void fadedesktopOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) fadedesktopOptionsFiniDisplay,
        (FiniPluginObjectProc) fadedesktopOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool fadedesktopOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = fadedesktopOptionsInitObject (p, o);
    if (fadedesktopPluginVTable->initObject)
        rv &= fadedesktopPluginVTable->initObject (p, o);
    return rv;
}

static void fadedesktopOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (fadedesktopPluginVTable->finiObject)
        fadedesktopPluginVTable->finiObject (p, o);
    fadedesktopOptionsFiniObject (p, o);
}

static CompOption * fadedesktopOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) 0,
        (GetPluginObjectOptionsProc) fadedesktopOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool fadedesktopOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) fadedesktopOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
fadedesktopOptionsGetMetadata (CompPlugin *plugin)
{
    return &fadedesktopOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!fadedesktopPluginVTable)
    {
        fadedesktopPluginVTable = getCompPluginInfo ();
        memcpy(&fadedesktopOptionsVTable, fadedesktopPluginVTable, sizeof(CompPluginVTable));
        fadedesktopOptionsVTable.getMetadata = fadedesktopOptionsGetMetadata;
        fadedesktopOptionsVTable.init = fadedesktopOptionsInit;
        fadedesktopOptionsVTable.fini = fadedesktopOptionsFini;
        fadedesktopOptionsVTable.initObject = fadedesktopOptionsInitObjectWrapper;
        fadedesktopOptionsVTable.finiObject = fadedesktopOptionsFiniObjectWrapper;
        fadedesktopOptionsVTable.getObjectOptions = fadedesktopOptionsGetObjectOptions;
	fadedesktopOptionsVTable.setObjectOption = fadedesktopOptionsSetObjectOption;
	
    }
    return &fadedesktopOptionsVTable;
}

