/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "mswitch_options.h"

static int MswitchOptionsDisplayPrivateIndex;

static CompMetadata mswitchOptionsMetadata;

static CompPluginVTable *mswitchPluginVTable = NULL;
CompPluginVTable mswitchOptionsVTable;

#define MSWITCH_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, MswitchOptions, o)
#define MSWITCH_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, MswitchOptions, o)

typedef struct _MswitchOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[MswitchDisplayOptionNum];
    mswitchDisplayOptionChangeNotifyProc notify[MswitchDisplayOptionNum];
} MswitchOptionsDisplay;

typedef struct _MswitchOptionsScreen
{
} MswitchOptionsScreen;

CompAction * mswitchGetBeginKey (CompDisplay *d)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    return &od->opt[MswitchDisplayOptionBeginKey].value.action;
}

void mswitchSetBeginKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    od->opt[MswitchDisplayOptionBeginKey].value.action.initiate = init;
}

void mswitchSetBeginKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    od->opt[MswitchDisplayOptionBeginKey].value.action.terminate = term;
}

CompOption * mswitchGetBeginKeyOption (CompDisplay *d)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    return &od->opt[MswitchDisplayOptionBeginKey];
}

void mswitchSetBeginKeyNotify (CompDisplay *d, mswitchDisplayOptionChangeNotifyProc notify)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    od->notify[MswitchDisplayOptionBeginKey] = notify;
}

CompAction * mswitchGetBeginButton (CompDisplay *d)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    return &od->opt[MswitchDisplayOptionBeginButton].value.action;
}

void mswitchSetBeginButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    od->opt[MswitchDisplayOptionBeginButton].value.action.initiate = init;
}

void mswitchSetBeginButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    od->opt[MswitchDisplayOptionBeginButton].value.action.terminate = term;
}

CompOption * mswitchGetBeginButtonOption (CompDisplay *d)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    return &od->opt[MswitchDisplayOptionBeginButton];
}

void mswitchSetBeginButtonNotify (CompDisplay *d, mswitchDisplayOptionChangeNotifyProc notify)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    od->notify[MswitchDisplayOptionBeginButton] = notify;
}

CompOption * mswitchGetDisplayOption (CompDisplay *d, MswitchDisplayOptions num)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo mswitchOptionsDisplayOptionInfo[] = {
    { "begin_key", "key", 0, 0, 0 },
    { "begin_button", "button", 0, 0, 0 },
};

static Bool mswitchOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, MswitchDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case MswitchDisplayOptionBeginKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[MswitchDisplayOptionBeginKey])
                (*od->notify[MswitchDisplayOptionBeginKey]) (d, o, MswitchDisplayOptionBeginKey);
            return TRUE;
        }
        break;
     case MswitchDisplayOptionBeginButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[MswitchDisplayOptionBeginButton])
                (*od->notify[MswitchDisplayOptionBeginButton]) (d, o, MswitchDisplayOptionBeginButton);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * mswitchOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    *count = MswitchDisplayOptionNum;
    return od->opt;
}

static Bool mswitchOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    MswitchOptionsScreen *os;
    
    MSWITCH_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(MswitchOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    
    return TRUE;
}

static void mswitchOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    MSWITCH_OPTIONS_SCREEN (s);

    free (os);
}

static Bool mswitchOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    MswitchOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(MswitchOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[MswitchOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &mswitchOptionsMetadata, mswitchOptionsDisplayOptionInfo, od->opt, MswitchDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void mswitchOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    MSWITCH_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, MswitchDisplayOptionNum);

    free (od);
}

static Bool mswitchOptionsInit (CompPlugin *p)
{
    MswitchOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (MswitchOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&mswitchOptionsMetadata, "mswitch",mswitchOptionsDisplayOptionInfo, MswitchDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&mswitchOptionsMetadata, "mswitch");
    if (mswitchPluginVTable && mswitchPluginVTable->init)
        return mswitchPluginVTable->init (p);
    return TRUE;
}

static void mswitchOptionsFini (CompPlugin *p)
{
    if (mswitchPluginVTable && mswitchPluginVTable->fini)
        mswitchPluginVTable->fini (p);

    if (MswitchOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (MswitchOptionsDisplayPrivateIndex);

    compFiniMetadata (&mswitchOptionsMetadata);
}

static CompBool mswitchOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) mswitchOptionsInitDisplay,
        (InitPluginObjectProc) mswitchOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void mswitchOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) mswitchOptionsFiniDisplay,
        (FiniPluginObjectProc) mswitchOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool mswitchOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = mswitchOptionsInitObject (p, o);
    if (mswitchPluginVTable->initObject)
        rv &= mswitchPluginVTable->initObject (p, o);
    return rv;
}

static void mswitchOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (mswitchPluginVTable->finiObject)
        mswitchPluginVTable->finiObject (p, o);
    mswitchOptionsFiniObject (p, o);
}

static CompOption * mswitchOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) mswitchOptionsGetDisplayOptions,
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool mswitchOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) mswitchOptionsSetDisplayOption,
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
mswitchOptionsGetMetadata (CompPlugin *plugin)
{
    return &mswitchOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!mswitchPluginVTable)
    {
        mswitchPluginVTable = getCompPluginInfo ();
        memcpy(&mswitchOptionsVTable, mswitchPluginVTable, sizeof(CompPluginVTable));
        mswitchOptionsVTable.getMetadata = mswitchOptionsGetMetadata;
        mswitchOptionsVTable.init = mswitchOptionsInit;
        mswitchOptionsVTable.fini = mswitchOptionsFini;
        mswitchOptionsVTable.initObject = mswitchOptionsInitObjectWrapper;
        mswitchOptionsVTable.finiObject = mswitchOptionsFiniObjectWrapper;
        mswitchOptionsVTable.getObjectOptions = mswitchOptionsGetObjectOptions;
	mswitchOptionsVTable.setObjectOption = mswitchOptionsSetObjectOption;
	
    }
    return &mswitchOptionsVTable;
}

