/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <qfileinfo.h>
#include <qmessagebox.h>
#include <qprocess.h>

#include <klocale.h>

void frmTags::init()
{
	pshLocation->setText(i18n("Location"));
	lblTitle->setText(i18n("Title"));
	lblAlbum->setText(i18n("Album"));
	lblArtist->setText(i18n("Artist"));
	lblYear->setText(i18n("Year"));
	lblTrack->setText(i18n("Track"));
	lblGenre->setText(i18n("Genre"));
	lblComment->setText(i18n("Comment"));

	pshCancel->setText(i18n("Cancel"));

	setCaption(i18n("Edit tags"));
}

void frmTags::acceptTags()
{
	ok = true;
	hide();
}

void frmTags::rejectTags()
{
	ok = false;
	hide();
}

void frmTags::onLocation()
{
	QProcess open_dir;
	open_dir.addArgument("konqueror");
	open_dir.addArgument(QFileInfo(txtLocation->text()).dir().path());

	if (!open_dir.start())
		QMessageBox::information(this, i18n("Info"), i18n("Failed to run Konqueror."));
}
