/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "randtree.h"

RandTree::RandTree()
{
	root = 0;
	count = 0;
}

RandTree::RandTree(const RandTree & t)
{
	root = 0;
	count = 0;

	int found = 0, i = 0;

	while (found != t.getCount())
	{
		if (t.searchForIndex(i))
		{
			addIndex(i);
			found++;
		}

		i++;
	}
}

RandTree::~RandTree()
{
	remove();
}

void RandTree::addIndex(const int & i)
{
	nod * nn = new nod(i);
	
	if (!nn)
		return;

	count++;

	if (!root)
		root = nn;
	else
		return add(nn, root);
}

void RandTree::add(const nod * const n, const nod * const r)
{
	if ((!n) || (!r))
		return;

	if (n->index < r->index)
	{
		if (r->left)
			add(n, r->left);
		else
			r->left = (nod *)n;
	}
	else
	{
		if (r->right)
			add(n, r->right);
		else
			r->right = (nod *)n;
	}
}

bool RandTree::searchForIndex(const int & i) const
{
	return search(i, root);
}

bool RandTree::search(const int & i, const nod * const r) const
{
	if (!r)
		return false;

	if (i != r->index)
	{
		if (i < r->index)
			return search(i, r->left);
		else
			return search(i, r->right);
	}
	else
		return true;
}

void RandTree::deleteIndex(const int & i)
{
	del(i, root, 0);
	count--;
}

void RandTree::del(const int & i, const nod * const r, const nod * const p)
{
	if (!r)
		return;

	if (i < r->index)
		del(i, r->left, r);
	else
	{
		if (i > r->index)
			del(i, r->right, r);
		else
		{
			if (p)
			{
				if (p->left == r)
					p->left = 0;
				else
					p->right = 0;

				add(r->left, root);
				add(r->right, root);

				delete r;
			}
			else
			{
				nod * tmp = root;

				if (root->left)
				{
					root = root->left;
					add(tmp->right, root);
				}
				else
				{
					if (root->right)
					{
						root = root->right;
						add(tmp->left, root);
					}
					else
						root = 0;
				}

				delete tmp;
			}
		}
	}
}

void RandTree::remove(const nod * const r)
{
	if (r->left)
		remove(r->left);

	if (r->right)
		remove(r->right);

	delete r;
}

void RandTree::remove()
{
	if (!root)
		return;

	remove(root);
	root = 0;
	count = 0;
}

bool RandTree::isEmpty() const
{
	if (root)
		return false;
	else
		return true;
}

int RandTree::getCount() const
{
	return count;
}
