/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "text_options.h"

static int TextOptionsDisplayPrivateIndex;

static CompMetadata textOptionsMetadata;

static CompPluginVTable *textPluginVTable = NULL;
CompPluginVTable textOptionsVTable;

#define TEXT_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, TextOptions, o)
#define TEXT_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, TextOptions, o)

typedef struct _TextOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[TextDisplayOptionNum];
    textDisplayOptionChangeNotifyProc notify[TextDisplayOptionNum];
} TextOptionsDisplay;

typedef struct _TextOptionsScreen
{
} TextOptionsScreen;

int textGetAbi (CompDisplay *d)
{
    TEXT_OPTIONS_DISPLAY(d);
    return od->opt[TextDisplayOptionAbi].value.i;
}

CompOption * textGetAbiOption (CompDisplay *d)
{
    TEXT_OPTIONS_DISPLAY(d);
    return &od->opt[TextDisplayOptionAbi];
}

void textSetAbiNotify (CompDisplay *d, textDisplayOptionChangeNotifyProc notify)
{
    TEXT_OPTIONS_DISPLAY(d);
    od->notify[TextDisplayOptionAbi] = notify;
}

CompOption * textGetDisplayOption (CompDisplay *d, TextDisplayOptions num)
{
    TEXT_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo textOptionsDisplayOptionInfo[] = {
    { "abi", "int", 0, 0, 0 },
};

static Bool textOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    TEXT_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, TextDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case TextDisplayOptionAbi:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TextDisplayOptionAbi])
                (*od->notify[TextDisplayOptionAbi]) (d, o, TextDisplayOptionAbi);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * textOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    TEXT_OPTIONS_DISPLAY(d);
    *count = TextDisplayOptionNum;
    return od->opt;
}

static Bool textOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    TextOptionsScreen *os;
    
    TEXT_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(TextOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    
    return TRUE;
}

static void textOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    TEXT_OPTIONS_SCREEN (s);

    free (os);
}

static Bool textOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    TextOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(TextOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[TextOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &textOptionsMetadata, textOptionsDisplayOptionInfo, od->opt, TextDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void textOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    TEXT_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, TextDisplayOptionNum);

    free (od);
}

static Bool textOptionsInit (CompPlugin *p)
{
    TextOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (TextOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&textOptionsMetadata, "text",textOptionsDisplayOptionInfo, TextDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&textOptionsMetadata, "text");
    if (textPluginVTable && textPluginVTable->init)
        return textPluginVTable->init (p);
    return TRUE;
}

static void textOptionsFini (CompPlugin *p)
{
    if (textPluginVTable && textPluginVTable->fini)
        textPluginVTable->fini (p);

    if (TextOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (TextOptionsDisplayPrivateIndex);

    compFiniMetadata (&textOptionsMetadata);
}

static CompBool textOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) textOptionsInitDisplay,
        (InitPluginObjectProc) textOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void textOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) textOptionsFiniDisplay,
        (FiniPluginObjectProc) textOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool textOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = textOptionsInitObject (p, o);
    if (textPluginVTable->initObject)
        rv &= textPluginVTable->initObject (p, o);
    return rv;
}

static void textOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (textPluginVTable->finiObject)
        textPluginVTable->finiObject (p, o);
    textOptionsFiniObject (p, o);
}

static CompOption * textOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) textOptionsGetDisplayOptions,
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool textOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) textOptionsSetDisplayOption,
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
textOptionsGetMetadata (CompPlugin *plugin)
{
    return &textOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!textPluginVTable)
    {
        textPluginVTable = getCompPluginInfo ();
        memcpy(&textOptionsVTable, textPluginVTable, sizeof(CompPluginVTable));
        textOptionsVTable.getMetadata = textOptionsGetMetadata;
        textOptionsVTable.init = textOptionsInit;
        textOptionsVTable.fini = textOptionsFini;
        textOptionsVTable.initObject = textOptionsInitObjectWrapper;
        textOptionsVTable.finiObject = textOptionsFiniObjectWrapper;
        textOptionsVTable.getObjectOptions = textOptionsGetObjectOptions;
	textOptionsVTable.setObjectOption = textOptionsSetObjectOption;
	
    }
    return &textOptionsVTable;
}

