/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _TILE_OPTIONS_H
#define _TILE_OPTIONS_H

#include <compiz-common.h>

COMPIZ_BEGIN_DECLS

CompPluginVTable * getCompPluginInfo (void);

typedef enum
{
    TileDisplayOptionAnimateType,
    TileDisplayOptionAnimationDuration,
    TileDisplayOptionTileToggleType,
    TileDisplayOptionTileJoin,
    TileDisplayOptionTileDelta,
    TileDisplayOptionTileLeftOccupancy,
    TileDisplayOptionExcludeMatch,
    TileDisplayOptionTileVerticallyKey,
    TileDisplayOptionTileHorizontallyKey,
    TileDisplayOptionTileTileKey,
    TileDisplayOptionTileCascadeKey,
    TileDisplayOptionTileRestoreKey,
    TileDisplayOptionTileToggleKey,
    TileDisplayOptionNum
} TileDisplayOptions;

typedef void (*tileDisplayOptionChangeNotifyProc) (CompDisplay *display, CompOption *opt, TileDisplayOptions num);

CompOption *tileGetDisplayOption (CompDisplay *d, TileDisplayOptions num);

typedef enum
{
    TileScreenOptionNum
} TileScreenOptions;

typedef void (*tileScreenOptionChangeNotifyProc) (CompScreen *screen, CompOption *opt, TileScreenOptions num);

CompOption *tileGetScreenOption (CompScreen *s, TileScreenOptions num);

typedef enum
{
    AnimateTypeNone = 0,
    AnimateTypeFilledOutline = 1,
    AnimateTypeSlide = 2,
    AnimateTypeZoom = 3,
    AnimateTypeDropFromTop = 4,
    AnimateTypeFade = 5,
} TileAnimateTypeEnum;

typedef enum
{
    TileToggleTypeTile = 0,
    TileToggleTypeLeft = 1,
    TileToggleTypeTileVertically = 2,
    TileToggleTypeTileHorizontally = 3,
    TileToggleTypeCascade = 4,
} TileTileToggleTypeEnum;

int              tileGetAnimateType (CompDisplay *d);
CompOption *     tileGetAnimateTypeOption (CompDisplay *d);
void             tileSetAnimateTypeNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify);

int              tileGetAnimationDuration (CompDisplay *d);
CompOption *     tileGetAnimationDurationOption (CompDisplay *d);
void             tileSetAnimationDurationNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify);

int              tileGetTileToggleType (CompDisplay *d);
CompOption *     tileGetTileToggleTypeOption (CompDisplay *d);
void             tileSetTileToggleTypeNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify);

Bool             tileGetTileJoin (CompDisplay *d);
CompOption *     tileGetTileJoinOption (CompDisplay *d);
void             tileSetTileJoinNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify);

int              tileGetTileDelta (CompDisplay *d);
CompOption *     tileGetTileDeltaOption (CompDisplay *d);
void             tileSetTileDeltaNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify);

int              tileGetTileLeftOccupancy (CompDisplay *d);
CompOption *     tileGetTileLeftOccupancyOption (CompDisplay *d);
void             tileSetTileLeftOccupancyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify);

CompMatch *      tileGetExcludeMatch (CompDisplay *d);
CompOption *     tileGetExcludeMatchOption (CompDisplay *d);
void             tileSetExcludeMatchNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify);

CompAction *     tileGetTileVerticallyKey (CompDisplay *d);
void             tileSetTileVerticallyKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             tileSetTileVerticallyKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     tileGetTileVerticallyKeyOption (CompDisplay *d);
void             tileSetTileVerticallyKeyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify);

CompAction *     tileGetTileHorizontallyKey (CompDisplay *d);
void             tileSetTileHorizontallyKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             tileSetTileHorizontallyKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     tileGetTileHorizontallyKeyOption (CompDisplay *d);
void             tileSetTileHorizontallyKeyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify);

CompAction *     tileGetTileTileKey (CompDisplay *d);
void             tileSetTileTileKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             tileSetTileTileKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     tileGetTileTileKeyOption (CompDisplay *d);
void             tileSetTileTileKeyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify);

CompAction *     tileGetTileCascadeKey (CompDisplay *d);
void             tileSetTileCascadeKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             tileSetTileCascadeKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     tileGetTileCascadeKeyOption (CompDisplay *d);
void             tileSetTileCascadeKeyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify);

CompAction *     tileGetTileRestoreKey (CompDisplay *d);
void             tileSetTileRestoreKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             tileSetTileRestoreKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     tileGetTileRestoreKeyOption (CompDisplay *d);
void             tileSetTileRestoreKeyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify);

CompAction *     tileGetTileToggleKey (CompDisplay *d);
void             tileSetTileToggleKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             tileSetTileToggleKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     tileGetTileToggleKeyOption (CompDisplay *d);
void             tileSetTileToggleKeyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify);

#ifndef GENERIC_PRIVATE_DEFINES
#define GENERIC_PRIVATE_DEFINES

#define GET_PLUGIN_CORE(object, plugin) \
    ((plugin##Core *) (object)->base.privates[plugin##CorePrivateIndex].ptr)
#define PLUGIN_CORE(object, plugin, prefix) \
    plugin##Core * prefix##c = GET_PLUGIN_CORE (object, plugin)

#define GET_PLUGIN_DISPLAY(object, plugin) \
    ((plugin##Display *) \
	(object)->base.privates[plugin##DisplayPrivateIndex].ptr)
#define PLUGIN_DISPLAY(object, plugin, prefix) \
    plugin##Display * prefix##d = GET_PLUGIN_DISPLAY (object, plugin)

#define GET_PLUGIN_SCREEN(object, parent, plugin) \
    ((plugin##Screen *) \
	(object)->base.privates[(parent)->screenPrivateIndex].ptr)
#define PLUGIN_SCREEN(object, plugin, prefix) \
    plugin##Screen * prefix##s = \
	GET_PLUGIN_SCREEN (object, \
	GET_PLUGIN_DISPLAY ((object)->display, plugin), plugin)

#define GET_PLUGIN_WINDOW(object, parent, plugin) \
    ((plugin##Window *) \
	(object)->base.privates[(parent)->windowPrivateIndex].ptr)
#define PLUGIN_WINDOW(object, plugin, prefix) \
    plugin##Window * prefix##w = \
	GET_PLUGIN_WINDOW  (object, \
	GET_PLUGIN_SCREEN  ((object)->screen, \
	GET_PLUGIN_DISPLAY ((object)->screen->display, plugin), plugin), plugin)

#endif

COMPIZ_END_DECLS

#endif
