/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "lyrics.h"

#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>

Lyrics::Lyrics()
{
	title = QString::null;
	artist = QString::null;
	path = QString::null;
}

Lyrics::~Lyrics()
{
	QFile::remove(path + "/tmp_lyrics");
}

void Lyrics::setPath(const QString & p)
{
	path = p;
}

void Lyrics::setTitle(const QString & t)
{
	title = t;
}

void Lyrics::setArtist(const QString & a)
{
	artist = a;
}

void Lyrics::makeLyricsDir() const
{
	QDir lyrDir(path);

	if (!lyrDir.exists())
		QDir().mkdir(lyrDir.path());
}

void Lyrics::saveAsLocal() const
{
	makeLyricsDir();

	QDir dir(path + "/" + artist.lower());

	if (!dir.exists())
		QDir().mkdir(dir.path());

	QFile fout(dir.path() + "/" + title.lower());
	
	fout.open(IO_WriteOnly);
	QTextStream strOut(&fout);
	strOut << lyrics;
	fout.close();
}

QString Lyrics::getFromLocal()
{
	lyrics = QString::null;

	QFile fin(path + "/" + artist.lower() + "/" + title.lower());
	
	if (fin.exists())
	{
		fin.open(IO_ReadOnly);
		QTextStream strIn(&fin);
		for (;;)
		{
			lyrics += strIn.readLine();
		
			if (fin.atEnd())
				break;
			else
				lyrics += "\n";
		}
		fin.close();
	}

	return lyrics;
}

QString Lyrics::getFromBuffer(QBuffer * buffer)
{
	makeLyricsDir();

	lyrics = QString::null;
	
	if (!buffer)
		return lyrics;

	QFile tmpFile(path + "/tmp_lyrics");

	QFile::remove(tmpFile.name());

	tmpFile.open(IO_WriteOnly);
	QTextStream * streamOut = new QTextStream(&tmpFile);
	if (!streamOut) return lyrics;
	(*streamOut) << (QString)buffer->buffer();
	streamOut->unsetDevice();
	tmpFile.close();

	delete streamOut;
	streamOut = 0;

	delete buffer;
	buffer = 0;

	tmpFile.open(IO_ReadOnly);
	QTextStream * streamIn = new QTextStream(&tmpFile);
	if (!streamIn) return lyrics;
	
	QString tmp(QString::null);

	for (unsigned short int i = 0 ; i != 116 ; i++)
	{
		if ((tmp = streamIn->readLine()) == QString::null)
		{
			streamIn->unsetDevice();
			delete streamIn;
			tmpFile.close();
			return lyrics;
		}
	}

	lyrics = tmp.right(tmp.length() - tmp.find("<p>", 0) - 3);

	if ((!lyrics.isEmpty()) && (lyrics.find("</p>", 0) == -1))
	{
		do
		{
			if (tmpFile.atEnd())
			{
				streamIn->unsetDevice();
				delete streamIn;
				tmpFile.close();
				return lyrics;
			}

			tmp = streamIn->readLine();
			lyrics += tmp;
		}
		while (tmp.find("</p>") == -1);
	}

	lyrics.remove("</p>", false);
	lyrics.replace("<br />", "\n");
	lyrics.remove("</td>", false);
	
	unsigned int i = (lyrics.length() - 1);
	while (lyrics.at(i) == '\n')
		lyrics.remove(i, 1);

	streamIn->unsetDevice();
	tmpFile.close();

	delete streamIn;
	streamIn = 0;

	if (!lyrics.isEmpty())
		saveAsLocal();

	return lyrics;
}
