/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef RANDTREE_H
#define RANDTREE_H

struct nod
{
	nod(const int & i)
	{
		index = i;
		left = 0;
		right = 0;
	}

	int index;

	mutable nod * left;
	mutable nod * right;
};

class RandTree
{
	public:
		RandTree();
		RandTree(const RandTree & t);
		~RandTree();

		void addIndex(const int & i);
		bool searchForIndex(const int & i) const;
		void deleteIndex(const int & i);

		void remove();
		bool isEmpty() const;
		int getCount() const;

	private:
		void add(const nod * const n, const nod * const r);
		void del(const int & i, const nod * const r, const nod * const p);
		bool search(const int & i, const nod * const r) const;
		void remove(const nod * const r);

		nod * root;

		int count;
};

#endif
