/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * CompoundFontFamily.java
 * ------------
 */

package org.pentaho.reporting.libraries.fonts.merge;

import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;

/**
 * Creation-Date: 20.07.2007, 18:54:28
 *
 * @author Thomas Morgner
 */
public class CompoundFontFamily implements FontFamily
{
  private FontFamily base;
  private FontRegistry registry;

  public CompoundFontFamily(final FontFamily base,
                            final FontRegistry registry)
  {
    if (registry instanceof CompoundFontRegistry)
    {
      throw new IllegalStateException();
    }
    this.base = base;
    this.registry = registry;
  }

  public FontRegistry getRegistry()
  {
    return registry;
  }

  public String getFamilyName()
  {
    return base.getFamilyName();
  }

  public String[] getAllNames()
  {
    return base.getAllNames();
  }

  public FontRecord getFontRecord(final boolean bold, final boolean italics)
  {
    return new CompoundFontRecord(base.getFontRecord(bold, italics), this, bold, italics);
  }
}
