/***************************************************************************
 *   Copyright (C) 2005 by TAM (Teppei Tamra)   *
 *   tam-t@par.odn.ne.jp   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "honokasetupkde.h"
#include <qlabel.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qurl.h>
#include <qtooltip.h>
#include <kfiledialog.h>
#include <skim/skimkeygrabber.h>

// Item

HonokaSetupKdeItem::HonokaSetupKdeItem(scim::String _label,scim::String _name,scim::String _tip) : QObject(0)
{
    label = QString::fromLocal8Bit(_label.c_str());
    name = _name;
    tip = QString::fromLocal8Bit(_tip.c_str());

    valueWidget = 0;
    labelWidget = 0;

}

HonokaSetupKdeItem::~HonokaSetupKdeItem()
{
}

QWidget * HonokaSetupKdeItem::getValueWidget()
{
    if (!valueWidget) {
        createValueWidget();
        QToolTip::add(valueWidget,tip);
    }
    static_cast<QLabel *>(getLabelWidget())->setBuddy(valueWidget);
    return valueWidget;
}

QWidget * HonokaSetupKdeItem::getLabelWidget()
{
    if (!labelWidget) createLabelWidget();
    return labelWidget;
}


void HonokaSetupKdeItem::readConfig(scim::ConfigPointer cfg)
{
}

void HonokaSetupKdeItem::saveConfig(scim::ConfigPointer cfg)
{
}

QString HonokaSetupKdeItem::getLabel()
{
    return label;
}

void HonokaSetupKdeItem::createLabelWidget()
{
    QString l = label;
    l.replace(QChar('_'),QChar('&'));
    labelWidget = new QLabel(0,"label");
    labelWidget->setText(l);
    labelWidget->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
    labelWidget->hide();
}

void HonokaSetupKdeItem::createValueWidget()
{
    valueWidget = new QLabel(0,"value");
    static_cast<QLabel *>(valueWidget)->setText(label);
    valueWidget->hide();
}

void HonokaSetupKdeItem::createTipWidget()
{
}

// Container

HonokaSetupKdeContainer::HonokaSetupKdeContainer()
{
}


HonokaSetupKdeContainer::~HonokaSetupKdeContainer()
{
}

void HonokaSetupKdeContainer::append(HonokaSetupKdeItem *item)
{
}

// HonokaSetupKde

HonokaSetupKde::HonokaSetupKde(scim::String _label,scim::String _name,scim::String _tip)
: HonokaSetupKdeItem(_label,_name,_tip),HonokaSetupKdeContainer()
{
}

HonokaSetupKde::~HonokaSetupKde()
{
}

void HonokaSetupKde::readConfig(scim::ConfigPointer cfg)
{
    for(unsigned int i = 0;i < items.size();i ++) {
        items[i]->readConfig(cfg);
    }
    return;
}

void HonokaSetupKde::saveConfig(scim::ConfigPointer cfg)
{
    for(unsigned int i = 0;i < items.size();i ++) {
        items[i]->saveConfig(cfg);
    }
    return;
}

void HonokaSetupKde::append(HonokaSetupKdeItem *item)
{
    items.append(item);
    connect(item,SIGNAL(changed()),this,SIGNAL(changed()));
    item->getValueWidget()->reparent(getValueWidget(),QPoint());
    item->getValueWidget()->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    static_cast<QTabWidget *>(getValueWidget())->addTab(item->getValueWidget(),item->getLabel());
    item->getValueWidget()->show();
}

void HonokaSetupKde::createValueWidget()
{
    valueWidget = new QTabWidget(0,"Tab");
    valueWidget->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    valueWidget->hide();
}

HonokaSetupKdeItem *HonokaSetupKde::HonokaSetupCoreToKde(Honoka::HonokaSetupCoreItem *item)
{
   if (item->getType() == HONOKA_SETUP_ITEM_ENTRY) {
        return new HonokaSetupKdeEntryItem(item->getLabel(),item->getName(),item->getTip(),item->getStringData());
    }
    if (item->getType() == HONOKA_SETUP_ITEM_KEY) {
        return new HonokaSetupKdeKeyItem(item->getLabel(),item->getName(),item->getTip(),item->getStringData());
    }
    if (item->getType() == HONOKA_SETUP_ITEM_FILE) {
        return new HonokaSetupKdeFileItem(item->getLabel(),item->getName(),item->getTip(),item->getStringData());
    }
    if (item->getType() == HONOKA_SETUP_ITEM_BOOL) {
        return new HonokaSetupKdeBoolItem(item->getLabel(),item->getName(),item->getTip(),item->getBoolData());
    }
    if (item->getType() == HONOKA_SETUP_ITEM_INT) {
        return new HonokaSetupKdeIntItem(item->getLabel(),item->getName(),item->getTip(),item->getIntData(),
            item->getIntLower(),item->getIntUpper());
    }
    if (item->getType() == HONOKA_SETUP_ITEM_SELECT) {
        return new HonokaSetupKdeSelectItem(item->getLabel(),item->getName(),item->getTip(),item->getStringData(),
            item->getStringListData());
    }
    if (item->getType() == HONOKA_SETUP_ITEM_PAGE) {
        HonokaSetupKdePage *page = new HonokaSetupKdePage(item->getLabel(),item->getName(),item->getTip());
        for(unsigned int i = 0;i < static_cast<Honoka::HonokaSetupCorePage *>(item)->getChildren().size(); i ++) {
            page->append(HonokaSetupCoreToKde(static_cast<Honoka::HonokaSetupCorePage *>(item)->getChildren()[i]));
        }
        return page;
    }
    if (item->getType() == HONOKA_SETUP_ITEM_SETUP) {
        HonokaSetupKde *page = new HonokaSetupKde(item->getLabel(),item->getName(),item->getTip());
        for(unsigned int i = 0;i < static_cast<Honoka::HonokaSetupCore *>(item)->getChildren().size(); i ++) {
            page->append(HonokaSetupCoreToKde(static_cast<Honoka::HonokaSetupCore *>(item)->getChildren()[i]));
        }
        return page;
    }
    return 0;

}

// Page

HonokaSetupKdePage::HonokaSetupKdePage(scim::String _label,scim::String _name,scim::String _tip)
: HonokaSetupKdeItem(_label,_name,_tip),HonokaSetupKdeContainer()
{
}

HonokaSetupKdePage::~HonokaSetupKdePage()
{
}

void HonokaSetupKdePage::append(HonokaSetupKdeItem *item)
{
    items.append(item);
    connect(item,SIGNAL(changed()),this,SIGNAL(changed()));
    item->getLabelWidget()->reparent(getValueWidget(),QPoint());
    item->getLabelWidget()->setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum);
    item->getValueWidget()->reparent(getValueWidget(),QPoint());
    item->getValueWidget()->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Minimum);
    table->addWidget(item->getLabelWidget(),items.count() - 1,0);
    table->addWidget(item->getValueWidget(),items.count() - 1,1);
    item->getValueWidget()->show();
    item->getLabelWidget()->show();
}

void HonokaSetupKdePage::readConfig(scim::ConfigPointer cfg)
{
    for(unsigned int i = 0;i < items.size();i ++) {
        items[i]->readConfig(cfg);
    }
    return;
}

void HonokaSetupKdePage::saveConfig(scim::ConfigPointer cfg)
{
    for(unsigned int i = 0;i < items.size();i ++) {
        items[i]->saveConfig(cfg);
    }
    return;
}

void HonokaSetupKdePage::createValueWidget()
{
    valueWidget = new QWidget(0,"Page");
    valueWidget->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    valueWidget->hide();
    table = new QGridLayout(valueWidget,0,0,4);
    spacer = new QSpacerItem(1,1,QSizePolicy::Minimum,QSizePolicy::Expanding);
    //table->addItem(spacer,99,0);
    table->addMultiCell(spacer,99,100,0,1);
}



// String


HonokaSetupKdeEntryItem::HonokaSetupKdeEntryItem(scim::String _label,scim::String _name,scim::String _tip,scim::String _default)
: HonokaSetupKdeItem(_label,_name,_tip)
{
    stringData = _default;
}

HonokaSetupKdeEntryItem::~HonokaSetupKdeEntryItem()
{
}

void HonokaSetupKdeEntryItem::readConfig(scim::ConfigPointer cfg)
{
    stringData = cfg->read(scim::String(name.latin1()),scim::String(stringData.local8Bit().data()));
    static_cast<QLineEdit *>(getValueWidget())->setText(stringData);
    return;
}

void HonokaSetupKdeEntryItem::saveConfig(scim::ConfigPointer cfg)
{
    cfg->write(scim::String(name.latin1()),scim::String(stringData.local8Bit().data()));
    return;
}

void HonokaSetupKdeEntryItem::createValueWidget()
{
    valueWidget = new QLineEdit(0,"String");
    valueWidget->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Minimum);
    static_cast<QLineEdit *>(valueWidget)->setText(stringData);
    valueWidget->hide();
    connect(valueWidget,SIGNAL(textChanged(const QString &)),this,SLOT(textChanged(const QString &)));
}

void HonokaSetupKdeEntryItem::textChanged(const QString &text)
{
    stringData = text;
    emit changed();
}

// Bool


HonokaSetupKdeBoolItem::HonokaSetupKdeBoolItem(scim::String _label,scim::String _name,scim::String _tip,bool _default)
: HonokaSetupKdeItem(_label,_name,_tip)
{
    boolData = _default;
}

HonokaSetupKdeBoolItem::~HonokaSetupKdeBoolItem()
{
}

void HonokaSetupKdeBoolItem::readConfig(scim::ConfigPointer cfg)
{
    boolData = cfg->read(scim::String(name.latin1()),boolData);
    static_cast<QCheckBox *>(getValueWidget())->setChecked(boolData);
    return;
}

void HonokaSetupKdeBoolItem::saveConfig(scim::ConfigPointer cfg)
{
    cfg->write(scim::String(name.latin1()),boolData);
    return;
}

void HonokaSetupKdeBoolItem::createValueWidget()
{
    valueWidget = new QCheckBox(0,"Bool");
    valueWidget->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Minimum);
    static_cast<QCheckBox *>(valueWidget)->setChecked(boolData);
    valueWidget->hide();
    connect(valueWidget,SIGNAL(clicked()),this,SLOT(clicked()));
}

void HonokaSetupKdeBoolItem::clicked()
{
    boolData = static_cast<QCheckBox *>(valueWidget)->isOn();
    emit changed();
}


// File


HonokaSetupKdeFileItem::HonokaSetupKdeFileItem(scim::String _label,scim::String _name,scim::String _tip,scim::String _default)
: HonokaSetupKdeItem(_label,_name,_tip)
{
    stringData = _default;
}

HonokaSetupKdeFileItem::~HonokaSetupKdeFileItem()
{
}

void HonokaSetupKdeFileItem::readConfig(scim::ConfigPointer cfg)
{
    stringData = cfg->read(scim::String(name.latin1()),scim::String(stringData.local8Bit().data()));
    if (!getValueWidget()) return;
    le->setText(stringData);
    return;
}

void HonokaSetupKdeFileItem::saveConfig(scim::ConfigPointer cfg)
{
    cfg->write(scim::String(name.latin1()),scim::String(stringData.local8Bit().data()));
    return;
}

void HonokaSetupKdeFileItem::createValueWidget()
{
    valueWidget = new QWidget(0,"File");
    valueWidget->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Minimum);
    le = new QLineEdit(valueWidget,"File-LineEdit");
    le->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Minimum);
    QPushButton *b = new QPushButton(valueWidget,"File-Button");
    b->setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum);
    b->setText("...");
    QHBoxLayout *l = new QHBoxLayout(valueWidget);
    l->addWidget(le);
    l->addWidget(b);
    le->setText(stringData);
    valueWidget->hide();
    connect(le,SIGNAL(textChanged(const QString &)),this,SLOT(textChanged(const QString &)));
    connect(b,SIGNAL(clicked()),this,SLOT(buttonClicked()));
}

void HonokaSetupKdeFileItem::textChanged(const QString &text)
{
    stringData = text;
    emit changed();
}

void HonokaSetupKdeFileItem::buttonClicked()
{
    QString d = KFileDialog::getOpenFileName(QUrl(stringData).dirPath());
    if (d != stringData) {
        le->setText(d);
        stringData = d; // ס
    }
}

// Key


HonokaSetupKdeKeyItem::HonokaSetupKdeKeyItem(scim::String _label,scim::String _name,scim::String _tip,scim::String _default)
: HonokaSetupKdeItem(_label,_name,_tip)
{
    stringData = _default;
}

HonokaSetupKdeKeyItem::~HonokaSetupKdeKeyItem()
{
}

void HonokaSetupKdeKeyItem::readConfig(scim::ConfigPointer cfg)
{
    stringData = cfg->read(scim::String(name.latin1()),scim::String(stringData.latin1()));
    if (!getValueWidget()) return;
    le->setText(stringData);
    return;
}

void HonokaSetupKdeKeyItem::saveConfig(scim::ConfigPointer cfg)
{
    cfg->write(scim::String(name.latin1()),scim::String(stringData.latin1()));
    return;
}

void HonokaSetupKdeKeyItem::createValueWidget()
{
    valueWidget = new QWidget(0,"Key");
    valueWidget->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Minimum);
    le = new QLineEdit(valueWidget,"Key-LineEdit");
    le->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Minimum);
    QPushButton *b = new QPushButton(valueWidget,"Key-Button");
    b->setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum);
    b->setText("...");
    QHBoxLayout *l = new QHBoxLayout(valueWidget);
    l->addWidget(le);
    l->addWidget(b);
    le->setText(stringData);
    valueWidget->hide();
    connect(le,SIGNAL(textChanged(const QString &)),this,SLOT(textChanged(const QString &)));
    connect(b,SIGNAL(clicked()),this,SLOT(buttonClicked()));
}

void HonokaSetupKdeKeyItem::textChanged(const QString &text)
{
    stringData = text;
    emit changed();
}

void HonokaSetupKdeKeyItem::buttonClicked()
{
    SkimShortcutListEditor *d = new SkimShortcutListEditor();
    d->setModal(true);
    QStringList s = QStringList::split(",",stringData);
    d->setStringList(s);
    if (d->exec() == QDialog::Accepted) {
        le->setText(d->getCombinedString());
        stringData = d->getCombinedString();
    }
    delete d;
}

// Int


HonokaSetupKdeIntItem::HonokaSetupKdeIntItem(scim::String _label,scim::String _name,scim::String _tip,int _default,int lower,int upper)
: HonokaSetupKdeItem(_label,_name,_tip)
{
    intData = _default;
    upperValue = upper;
    lowerValue = lower;
}

HonokaSetupKdeIntItem::~HonokaSetupKdeIntItem()
{
}

void HonokaSetupKdeIntItem::readConfig(scim::ConfigPointer cfg)
{
    intData = cfg->read(scim::String(name.latin1()),intData);
    static_cast<QSpinBox *>(getValueWidget())->setValue(intData);
    return;
}

void HonokaSetupKdeIntItem::saveConfig(scim::ConfigPointer cfg)
{
    cfg->write(scim::String(name.latin1()),intData);
    return;
}

void HonokaSetupKdeIntItem::createValueWidget()
{
    valueWidget = new QSpinBox(lowerValue,upperValue,1,0,"Int");
    valueWidget->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Minimum);
    static_cast<QSpinBox *>(valueWidget)->setValue(intData);
    valueWidget->hide();
    connect(valueWidget,SIGNAL(valueChanged(int)),this,SLOT(valueChanged(int)));
}

void HonokaSetupKdeIntItem::valueChanged(int value)
{
    intData = value;
    emit changed();
}


// Select


HonokaSetupKdeSelectItem::HonokaSetupKdeSelectItem(scim::String _label,scim::String _name,scim::String _tip,scim::String _default,std::vector<scim::String> _list)
: HonokaSetupKdeItem(_label,_name,_tip)
{
    stringData = _default;
    for(unsigned int i = 0;i < _list.size();i ++) list.append(_list[i]);
}

HonokaSetupKdeSelectItem::~HonokaSetupKdeSelectItem()
{
}

void HonokaSetupKdeSelectItem::readConfig(scim::ConfigPointer cfg)
{
    stringData = cfg->read(scim::String(name.latin1()),scim::String(stringData.local8Bit().data()));
    static_cast<QComboBox *>(getValueWidget())->setCurrentText(stringData);
    return;
}

void HonokaSetupKdeSelectItem::saveConfig(scim::ConfigPointer cfg)
{
    cfg->write(scim::String(name.latin1()),scim::String(stringData.local8Bit().data()));
    return;
}

void HonokaSetupKdeSelectItem::createValueWidget()
{
    valueWidget = new QComboBox(0,"Select");
    valueWidget->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Minimum);
    static_cast<QComboBox *>(valueWidget)->insertStringList(list);
    static_cast<QComboBox *>(valueWidget)->setCurrentText(stringData);
    valueWidget->hide();
    connect(valueWidget,SIGNAL(activated(int)),this,SLOT(activated(int)));
}

void HonokaSetupKdeSelectItem::activated(int pos)
{
    stringData = list[pos];
    emit changed();
}



