/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGWIDGETCOLLECTIONDESIGNERPLUGIN_H
#define SKGWIDGETCOLLECTIONDESIGNERPLUGIN_H
/** @file
 * A collection of widgets for skrooge (qt designer plugin).
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <QDesignerCustomWidgetCollectionInterface>

#include <kglobal.h>
#include "skgbasegui_export.h"
/**
 * QDesigner plugin collection
 */
class SKGBASEGUI_EXPORT SKGWidgetCollectionDesignerPlugin: public QObject, public QDesignerCustomWidgetCollectionInterface
{
        Q_OBJECT
        Q_INTERFACES(QDesignerCustomWidgetCollectionInterface);

public:
        /**
         * Constructor
         * @param parent the parent
         */
        SKGWidgetCollectionDesignerPlugin(QObject *parent = 0);

        /**
         * To get the list of widgets
         * @return the list of widgets
         */
        virtual QList<QDesignerCustomWidgetInterface*> customWidgets() const;

private:
        QList<QDesignerCustomWidgetInterface*> widgets;
};

#endif // SKGWIDGETCOLLECTIONDESIGNERPLUGIN_H
