/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbankplugin.h"
#include "skgbankpluginwidget.h"
#include "skgbankboardwidget.h"
#include "skgbank_settings.h"
#include "skgtraces.h"

K_PLUGIN_FACTORY(SKGBankPluginFactory, registerPlugin<SKGBankPlugin>();)
K_EXPORT_PLUGIN(SKGBankPluginFactory("skrooge_bank", "skrooge_bank"))

SKGBankPlugin::SKGBankPlugin(QObject* iParent, const QVariantList& /*iArg*/)
                :SKGInterfacePlugin(iParent), currentBankDocument(NULL)
{
        SKGTRACEIN(10, "SKGBankPlugin::SKGBankPlugin");
}

SKGBankPlugin::~SKGBankPlugin()
{
        SKGTRACEIN(10, "SKGBankPlugin::~SKGBankPlugin");
        currentBankDocument=NULL;
}

void SKGBankPlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
        SKGTRACEIN(10, "SKGBankPlugin::setupActions");
        Q_UNUSED(iArgument);

        currentBankDocument=iDocument;
}

void SKGBankPlugin::close()
{
        SKGTRACEIN(10, "SKGBankPlugin::close");
}

int SKGBankPlugin::getNbDashboardWidgets()
{
        return 1;
}

QString SKGBankPlugin::getDashboardWidgetTitle(int iIndex)
{
        if (iIndex==0) return i18nc("Noun, a list of items","Accounts");
        return "";
}

SKGWidget* SKGBankPlugin::getDashboardWidget(int iIndex)
{
        if (iIndex==0) return new SKGBankBoardWidget(currentBankDocument);
        return NULL;
}

SKGTabWidget* SKGBankPlugin::getWidget()
{
        SKGTRACEIN(10, "SKGBankPlugin::getWidget");
        return new SKGBankPluginWidget((SKGDocumentBank*) currentBankDocument);
}

QWidget* SKGBankPlugin::getPreferenceWidget()
{
        SKGTRACEIN(10, "SKGBankPlugin::getPreferenceWidget");
        /*        QWidget* widget=new QWidget();
                ui.setupUi(widget);*/

        return NULL;
}

KConfigSkeleton* SKGBankPlugin::getPreferenceSkeleton()
{
        return skgbank_settings::self();
}

QString SKGBankPlugin::title() const
{
        return i18n("Bank and Account");
}

QString SKGBankPlugin::icon() const
{
        return "kwalletmanager";
}

QString SKGBankPlugin::statusTip () const
{
        return i18n("Bank and account management (creation, update ...)");
}

QString SKGBankPlugin::toolTip () const
{
        return i18n("Bank and account management");
}

QStringList SKGBankPlugin::tips() const
{
        QStringList output;
        output.push_back(i18n("<p>... you can associate a logo with your banks.</p>"));
        return output;
}

int SKGBankPlugin::getOrder() const
{
        //Must be one of the first
        return 10;
}

bool SKGBankPlugin::isInContext() const
{
        return true;
}
#include "skgbankplugin.moc"
