/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for debug.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgdebugplugin.h"
#include "skgdebugpluginwidget.h"
#include "skgmainpanel.h"
#include "skgtraces.h"

#include <kactioncollection.h>

K_PLUGIN_FACTORY(SKGDebugPluginFactory, registerPlugin<SKGDebugPlugin>();)
K_EXPORT_PLUGIN(SKGDebugPluginFactory("skrooge_debug", "skrooge_debug"))

SKGDebugPlugin::SKGDebugPlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
        SKGTRACEIN(10, "SKGDebugPlugin::SKGDebugPlugin");
}

SKGDebugPlugin::~SKGDebugPlugin()
{
        SKGTRACEIN(10, "SKGDebugPlugin::~SKGDebugPlugin");
        currentBankDocument=NULL;
}

void SKGDebugPlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
        SKGTRACEIN(10, "SKGDebugPlugin::setupActions");
        Q_UNUSED(iArgument);

        currentBankDocument=iDocument;

        setComponentData ( SKGDebugPluginFactory::componentData() );
        setXMLFile ( "skrooge_debug.rc" );

        //Menu
        KAction* restartProfiling = new KAction ( KIcon ( "fork" ), i18n ( "&Restart profiling" ), this );
        connect ( restartProfiling, SIGNAL ( triggered ( bool ) ), this, SLOT ( actionRestartProfiling() ) );
        actionCollection()->addAction ( QLatin1String ( "debug_restart_profiling" ), restartProfiling );
        restartProfiling->setShortcut ( Qt::CTRL+Qt::Key_Pause );

        if (SKGMainPanel::getMainPanel()) SKGMainPanel::getMainPanel()->registedGlobalAction ( "debug_restart_profiling", restartProfiling );

        KAction* openProfiling = new KAction ( KIcon ( "fork" ), i18n ( "&Open profiling" ), this );
        connect ( openProfiling, SIGNAL ( triggered ( bool ) ), this, SLOT ( actionOpenProfiling() ) );
        actionCollection()->addAction ( QLatin1String ( "debug_open_profiling" ), openProfiling );
        openProfiling->setShortcut ( Qt::ALT+Qt::Key_Pause );

        if (SKGMainPanel::getMainPanel()) SKGMainPanel::getMainPanel()->registedGlobalAction ( "debug_open_profiling", openProfiling );
}

void SKGDebugPlugin::close()
{
        SKGTRACEIN(10, "SKGDebugPlugin::close");
}

SKGTabWidget* SKGDebugPlugin::getWidget()
{
        SKGTRACEIN(10, "SKGDebugPlugin::getWidget");
        return new SKGDebugPluginWidget(currentBankDocument);
}

QString SKGDebugPlugin::title() const
{
        return i18nc("Noun, a plugin allowing to access the SQLite database, useful to debug skrooge","Debug");
}

QString SKGDebugPlugin::icon() const
{
        return "tools-report-bug";
}

QString SKGDebugPlugin::statusTip () const
{
        return i18n("Useful for debug");
}

QString SKGDebugPlugin::toolTip () const
{
        return i18n("Useful for debug");
}

bool SKGDebugPlugin::isInContext() const
{
        return true;
}

bool SKGDebugPlugin::isEnabled() const
{
        return (SKGTraces::SKGLevelTrace>0 || SKGTraces::SKGPerfo);
}

void SKGDebugPlugin::actionRestartProfiling()
{
        SKGTraces::cleanProfilingStatistics();
}

void SKGDebugPlugin::actionOpenProfiling()
{
        //Call operation plugin
        QDomDocument doc("SKGML");
        QDomElement root=doc.createElement("parameters");
        doc.appendChild(root);

        QString dumpString;
        QStringList dump=SKGTraces::getProfilingStatistics();

        int nbl=dump.count();
        for (int i=0; i<nbl; ++i) {
                dumpString+=dump[i];
                dumpString+='\n';
        }

        root.setAttribute ( "sqlResult", dumpString );

        if (SKGMainPanel::getMainPanel()) SKGMainPanel::getMainPanel()->setNewTabContent ( SKGMainPanel::getMainPanel()->getPluginByName ( "Skrooge debug plugin" ), -1, doc.toString() );
}
#include "skgdebugplugin.moc"
