/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGOPERATIONPLUGINWIDGET_H
#define SKGOPERATIONPLUGINWIDGET_H
/** @file
* This file is Skrooge plugin for bank management.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "ui_skgoperationpluginwidget_base.h"
#include "skgtabwidget.h"
#include "skgoperationobject.h"
#include "skgsuboperationobject.h"

#include <QDomDocument>

class SKGDocumentBank;
class SKGObjectModel;
class KAction;

/**
 * This file is Skrooge plugin for operation management
 */
class SKGOperationPluginWidget : public SKGTabWidget
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGOperationPluginWidget(SKGDocumentBank* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGOperationPluginWidget();

        /**
         * Get the current selection
         * @return selected objects
         */
        virtual SKGObjectBase::SKGListSKGObjectBase getSelectedObjects();

        /**
         * Get the number of seleted object
         * @return number of selected objects
         */
        virtual int getNbSelectedObjects();

        /**
         * Get the table view
         * @return the table view
         */
        virtual SKGTableView* getTableView();

        /**
         * Get the current state
         * MUST BE OVERWRITTEN
         * @return a string containing all information needed to set the same state.
         * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState ( const QString& iState );

        /**
         * Get attribute name to save the default state
         * MUST BE OVERWRITTEN
         * @return attribute name to save the default state.
         */
        virtual QString getDefaultStateAttribute();

        /**
         * Get the widget must be printed
         * @return a widget
         */
        virtual QWidget* getWidgetForPrint();

        /**
         * Set or not the template mode
         * @param iTemplate the template mode
         */
        virtual void setTemplateMode(bool iTemplate);

        /**
         * Open an operation in an operations page
         * @param iOperation the operation to open
         */
        static void openOperation(const SKGOperationObject& iOperation);

public slots:
        /**
        * Refresh the content.
         */
        virtual void refresh();

private slots:
        void onOperationCreatorModified();
        void onAddOperationClicked();
        void onUpdateOperationClicked();
        void onFilterChanged();
        void onResetInternalFilter();
        void onSelectionChanged();
        void onFocusChanged();
        void onFastEdition();
        void onDoubleClick();
        void onQuantityChanged();
        void onSubopCellChanged ( int row,int column );
        void onRemoveSubOperation();
        void onRefreshInformationZone();
        void onRotateAccountTools();
        void onValidatePointedOperations();
        void onBtnModeClicked();
        void onTemplateModeClicked();
        void cleanEditor();

private:
        Q_DISABLE_COPY ( SKGOperationPluginWidget );

        SKGError getSelectedOperation ( SKGOperationObject& operation );


        bool isTemplateMode();
        int getCurrentMode();
        void setCurrentMode(int iMode);
        void displaySubOperations();
        void displaySubOperations ( const SKGOperationObject& iOperation );
        double getRemainingQuantity();
        void addSubOperationLine ( int row, const QString& category, const QString& tracker, const QString& comment, double quantity, int id=0 );
        SKGError updateSelection ( const SKGObjectBase::SKGListSKGObjectBase& iSelection, bool forceCreation=false);
        void fillNumber();
        void fillComboBoxes();

        Ui::skgoperationplugin_base ui;
        SKGObjectModel* objectModel;
        QString operationWhereClause;
        QDomDocument lastState;

        KAction* fastEditionAction;
        KAction* fastEditionWthoutAmountAction;

        QString lastFastEditionWhereClause;
        int lastFastEditionOperationFound;
        bool showClosedAccounts;

        bool numberFieldIsNotUptodate;
        int modeInfoZone;
        int mode;
        bool modeTemplate;
};

#endif // SKGOPERATIONPLUGINWIDGET_H
