/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * ##DESCRIPTION##.
 *
 * @author ##AUTHOR##
 */
#include "skgxxxpluginwidget.h"
#include "skgmainpanel.h"
#include "skgtraces.h"
#include "skgdocument.h"

#include <QDomDocument>

SKGXXXPluginWidget::SKGXXXPluginWidget(SKGDocument* iDocument)
                :SKGTabWidget(iDocument)
{
        SKGTRACEIN(1, "SKGXXXPluginWidget::SKGXXXPluginWidget");

        ui.setupUi(this);

        //Build you panel here
}

SKGXXXPluginWidget::~SKGXXXPluginWidget()
{
        SKGTRACEIN(1, "SKGXXXPluginWidget::~SKGXXXPluginWidget");
}

QString SKGXXXPluginWidget::getState()
{
        SKGTRACEIN(10, "SKGXXXPluginWidget::getState");
        QDomDocument doc("SKGML");
        QDomElement root = doc.createElement("parameters");
        doc.appendChild(root);

        //Get state
        //Example: QString account=root.attribute ( "account");
        //         if (account.isEmpty()) root.setAttribute("account", ui.kDisplayAccountCombo->currentText());

        return doc.toString();
}

void SKGXXXPluginWidget::setState(const QString& iState )
{
        SKGTRACEIN(10, "SKGXXXPluginWidget::setState");
        QDomDocument doc("SKGML");
        doc.setContent(iState);
        QDomElement root = doc.documentElement();

        //Set state
        //Example: QString account=root.attribute ( "account");
}

QString SKGXXXPluginWidget::getDefaultStateAttribute()
{
        return "";
}

QWidget* SKGXXXPluginWidget::getWidgetForPrint()
{
        return this;
}

void SKGXXXPluginWidget::refresh()

{
        SKGTRACEIN(1, "SKGXXXPluginWidget::refresh");

        QSqlDatabase* db = getDocument()->getDatabase();
        setEnabled(db!=NULL);
        if (db!=NULL) {
                //Refresh yours widgets here
        }
}

#include "skgxxxpluginwidget.moc"


