/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGPREDICATCREATOR_H
#define SKGPREDICATCREATOR_H
/** @file
 * A query creator for skrooge.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbankgui_export.h"

#include <QWidget>
#include <QtDesigner/QDesignerExportWidget>

class SKGDocument;
class SKGComboBox;

/**
 * This file is a query creator for skrooge
 */
class SKGBANKGUI_EXPORT SKGPredicatCreator : public QWidget
{
        Q_OBJECT
        /**
         * Text of the predicat
         */
        Q_PROPERTY( QString text READ text USER true)

        /**
         * XML description of the predicat
         */
        Q_PROPERTY( QString xmlDescription READ xmlDescription WRITE setXmlDescription)

public:
        /**
         * Default Constructor
         * @param parent the parent
         * @param document the document
         * @param attribute name of the attribute
         * @param iSQL to enable sql mode
         * @param iListAtt list of attribute
         */
        explicit SKGPredicatCreator(QWidget *parent = 0, SKGDocument* document=NULL, const QString& attribute="",
                                    bool iSQL=false, const QStringList& iListAtt=QStringList());

        /**
         * Default Destructor
         */
        virtual ~SKGPredicatCreator();

        /**
         * Get text
         * @return text
         */
        virtual QString text();

        /**
         * Get Text from XML description
         * @param iXML the description
         */
        static QString getTextFromXml(const QString& iXML);

        /**
         * Get XML description
         * @return description
         */
        virtual QString xmlDescription();

        /**
         * Set XML description
         * @param iXML the description
         */
        virtual void setXmlDescription(const QString& iXML);

signals:
        /**
         * Sent when edition is finished
         */
        void editingFinished();

protected :
        /**
         * Event filtering
         * @param object object
         * @param event event
         * @return In your reimplementation of this function, if you want to filter the event out, i.e. stop it being handled further, return true; otherwise return false.
         */
        bool eventFilter ( QObject *object, QEvent *event );

private slots:
        void onOperatorChanged();

private:
        Q_DISABLE_COPY(SKGPredicatCreator);
        bool updateMode;

        SKGComboBox* kOperator;
        QWidget* kValue1;
        QWidget* kValue2;
        SKGComboBox* kAttributes;
};

#endif // SKGPREDICATCREATOR_H
