/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgimportexportmanager.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
        Q_UNUSED(argc);
        Q_UNUSED(argv);

        //Init test
        SKGINITTEST(true);

        //============================================================================
        {
                //Test import OFX skrooge
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);

                SKGError err;
                //Initialisation document
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::OFX, getTestPath("IN")+"/skgtestimportofx/385366.ofx");
                        SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
                        document1.dump(DUMPOPERATION|DUMPACCOUNT);
                }

                //Check static methods
                {
                        SKGRuleObject::getListOfOperators(SKGServices::TEXT, SKGRuleObject::SEARCH);
                        SKGRuleObject::getListOfOperators(SKGServices::INTEGER, SKGRuleObject::SEARCH);
                        SKGRuleObject::getListOfOperators(SKGServices::FLOAT, SKGRuleObject::SEARCH);
                        SKGRuleObject::getListOfOperators(SKGServices::DATE, SKGRuleObject::SEARCH);
                        SKGRuleObject::getListOfOperators(SKGServices::BOOL, SKGRuleObject::SEARCH);
                        SKGRuleObject::getListOfOperators(SKGServices::TRISTATE, SKGRuleObject::SEARCH);
                        SKGRuleObject::getListOfOperators(SKGServices::BOOL, SKGRuleObject::SEARCH);
                        SKGRuleObject::getListOfOperators(SKGServices::BOOL, SKGRuleObject::SEARCH);
                        SKGRuleObject::getListOfOperators(SKGServices::BOOL, SKGRuleObject::SEARCH);

                        SKGRuleObject::getListOfOperators(SKGServices::TEXT, SKGRuleObject::UPDATE);
                        SKGRuleObject::getListOfOperators(SKGServices::INTEGER, SKGRuleObject::UPDATE);
                        SKGRuleObject::getListOfOperators(SKGServices::FLOAT, SKGRuleObject::UPDATE);
                        SKGRuleObject::getListOfOperators(SKGServices::DATE, SKGRuleObject::UPDATE);
                        SKGRuleObject::getListOfOperators(SKGServices::BOOL, SKGRuleObject::UPDATE);
                        SKGRuleObject::getListOfOperators(SKGServices::TRISTATE, SKGRuleObject::UPDATE);
                        SKGRuleObject::getListOfOperators(SKGServices::BOOL, SKGRuleObject::UPDATE);
                        SKGRuleObject::getListOfOperators(SKGServices::BOOL, SKGRuleObject::UPDATE);
                        SKGRuleObject::getListOfOperators(SKGServices::BOOL, SKGRuleObject::UPDATE);

                        SKGRuleObject::getListOfOperators(SKGServices::TEXT, SKGRuleObject::ALARM);
                }

                //Rule creation
                SKGRuleObject rule1;
                {
                        SKGBEGINTRANSACTION(document1, "RULE_1", err);

                        //Create rule
                        rule1=SKGRuleObject(&document1);
                        QString searchDef="<element> <!--OR-->"
                                          "<element>  <!--AND-->"
                                          "<element attribute=\"t_comment\" operator=\"#ATT#='#V1S#'\" value=\"REINVESTMENT\"/>"
                                          "</element>"
                                          "</element>";
                        SKGTESTERROR("RULE:setXMLSearchDefinition", rule1.setXMLSearchDefinition(searchDef), true);
                        SKGTEST("RULE:getXMLSearchDefinition", rule1.getXMLSearchDefinition(), searchDef);

                        QString actionDef="<element> <!--OR-->"
                                          "<element>  <!--AND-->"
                                          "<element attribute=\"t_payee\" operator=\"#ATT#='#V1#'\" value=\"modified\" />"
                                          "</element>"
                                          "</element>";
                        SKGTESTERROR("RULE:setXMLActionDefinition", rule1.setXMLActionDefinition(actionDef), true);
                        SKGTEST("RULE:getXMLActionDefinition", rule1.getXMLActionDefinition(), actionDef);

                        SKGTESTERROR("RULE:setSearchDescription", rule1.setSearchDescription("search description"), true);
                        SKGTEST("RULE:getSearchDescription", rule1.getSearchDescription(), "search description");
                        SKGTESTERROR("RULE:setActionDescription", rule1.setActionDescription("action description"), true);
                        SKGTEST("RULE:getActionDescription", rule1.getActionDescription(), "action description");

                        SKGTESTERROR("RULE:setActionType", rule1.setActionType(SKGRuleObject::UPDATE), true);
                        SKGTEST("RULE:getActionType", rule1.getActionType(), SKGRuleObject::UPDATE);

                        SKGTESTERROR("RULE:setOrder", rule1.setOrder(-1), true);
                        SKGTEST("RULE:getOrder", rule1.getOrder(), 1);

                        SKGTESTERROR("UNIT:save", rule1.save(), true);
                        SKGTESTERROR("UNIT:load", rule1.load(), true);

                        SKGRuleObject rule1bis=SKGRuleObject(rule1);
                        SKGRuleObject rule1ter=SKGRuleObject((SKGObjectBase) rule1);
                        rule1bis=(SKGObjectBase) rule1;
                }

                //Rule creation (ALARM)
                SKGRuleObject alarm1;
                {
                        SKGBEGINTRANSACTION(document1, "ALARM_1", err);

                        //Create rule
                        alarm1=SKGRuleObject(&document1);
                        QString searchDef="<element> <!--OR-->"
                                          "<element>  <!--AND-->"
                                          "<element attribute=\"t_comment\" operator=\"#ATT#='#V1S#'\" value=\"REINVESTMENT\"/>"
                                          "</element>"
                                          "</element>";
                        SKGTESTERROR("RULE:setXMLSearchDefinition", alarm1.setXMLSearchDefinition(searchDef), true);
                        SKGTEST("RULE:getXMLSearchDefinition", alarm1.getXMLSearchDefinition(), searchDef);

                        QString actionDef="<element> <!--OR-->"
                                          "<element>  <!--AND-->"
                                          "<element attribute=\"f_REALCURRENTAMOUNT\" operator=\"ABS(TOTAL(#ATT#))#OP##V1#,ABS(TOTAL(#ATT#)), #V1#, '#V2S#'\" value=\"100\" value2=\"Take care!\"operator2=\">=\"/>"
                                          "</element>"
                                          "</element>";
                        SKGTESTERROR("RULE:setXMLActionDefinition", alarm1.setXMLActionDefinition(actionDef), true);
                        SKGTEST("RULE:getXMLActionDefinition", alarm1.getXMLActionDefinition(), actionDef);

                        SKGTESTERROR("RULE:setSearchDescription", alarm1.setSearchDescription("search description"), true);
                        SKGTEST("RULE:getSearchDescription", alarm1.getSearchDescription(), "search description");
                        SKGTESTERROR("RULE:setActionDescription", alarm1.setActionDescription("action description"), true);
                        SKGTEST("RULE:getActionDescription", alarm1.getActionDescription(), "action description");

                        SKGTESTERROR("RULE:setActionType", alarm1.setActionType(SKGRuleObject::ALARM), true);
                        SKGTEST("RULE:getActionType", alarm1.getActionType(), SKGRuleObject::ALARM);

                        SKGTESTERROR("RULE:setOrder", alarm1.setOrder(-1), true);
                        SKGTEST("RULE:getOrder", alarm1.getOrder(), 2);

                        SKGTESTERROR("UNIT:save", alarm1.save(), true);
                        SKGTESTERROR("UNIT:load", alarm1.load(), true);

                        SKGTEST("RULE:getAlarmInfo", alarm1.getAlarmInfo().Message, "Take care!");
                        SKGTEST("RULE:getAlarmInfo", alarm1.getAlarmInfo().Amount, 121.41);
                        SKGTEST("RULE:getAlarmInfo", alarm1.getAlarmInfo().Limit, 100);
                }

                //Process rule1
                {
                        SKGBEGINTRANSACTION(document1, "PROCESS_1", err);
                        SKGTESTERROR("RULE:execute", rule1.execute(), true);
                }


                document1.dump(DUMPOPERATION|DUMPACCOUNT);
        }

        //End test
        SKGENDTEST();
}
