/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * Display a summary of your information.
 *
 * @author Guillaume DE BURE
 */
#include "skgdashboard2pluginwidget.h"
#include "skgmainpanel.h"
#include "skgtraces.h"
#include "skgdocument.h"

#include <QDomDocument>


SKGDashboard2PluginWidget::SKGDashboard2PluginWidget(SKGDocument* iDocument)
                :SKGTabPage(iDocument)
{
        SKGTRACEIN(1, "SKGDashboard2PluginWidget::SKGDashboard2PluginWidget");

        ui.setupUi(this);
        
        ui.SKGDashboardView->setBackgroundBrush(QBrush(Qt::lightGray));
        // Create a plasma containement for our skroogoids
        dashboardCorona = new SKGCorona(this);
        ui.SKGDashboardView->setScene(dashboardCorona);
                      
               
}

SKGDashboard2PluginWidget::~SKGDashboard2PluginWidget()
{
        SKGTRACEIN(1, "SKGDashboard2PluginWidget::~SKGDashboard2PluginWidget");
}

QString SKGDashboard2PluginWidget::getState()
{
        SKGTRACEIN(10, "SKGDashboard2PluginWidget::getState");
        QDomDocument doc("SKGML");
        QDomElement root = doc.createElement("parameters");
        doc.appendChild(root);

        //Get state
        //Example: QString account=root.attribute ( "account");
        //         if (account.isEmpty()) root.setAttribute("account", ui.kDisplayAccountCombo->currentText());

        return doc.toString();
}

void SKGDashboard2PluginWidget::setState(const QString& iState )
{
        SKGTRACEIN(10, "SKGDashboard2PluginWidget::setState");
        QDomDocument doc("SKGML");
        doc.setContent(iState);
        QDomElement root = doc.documentElement();

        //Set state
        //Example: QString account=root.attribute ( "account");
}

QString SKGDashboard2PluginWidget::getDefaultStateAttribute()
{
        return "";
}

QWidget* SKGDashboard2PluginWidget::getWidgetForPrint()
{
        return this;
}

void SKGDashboard2PluginWidget::refresh()

{
        SKGTRACEIN(1, "SKGDashboard2PluginWidget::refresh");

        QSqlDatabase* db = getDocument()->getDatabase();
        setEnabled(db!=NULL);
        if (db!=NULL) {
                //Refresh yours widgets here
        }
}

#include "skgdashboard2pluginwidget.moc"


