/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGDASHBOARD2PLUGINWIDGET_H
#define SKGDASHBOARD2PLUGINWIDGET_H
/** @file
 * Display a summary of your information
*
* @author Guillaume DE BURE
*/
#include "ui_skgdashboard2pluginwidget_base.h"
#include "skgtabpage.h"
#include "skgcorona.h"

/**
 * Display a summary of your information
 */
class SKGDashboard2PluginWidget : public SKGTabPage
{
        Q_OBJECT
    SKGCorona* dashboardCorona;

public:
        /**
         * Default Constructor
         */
        SKGDashboard2PluginWidget(SKGDocument* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGDashboard2PluginWidget();

        /**
         * Get the current state
         * MUST BE OVERWRITTEN
         * @return a string containing all information needed to set the same state.
         * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState(const QString& iState);

        /**
         * Get attribute name to save the default state
         * MUST BE OVERWRITTEN
         * @return attribute name to save the default state.
         */
        virtual QString getDefaultStateAttribute();

        /**
         * Get the widget must be printed
         * @return a widget
         */
        virtual QWidget* getWidgetForPrint();

public slots:
        /**
        * Refresh the content.
         */
        virtual void refresh();

private slots:


private:
        Q_DISABLE_COPY(SKGDashboard2PluginWidget);

        Ui::skgdashboard2plugin_base ui;
        
};

#endif // SKGDASHBOARD2PLUGINWIDGET_H
