/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgreportboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgmainpanel.h"
#include "skgreportpluginwidget.h"

SKGReportBoardWidget::SKGReportBoardWidget ( SKGDocument* iDocument )
        : SKGWidget ( iDocument )
{
    SKGTRACEIN ( 10, "SKGReportBoardWidget::SKGReportBoardWidget" );

    ui.setupUi ( this );

    graph=new SKGReportPluginWidget ( ( SKGDocumentBank* ) iDocument, true );
    ui.gridLayout->addWidget(graph, 0, 0, 1, 1);
    this->setMinimumSize(200, 200);
}

SKGReportBoardWidget::~SKGReportBoardWidget()
{
    SKGTRACEIN ( 10, "SKGReportBoardWidget::~SKGReportBoardWidget" );
}

QString SKGReportBoardWidget::getState()
{
    return (graph ? graph->getState() : "");
}

void SKGReportBoardWidget::setState ( const QString& iState )
{
    if(graph) graph->setState(iState);
}


#include "skgreportboardwidget.moc"
