/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgalarmboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgservices.h"
#include "skgaccountobject.h"
#include "skgunitobject.h"
#include "skgmainpanel.h"
#include "skgruleobject.h"

#include <kaction.h>

#include <QDomDocument>
#include <QProgressBar>

SKGAlarmBoardWidget::SKGAlarmBoardWidget ( SKGDocument* iDocument )
        : SKGWidget ( iDocument )
{
    SKGTRACEIN ( 10, "SKGAlarmBoardWidget::SKGAlarmBoardWidget" );

    ui.setupUi ( this );

    //Refresh
    connect ( ( const QObject* ) getDocument(), SIGNAL ( tableModified ( QString, int ) ), this, SLOT ( dataModified ( QString, int ) ), Qt::QueuedConnection );
    dataModified ( "", 0 );
}

SKGAlarmBoardWidget::~SKGAlarmBoardWidget()
{
    SKGTRACEIN ( 10, "SKGAlarmBoardWidget::~SKGAlarmBoardWidget" );
}

void SKGAlarmBoardWidget::dataModified ( const QString& iTableName, int iIdTransaction )
{
    SKGTRACEIN ( 10, "SKGAlarmBoardWidget::dataModified" );
    Q_UNUSED ( iIdTransaction );

    if ( iTableName=="operation" || iTableName=="rule" || iTableName.isEmpty() )
    {
        //Remove all item of the layout
        QLayoutItem *child=NULL;
        while ( ( child = ui.layout->takeAt ( 0 ) ) != 0 )
        {
            delete child;
        }

        //Fill layout
        SKGDocumentBank* doc= ( SKGDocumentBank* ) getDocument();
        SKGServices::SKGUnitInfo primary=doc->getPrimaryUnit();
        SKGServices::SKGUnitInfo secondary=doc->getSecondaryUnit();

        SKGObjectBase::SKGListSKGObjectBase rules;
        SKGError err=SKGObjectBase::getObjects ( doc, "v_rule", "t_action_type='A' ORDER BY i_ORDER", rules );
        int nb=rules.count();
        if ( nb )
        {
            for ( int i=0; err.isSucceeded() && i<nb; ++i )
            {
                SKGRuleObject rule=rules.at ( i );
                SKGRuleObject::SKGAlarmInfo alarm=rule.getAlarmInfo();

                //Create progress bar
                QProgressBar* progressBar = new QProgressBar ( ui.groupBox );
                progressBar->setObjectName ( QString::fromUtf8 ( "progressBar" ) );
                progressBar->setMaximum ( qMax ( alarm.Amount, alarm.Limit ) );
                progressBar->setValue ( alarm.Amount );

                QSizePolicy sizePolicy ( QSizePolicy::Preferred, QSizePolicy::Fixed );
                sizePolicy.setHorizontalStretch ( 0 );
                sizePolicy.setVerticalStretch ( 0 );
                sizePolicy.setHeightForWidth ( progressBar->sizePolicy().hasHeightForWidth() );
                progressBar->setSizePolicy ( sizePolicy );

                //Set tooltip
                QString txt=alarm.Message+"<br>";
                txt+=doc->formatMoney ( alarm.Amount, primary ) + " / "+doc->formatMoney ( alarm.Limit, primary );
                if ( !secondary.Name.isEmpty() && secondary.Value )
                {
                    txt+="<br>"+doc->formatMoney ( alarm.Amount, secondary ) + " / "+doc->formatMoney ( alarm.Limit, secondary );
                }
                progressBar->setToolTip ( txt );

                //Change color
                double pourcent=100*alarm.Amount/alarm.Limit;
                QString st=progressBar->styleSheet();
                st=QString ( " QProgressBar { text-align: center; padding: 0.5px;} QProgressBar::chunk {text-align: center; border-radius:4px; background-color: " ) + ( pourcent<70 ? "green": ( pourcent>90 ? "red": "yellow" ) ) +";}"+st;
                progressBar->setStyleSheet ( st );

                //Add progress bar
                ui.layout->addWidget ( progressBar );
            }
        }
        else
        {
            QLabel* lab=new QLabel ( ui.groupBox );
            lab->setTextInteractionFlags ( Qt::LinksAccessibleByMouse|Qt::TextSelectableByMouse );
            lab->setText ( i18n ( "No alarm defined on the <a href=\"___\">\"Search and process\"</a> page." ) );
            connect ( lab, SIGNAL ( linkActivated ( QString ) ), this, SLOT ( onOpen ( QString ) ) );

            //Add progress bar
            ui.layout->addWidget ( lab );
        }

        //Add spacer
        ui.layout->addItem ( new QSpacerItem ( 20, 40, QSizePolicy::Minimum, QSizePolicy::Expanding ) );
    }
}

void SKGAlarmBoardWidget::onOpen ( const QString& iLink )
{
    QDomDocument doc ( "SKGML" );
    if ( iLink=="___" )
    {
        doc.setContent ( getDocument()->getParameter ( "SKGSEARCH_DEFAULT_PARAMETERS" ) );
        SKGMainPanel::getMainPanel()->setNewTabContent ( SKGMainPanel::getMainPanel()->getPluginByName ( "Skrooge search plugin" ), -1, doc.toString() );
    }
}
#include "skgalarmboardwidget.moc"
