# Copyright (c) 2010 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

'''For each argument, writes a line suitable for inclusion in an RC file to
include the file named as argument as a binary resource.
'''


import os
import sys

if __name__ == '__main__':
  if len(sys.argv) < 3:
    print 'ERROR: Usage: generate_packing_list.py OUTPUT ARG1 [ARGX]*'
    sys.exit(1)

  out = open(sys.argv[1], 'w')
  out.write('// Automatically generated by generate_packing_list.py\n')
  for arg in sys.argv[2:]:
    out.write('%s BINARY\n' % os.path.basename(arg))
    arg = arg.replace('\\', '/')
    out.write('"%s"\n' % arg)
  out.close()
