/*
 *  Copyright (C) 1999-2000 Harri Porten (porten@kde.org)
 *  Copyright (C) 2001 Peter Kelly (pmk@post.com)
 *  Copyright (C) 2003, 2004, 2005, 2006, 2007, 2008, 2009 Apple Inc. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef MachineStackMarker_h
#define MachineStackMarker_h

#include <wtf/Noncopyable.h>
#include <wtf/ThreadingPrimitives.h>

#if ENABLE(JSC_MULTIPLE_THREADS)
#include <pthread.h>
#endif

namespace JSC {

    class Heap;
    class ConservativeSet;

    class MachineStackMarker {
        WTF_MAKE_NONCOPYABLE(MachineStackMarker);
    public:
        MachineStackMarker(Heap*);
        ~MachineStackMarker();

        void markMachineStackConservatively(ConservativeSet&);

#if ENABLE(JSC_MULTIPLE_THREADS)
        void makeUsableFromMultipleThreads();
        void registerThread(); // Only needs to be called by clients that can use the same heap from multiple threads.
#endif

    private:
        void markCurrentThreadConservatively(ConservativeSet&);
        void markCurrentThreadConservativelyInternal(ConservativeSet&);

#if ENABLE(JSC_MULTIPLE_THREADS)
        class Thread;

        static void unregisterThread(void*);

        void unregisterThread();
        void markOtherThreadConservatively(ConservativeSet&, Thread*);
#endif

        Heap* m_heap;

#if ENABLE(JSC_MULTIPLE_THREADS)
        Mutex m_registeredThreadsMutex;
        Thread* m_registeredThreads;
        pthread_key_t m_currentThreadRegistrar;
#endif
    };

} // namespace JSC

#endif // MachineStackMarker_h
