#!/usr/bin/python
# Copyright (c) 2010 The Chromium OS Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

"""This program generates a C++ header file containing the input method
whitelist information from chromeos-assets/input_methods/whitelist.txt

It will produce output that looks like:

// This file is automatically generated by gen_input_method_whitelist.py
#ifndef CHROMEOS_INPUT_METHOD_WHITELIST_H_
#define CHROMEOS_INPUT_METHOD_WHITELIST_H_

namespace {
const char* kInputMethodIdsWhitelist[] = {
  "chewing",
  "hangul",
  "mozc",
  ...
};
}  // namespace

#endif  // CHROMEOS_INPUT_METHOD_WHITELIST_H_
"""

import fileinput
import re
import sys


OUTPUT_HEADER = """
// This file is automatically generated by gen_input_method_whitelist.py
#ifndef CHROMEOS_INPUT_METHOD_WHITELIST_H_
#define CHROMEOS_INPUT_METHOD_WHITELIST_H_

namespace {
const char* kInputMethodIdsWhitelist[] = {
"""

OUTPUT_FOOTER = """
};
}  // namespace

#endif  // CHROMEOS_INPUT_METHOD_WHITELIST_H_
"""


def main():
  if len(sys.argv) != 2:
    print >> sys.stderr, 'Usage: gen_input_method_whitelist.py [file]'
    sys.exit(1)
  print OUTPUT_HEADER
  for line in fileinput.input(sys.argv[1]):
    line = re.sub(r'#.*', '', line)  # Remove comments.
    line = line.split()
    if len(line) > 0:
      print '  "%s",' % line[0]
  print OUTPUT_FOOTER


if __name__ == '__main__':
  main()
