#!python
# Copyright 2010 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# DO NOT EDIT. This is an ETW event descriptor file generated by
# sawbuck/py/generate_descriptor.py. It contains event descriptions for
# MOF GUID {90cbdc39-4a3e-11d1-84f4-0000f80464e3}.

from etw.descriptors import event, field


class Event(object):
  GUID = '{90cbdc39-4a3e-11d1-84f4-0000f80464e3}'
  Name = (GUID, 0)
  FileCreate = (GUID, 32)
  FileDelete = (GUID, 35)
  FileRundown = (GUID, 36)
  Create = (GUID, 64)
  Cleanup = (GUID, 65)
  Close = (GUID, 66)
  Read = (GUID, 67)
  Write = (GUID, 68)
  SetInfo = (GUID, 69)
  Delete = (GUID, 70)
  Rename = (GUID, 71)
  DirEnum = (GUID, 72)
  Flush = (GUID, 73)
  QueryInfo = (GUID, 74)
  FSControl = (GUID, 75)
  OperationEnd = (GUID, 76)
  DirNotify = (GUID, 77)


class FileIo(event.EventCategory):
  GUID = Event.GUID
  VERSION = 2

  class FileIo_ReadWrite(event.EventClass):
    _event_types_ = [Event.Read,
                     Event.Write]
    _fields_ = [('Offset', field.UInt64),
                ('IrpPtr', field.Pointer),
                ('TTID', field.Pointer),
                ('FileObject', field.Pointer),
                ('FileKey', field.Pointer),
                ('IoSize', field.UInt32),
                ('IoFlags', field.UInt32)]

  class FileIo_Create(event.EventClass):
    _event_types_ = [Event.Create]
    _fields_ = [('IrpPtr', field.Pointer),
                ('TTID', field.Pointer),
                ('FileObject', field.Pointer),
                ('CreateOptions', field.UInt32),
                ('FileAttributes', field.UInt32),
                ('ShareAccess', field.UInt32),
                ('OpenPath', field.WString)]

  class FileIo_Name(event.EventClass):
    _event_types_ = [Event.FileCreate,
                     Event.FileDelete,
                     Event.FileRundown,
                     Event.Name]
    _fields_ = [('FileObject', field.Pointer),
                ('FileName', field.WString)]

  class FileIo_Info(event.EventClass):
    _event_types_ = [Event.Delete,
                     Event.FSControl,
                     Event.QueryInfo,
                     Event.Rename,
                     Event.SetInfo]
    _fields_ = [('IrpPtr', field.Pointer),
                ('TTID', field.Pointer),
                ('FileObject', field.Pointer),
                ('FileKey', field.Pointer),
                ('ExtraInfo', field.Pointer),
                ('InfoClass', field.UInt32)]

  class FileIo_SimpleOp(event.EventClass):
    _event_types_ = [Event.Cleanup,
                     Event.Close,
                     Event.Flush]
    _fields_ = [('IrpPtr', field.Pointer),
                ('TTID', field.Pointer),
                ('FileObject', field.Pointer),
                ('FileKey', field.Pointer)]

  class FileIo_DirEnum(event.EventClass):
    _event_types_ = [Event.DirEnum,
                     Event.DirNotify]
    _fields_ = [('IrpPtr', field.Pointer),
                ('TTID', field.Pointer),
                ('FileObject', field.Pointer),
                ('FileKey', field.Pointer),
                ('Length', field.UInt32),
                ('InfoClass', field.UInt32),
                ('FileIndex', field.UInt32),
                ('FileName', field.WString)]

  class FileIo_OpEnd(event.EventClass):
    _event_types_ = [Event.OperationEnd]
    _fields_ = [('IrpPtr', field.Pointer),
                ('ExtraInfo', field.Pointer),
                ('NtStatus', field.UInt32)]


class FileIo_V0(event.EventCategory):
  GUID = Event.GUID
  VERSION = 0

  class FileIo_V0_Name(event.EventClass):
    _event_types_ = [Event.Name]
    _fields_ = [('FileObject', field.Pointer),
                ('FileName', field.WString)]


class FileIo_V1(event.EventCategory):
  GUID = Event.GUID
  VERSION = 1

  class FileIo_V1_Name(event.EventClass):
    _event_types_ = [Event.FileCreate,
                     Event.Name]
    _fields_ = [('FileObject', field.Pointer),
                ('FileName', field.WString)]
