#!python
# Copyright 2010 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# DO NOT EDIT. This is an ETW event descriptor file generated by
# sawbuck/py/generate_descriptor.py. It contains event descriptions for
# MOF GUID {3d6fa8d1-fe05-11d0-9dda-00c04fd7ba7c}.

from etw.descriptors import event, field


class Event(object):
  GUID = '{3d6fa8d1-fe05-11d0-9dda-00c04fd7ba7c}'
  Start = (GUID, 1)
  End = (GUID, 2)
  DCStart = (GUID, 3)
  DCEnd = (GUID, 4)
  CSwitch = (GUID, 36)
  CompCS = (GUID, 37)
  SetPriority = (GUID, 48)
  SetBasePriority = (GUID, 49)
  ReadyThread = (GUID, 50)
  SetPagePriority = (GUID, 51)
  SetIoPriority = (GUID, 52)
  ThreadAffinity = (GUID, 53)
  WorkerThread = (GUID, 57)


class Thread_V2(event.EventCategory):
  GUID = Event.GUID
  VERSION = 2

  class WorkerThread(event.EventClass):
    _event_types_ = [Event.WorkerThread]
    _fields_ = [('TThreadId', field.UInt32),
                ('StartTime', field.UInt64),
                ('ThreadRoutine', field.Pointer)]

  class CSwitch(event.EventClass):
    _event_types_ = [Event.CSwitch]
    _fields_ = [('NewThreadId', field.UInt32),
                ('OldThreadId', field.UInt32),
                ('NewThreadPriority', field.Int8),
                ('OldThreadPriority', field.Int8),
                ('PreviousCState', field.UInt8),
                ('SpareByte', field.Int8),
                ('OldThreadWaitReason', field.Int8),
                ('OldThreadWaitMode', field.Int8),
                ('OldThreadState', field.Int8),
                ('OldThreadWaitIdealProcessor', field.Int8),
                ('NewThreadWaitTime', field.UInt32),
                ('Reserved', field.UInt32)]

  class ThreadAffinity(event.EventClass):
    _event_types_ = [Event.ThreadAffinity]
    _fields_ = [('Affinity', field.Pointer),
                ('ThreadId', field.UInt32),
                ('Group', field.UInt16),
                ('Reserved', field.UInt16)]

  class CompCS(event.EventClass):
    _event_types_ = [Event.CompCS]
    _fields_ = []

  class ReadyThread(event.EventClass):
    _event_types_ = [Event.ReadyThread]
    _fields_ = [('TThreadId', field.UInt32),
                ('AdjustReason', field.Int8),
                ('AdjustIncrement', field.Int8),
                ('Flag', field.Int8),
                ('Reserved', field.Int8)]

  class Thread_V2_TypeGroup1(event.EventClass):
    _event_types_ = [Event.DCEnd,
                     Event.DCStart,
                     Event.End,
                     Event.Start]
    _fields_ = [('ProcessId', field.UInt32),
                ('TThreadId', field.UInt32),
                ('StackBase', field.Pointer),
                ('StackLimit', field.Pointer),
                ('UserStackBase', field.Pointer),
                ('UserStackLimit', field.Pointer),
                ('StartAddr', field.Pointer),
                ('Win32StartAddr', field.Pointer),
                ('TebBase', field.Pointer),
                ('SubProcessTag', field.UInt32)]


class Thread(event.EventCategory):
  GUID = Event.GUID
  VERSION = 3

  class Thread_TypeGroup1(event.EventClass):
    _event_types_ = [Event.DCEnd,
                     Event.DCStart,
                     Event.End,
                     Event.Start]
    _fields_ = [('ProcessId', field.UInt32),
                ('TThreadId', field.UInt32),
                ('StackBase', field.Pointer),
                ('StackLimit', field.Pointer),
                ('UserStackBase', field.Pointer),
                ('UserStackLimit', field.Pointer),
                ('Affinity', field.Pointer),
                ('Win32StartAddr', field.Pointer),
                ('TebBase', field.Pointer),
                ('SubProcessTag', field.UInt32),
                ('BasePriority', field.UInt8),
                ('PagePriority', field.UInt8),
                ('IoPriority', field.UInt8),
                ('ThreadFlags', field.UInt8)]

  class ThreadPriority(event.EventClass):
    _event_types_ = [Event.SetBasePriority,
                     Event.SetIoPriority,
                     Event.SetPagePriority,
                     Event.SetPriority]
    _fields_ = [('ThreadId', field.UInt32),
                ('OldPriority', field.UInt8),
                ('NewPriority', field.UInt8),
                ('Reserved', field.UInt16)]


class Thread_V0(event.EventCategory):
  GUID = Event.GUID
  VERSION = 0

  class Thread_V0_TypeGroup1(event.EventClass):
    _event_types_ = [Event.DCEnd,
                     Event.DCStart,
                     Event.End,
                     Event.Start]
    _fields_ = [('TThreadId', field.UInt32),
                ('ProcessId', field.UInt32)]


class Thread_V1(event.EventCategory):
  GUID = Event.GUID
  VERSION = 1

  class Thread_V1_TypeGroup2(event.EventClass):
    _event_types_ = [Event.DCEnd,
                     Event.End]
    _fields_ = [('ProcessId', field.UInt32),
                ('TThreadId', field.UInt32)]

  class Thread_V1_TypeGroup1(event.EventClass):
    _event_types_ = [Event.DCStart,
                     Event.Start]
    _fields_ = [('ProcessId', field.UInt32),
                ('TThreadId', field.UInt32),
                ('StackBase', field.Pointer),
                ('StackLimit', field.Pointer),
                ('UserStackBase', field.Pointer),
                ('UserStackLimit', field.Pointer),
                ('StartAddr', field.Pointer),
                ('Win32StartAddr', field.Pointer),
                ('WaitMode', field.Int8)]

  class CSwitch_V1(event.EventClass):
    _event_types_ = [Event.CSwitch]
    _fields_ = [('NewThreadId', field.UInt32),
                ('OldThreadId', field.UInt32),
                ('NewThreadPriority', field.Int8),
                ('OldThreadPriority', field.Int8),
                ('NewThreadQuantum', field.Int8),
                ('OldThreadQuantum', field.Int8),
                ('OldThreadWaitReason', field.Int8),
                ('OldThreadWaitMode', field.Int8),
                ('OldThreadState', field.Int8),
                ('OldThreadWaitIdealProcessor', field.Int8),
                ('NewThreadWaitTime', field.UInt32)]

  class WorkerThread_V1(event.EventClass):
    _event_types_ = [Event.WorkerThread]
    _fields_ = [('TThreadId', field.UInt32),
                ('StartTime', field.UInt64),
                ('ThreadRoutine', field.Pointer)]
