// Copyright (c) 2009 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This table is a dump of system call numbers -> function names on an XP
// system.  These numbers change between kernel versions, so it's likely they
// will have to be regenerated for your system.  See the idarub script.

// Define a global map used for resolving a syscall number to name.
// Call CreateSyscallMap() to create a return a std::map<int, const char*>
// which maps from a system call number to it's function name.

#ifndef TRACELINE_SYSCALL_MAP_H_
#define TRACELINE_SYSCALL_MAP_H_

#include <map>

// TODO(deanm): Right now these tables are manually extracted and hardcoded
// here.  It would be great (but possibly difficult) to do it on startup.  We
// should at least checksum the DLLs to make sure they match.

std::map<int, const char*> CreateSyscallMap() {
  std::map<int, const char*> table;
if (1) {  // XP table.
  table[0] = "ntdll.dll!NtAcceptConnectPort";
  table[1] = "ntdll.dll!NtAccessCheck";
  table[2] = "ntdll.dll!ZwAccessCheckAndAuditAlarm";
  table[3] = "ntdll.dll!NtAccessCheckByType";
  table[4] = "ntdll.dll!NtAccessCheckByTypeAndAuditAlarm";
  table[5] = "ntdll.dll!NtAccessCheckByTypeResultList";
  table[6] = "ntdll.dll!NtAccessCheckByTypeResultListAndAuditAlarm";
  table[7] = "ntdll.dll!ZwAccessCheckByTypeResultListAndAuditAlarmByHandle";
  table[8] = "ntdll.dll!NtAddAtom";
  table[9] = "ntdll.dll!ZwAddBootEntry";
  table[10] = "ntdll.dll!ZwAdjustGroupsToken";
  table[11] = "ntdll.dll!ZwAdjustPrivilegesToken";
  table[12] = "ntdll.dll!NtAlertResumeThread";
  table[13] = "ntdll.dll!NtAlertThread";
  table[14] = "ntdll.dll!ZwAllocateLocallyUniqueId";
  table[15] = "ntdll.dll!NtAllocateUserPhysicalPages";
  table[16] = "ntdll.dll!NtAllocateUuids";
  table[17] = "ntdll.dll!NtAllocateVirtualMemory";
  table[18] = "ntdll.dll!ZwAreMappedFilesTheSame";
  table[19] = "ntdll.dll!ZwAssignProcessToJobObject";
  table[20] = "ntdll.dll!ZwCallbackReturn";
  table[21] = "ntdll.dll!NtCancelDeviceWakeupRequest";
  table[22] = "ntdll.dll!ZwCancelIoFile";
  table[23] = "ntdll.dll!ZwCancelTimer";
  table[24] = "ntdll.dll!NtClearEvent";
  table[25] = "ntdll.dll!NtClose";
  table[26] = "ntdll.dll!ZwCloseObjectAuditAlarm";
  table[27] = "ntdll.dll!NtCompactKeys";
  table[28] = "ntdll.dll!ZwCompareTokens";
  table[29] = "ntdll.dll!NtCompleteConnectPort";
  table[30] = "ntdll.dll!ZwCompressKey";
  table[31] = "ntdll.dll!NtConnectPort";
  table[32] = "ntdll.dll!ZwContinue";
  table[33] = "ntdll.dll!ZwCreateDebugObject";
  table[34] = "ntdll.dll!ZwCreateDirectoryObject";
  table[35] = "ntdll.dll!NtCreateEvent";
  table[36] = "ntdll.dll!NtCreateEventPair";
  table[37] = "ntdll.dll!NtCreateFile";
  table[38] = "ntdll.dll!NtCreateIoCompletion";
  table[39] = "ntdll.dll!ZwCreateJobObject";
  table[40] = "ntdll.dll!NtCreateJobSet";
  table[41] = "ntdll.dll!ZwCreateKey";
  table[42] = "ntdll.dll!ZwCreateMailslotFile";
  table[43] = "ntdll.dll!ZwCreateMutant";
  table[44] = "ntdll.dll!ZwCreateNamedPipeFile";
  table[45] = "ntdll.dll!NtCreatePagingFile";
  table[46] = "ntdll.dll!ZwCreatePort";
  table[47] = "ntdll.dll!ZwCreateProcess";
  table[48] = "ntdll.dll!ZwCreateProcessEx";
  table[49] = "ntdll.dll!ZwCreateProfile";
  table[50] = "ntdll.dll!NtCreateSection";
  table[51] = "ntdll.dll!NtCreateSemaphore";
  table[52] = "ntdll.dll!ZwCreateSymbolicLinkObject";
  table[53] = "ntdll.dll!NtCreateThread";
  table[54] = "ntdll.dll!ZwCreateTimer";
  table[55] = "ntdll.dll!NtCreateToken";
  table[56] = "ntdll.dll!ZwCreateWaitablePort";
  table[57] = "ntdll.dll!NtDebugActiveProcess";
  table[58] = "ntdll.dll!ZwDebugContinue";
  table[59] = "ntdll.dll!ZwDelayExecution";
  table[60] = "ntdll.dll!ZwDeleteAtom";
  table[61] = "ntdll.dll!NtDeleteBootEntry";
  table[62] = "ntdll.dll!NtDeleteFile";
  table[63] = "ntdll.dll!ZwDeleteKey";
  table[64] = "ntdll.dll!NtDeleteObjectAuditAlarm";
  table[65] = "ntdll.dll!NtDeleteValueKey";
  table[66] = "ntdll.dll!ZwDeviceIoControlFile";
  table[67] = "ntdll.dll!NtDisplayString";
  table[68] = "ntdll.dll!ZwDuplicateObject";
  table[69] = "ntdll.dll!NtDuplicateToken";
  table[70] = "ntdll.dll!ZwEnumerateBootEntries";
  table[71] = "ntdll.dll!ZwEnumerateKey";
  table[72] = "ntdll.dll!ZwEnumerateSystemEnvironmentValuesEx";
  table[73] = "ntdll.dll!NtEnumerateValueKey";
  table[74] = "ntdll.dll!ZwExtendSection";
  table[75] = "ntdll.dll!NtFilterToken";
  table[76] = "ntdll.dll!NtFindAtom";
  table[77] = "ntdll.dll!ZwFlushBuffersFile";
  table[78] = "ntdll.dll!ZwFlushInstructionCache";
  table[79] = "ntdll.dll!NtFlushKey";
  table[80] = "ntdll.dll!ZwFlushVirtualMemory";
  table[81] = "ntdll.dll!NtFlushWriteBuffer";
  table[82] = "ntdll.dll!NtFreeUserPhysicalPages";
  table[83] = "ntdll.dll!NtFreeVirtualMemory";
  table[84] = "ntdll.dll!NtFsControlFile";
  table[85] = "ntdll.dll!NtGetContextThread";
  table[86] = "ntdll.dll!NtGetDevicePowerState";
  table[87] = "ntdll.dll!ZwGetPlugPlayEvent";
  table[88] = "ntdll.dll!NtGetWriteWatch";
  table[89] = "ntdll.dll!NtImpersonateAnonymousToken";
  table[90] = "ntdll.dll!ZwImpersonateClientOfPort";
  table[91] = "ntdll.dll!ZwImpersonateThread";
  table[92] = "ntdll.dll!ZwInitializeRegistry";
  table[93] = "ntdll.dll!NtInitiatePowerAction";
  table[94] = "ntdll.dll!ZwIsProcessInJob";
  table[95] = "ntdll.dll!NtIsSystemResumeAutomatic";
  table[96] = "ntdll.dll!ZwListenPort";
  table[97] = "ntdll.dll!NtLoadDriver";
  table[98] = "ntdll.dll!NtLoadKey";
  table[99] = "ntdll.dll!NtLoadKey2";
  table[100] = "ntdll.dll!NtLockFile";
  table[101] = "ntdll.dll!ZwLockProductActivationKeys";
  table[102] = "ntdll.dll!NtLockRegistryKey";
  table[103] = "ntdll.dll!ZwLockVirtualMemory";
  table[104] = "ntdll.dll!ZwMakePermanentObject";
  table[105] = "ntdll.dll!NtMakeTemporaryObject";
  table[106] = "ntdll.dll!NtMapUserPhysicalPages";
  table[107] = "ntdll.dll!ZwMapUserPhysicalPagesScatter";
  table[108] = "ntdll.dll!ZwMapViewOfSection";
  table[109] = "ntdll.dll!NtModifyBootEntry";
  table[110] = "ntdll.dll!NtNotifyChangeDirectoryFile";
  table[111] = "ntdll.dll!NtNotifyChangeKey";
  table[112] = "ntdll.dll!NtNotifyChangeMultipleKeys";
  table[113] = "ntdll.dll!ZwOpenDirectoryObject";
  table[114] = "ntdll.dll!NtOpenEvent";
  table[115] = "ntdll.dll!NtOpenEventPair";
  table[116] = "ntdll.dll!NtOpenFile";
  table[117] = "ntdll.dll!ZwOpenIoCompletion";
  table[118] = "ntdll.dll!ZwOpenJobObject";
  table[119] = "ntdll.dll!ZwOpenKey";
  table[120] = "ntdll.dll!NtOpenMutant";
  table[121] = "ntdll.dll!ZwOpenObjectAuditAlarm";
  table[122] = "ntdll.dll!ZwOpenProcess";
  table[123] = "ntdll.dll!ZwOpenProcessToken";
  table[124] = "ntdll.dll!ZwOpenProcessTokenEx";
  table[125] = "ntdll.dll!NtOpenSection";
  table[126] = "ntdll.dll!NtOpenSemaphore";
  table[127] = "ntdll.dll!NtOpenSymbolicLinkObject";
  table[128] = "ntdll.dll!ZwOpenThread";
  table[129] = "ntdll.dll!NtOpenThreadToken";
  table[130] = "ntdll.dll!NtOpenThreadTokenEx";
  table[131] = "ntdll.dll!ZwOpenTimer";
  table[132] = "ntdll.dll!NtPlugPlayControl";
  table[133] = "ntdll.dll!ZwPowerInformation";
  table[134] = "ntdll.dll!ZwPrivilegeCheck";
  table[135] = "ntdll.dll!ZwPrivilegeObjectAuditAlarm";
  table[136] = "ntdll.dll!NtPrivilegedServiceAuditAlarm";
  table[137] = "ntdll.dll!ZwProtectVirtualMemory";
  table[138] = "ntdll.dll!ZwPulseEvent";
  table[139] = "ntdll.dll!ZwQueryAttributesFile";
  table[140] = "ntdll.dll!ZwQueryBootEntryOrder";
  table[141] = "ntdll.dll!ZwQueryBootOptions";
  table[142] = "ntdll.dll!NtQueryDebugFilterState";
  table[143] = "ntdll.dll!NtQueryDefaultLocale";
  table[144] = "ntdll.dll!ZwQueryDefaultUILanguage";
  table[145] = "ntdll.dll!ZwQueryDirectoryFile";
  table[146] = "ntdll.dll!ZwQueryDirectoryObject";
  table[147] = "ntdll.dll!ZwQueryEaFile";
  table[148] = "ntdll.dll!NtQueryEvent";
  table[149] = "ntdll.dll!ZwQueryFullAttributesFile";
  table[150] = "ntdll.dll!NtQueryInformationAtom";
  table[151] = "ntdll.dll!ZwQueryInformationFile";
  table[152] = "ntdll.dll!ZwQueryInformationJobObject";
  table[153] = "ntdll.dll!ZwQueryInformationPort";
  table[154] = "ntdll.dll!ZwQueryInformationProcess";
  table[155] = "ntdll.dll!NtQueryInformationThread";
  table[156] = "ntdll.dll!ZwQueryInformationToken";
  table[157] = "ntdll.dll!NtQueryInstallUILanguage";
  table[158] = "ntdll.dll!NtQueryIntervalProfile";
  table[159] = "ntdll.dll!NtQueryIoCompletion";
  table[160] = "ntdll.dll!ZwQueryKey";
  table[161] = "ntdll.dll!NtQueryMultipleValueKey";
  table[162] = "ntdll.dll!NtQueryMutant";
  table[163] = "ntdll.dll!NtQueryObject";
  table[164] = "ntdll.dll!NtQueryOpenSubKeys";
  table[165] = "ntdll.dll!NtQueryPerformanceCounter";
  table[166] = "ntdll.dll!ZwQueryQuotaInformationFile";
  table[167] = "ntdll.dll!ZwQuerySection";
  table[168] = "ntdll.dll!NtQuerySecurityObject";
  table[169] = "ntdll.dll!ZwQuerySemaphore";
  table[170] = "ntdll.dll!ZwQuerySymbolicLinkObject";
  table[171] = "ntdll.dll!ZwQuerySystemEnvironmentValue";
  table[172] = "ntdll.dll!ZwQuerySystemEnvironmentValueEx";
  table[173] = "ntdll.dll!NtQuerySystemInformation";
  table[174] = "ntdll.dll!NtQuerySystemTime";
  table[175] = "ntdll.dll!ZwQueryTimer";
  table[176] = "ntdll.dll!NtQueryTimerResolution";
  table[177] = "ntdll.dll!ZwQueryValueKey";
  table[178] = "ntdll.dll!NtQueryVirtualMemory";
  table[179] = "ntdll.dll!NtQueryVolumeInformationFile";
  table[180] = "ntdll.dll!NtQueueApcThread";
  table[181] = "ntdll.dll!ZwRaiseException";
  table[182] = "ntdll.dll!ZwRaiseHardError";
  table[183] = "ntdll.dll!NtReadFile";
  table[184] = "ntdll.dll!NtReadFileScatter";
  table[185] = "ntdll.dll!ZwReadRequestData";
  table[186] = "ntdll.dll!NtReadVirtualMemory";
  table[187] = "ntdll.dll!ZwRegisterThreadTerminatePort";
  table[188] = "ntdll.dll!ZwReleaseMutant";
  table[189] = "ntdll.dll!NtReleaseSemaphore";
  table[190] = "ntdll.dll!ZwRemoveIoCompletion";
  table[191] = "ntdll.dll!ZwRemoveProcessDebug";
  table[192] = "ntdll.dll!ZwRenameKey";
  table[193] = "ntdll.dll!ZwReplaceKey";
  table[194] = "ntdll.dll!ZwReplyPort";
  table[195] = "ntdll.dll!NtReplyWaitReceivePort";
  table[196] = "ntdll.dll!NtReplyWaitReceivePortEx";
  table[197] = "ntdll.dll!NtReplyWaitReplyPort";
  table[198] = "ntdll.dll!ZwRequestDeviceWakeup";
  table[199] = "ntdll.dll!ZwRequestPort";
  table[200] = "ntdll.dll!NtRequestWaitReplyPort";
  table[201] = "ntdll.dll!ZwRequestWakeupLatency";
  table[202] = "ntdll.dll!NtResetEvent";
  table[203] = "ntdll.dll!ZwResetWriteWatch";
  table[204] = "ntdll.dll!NtRestoreKey";
  table[205] = "ntdll.dll!ZwResumeProcess";
  table[206] = "ntdll.dll!ZwResumeThread";
  table[207] = "ntdll.dll!NtSaveKey";
  table[208] = "ntdll.dll!NtSaveKeyEx";
  table[209] = "ntdll.dll!NtSaveMergedKeys";
  table[210] = "ntdll.dll!NtSecureConnectPort";
  table[211] = "ntdll.dll!ZwSetBootEntryOrder";
  table[212] = "ntdll.dll!ZwSetBootOptions";
  table[213] = "ntdll.dll!ZwSetContextThread";
  table[214] = "ntdll.dll!NtSetDebugFilterState";
  table[215] = "ntdll.dll!NtSetDefaultHardErrorPort";
  table[216] = "ntdll.dll!NtSetDefaultLocale";
  table[217] = "ntdll.dll!ZwSetDefaultUILanguage";
  table[218] = "ntdll.dll!ZwSetEaFile";
  table[219] = "ntdll.dll!NtSetEvent";
  table[220] = "ntdll.dll!NtSetEventBoostPriority";
  table[221] = "ntdll.dll!NtSetHighEventPair";
  table[222] = "ntdll.dll!NtSetHighWaitLowEventPair";
  table[223] = "ntdll.dll!ZwSetInformationDebugObject";
  table[224] = "ntdll.dll!ZwSetInformationFile";
  table[225] = "ntdll.dll!ZwSetInformationJobObject";
  table[226] = "ntdll.dll!ZwSetInformationKey";
  table[227] = "ntdll.dll!ZwSetInformationObject";
  table[228] = "ntdll.dll!ZwSetInformationProcess";
  table[229] = "ntdll.dll!ZwSetInformationThread";
  table[230] = "ntdll.dll!ZwSetInformationToken";
  table[231] = "ntdll.dll!NtSetIntervalProfile";
  table[232] = "ntdll.dll!NtSetIoCompletion";
  table[233] = "ntdll.dll!ZwSetLdtEntries";
  table[234] = "ntdll.dll!ZwSetLowEventPair";
  table[235] = "ntdll.dll!ZwSetLowWaitHighEventPair";
  table[236] = "ntdll.dll!ZwSetQuotaInformationFile";
  table[237] = "ntdll.dll!NtSetSecurityObject";
  table[238] = "ntdll.dll!ZwSetSystemEnvironmentValue";
  table[239] = "ntdll.dll!ZwSetSystemEnvironmentValueEx";
  table[240] = "ntdll.dll!ZwSetSystemInformation";
  table[241] = "ntdll.dll!ZwSetSystemPowerState";
  table[242] = "ntdll.dll!ZwSetSystemTime";
  table[243] = "ntdll.dll!ZwSetThreadExecutionState";
  table[244] = "ntdll.dll!ZwSetTimer";
  table[245] = "ntdll.dll!NtSetTimerResolution";
  table[246] = "ntdll.dll!ZwSetUuidSeed";
  table[247] = "ntdll.dll!ZwSetValueKey";
  table[248] = "ntdll.dll!NtSetVolumeInformationFile";
  table[249] = "ntdll.dll!ZwShutdownSystem";
  table[250] = "ntdll.dll!ZwSignalAndWaitForSingleObject";
  table[251] = "ntdll.dll!NtStartProfile";
  table[252] = "ntdll.dll!ZwStopProfile";
  table[253] = "ntdll.dll!ZwSuspendProcess";
  table[254] = "ntdll.dll!ZwSuspendThread";
  table[255] = "ntdll.dll!NtSystemDebugControl";
  table[256] = "ntdll.dll!ZwTerminateJobObject";
  table[257] = "ntdll.dll!ZwTerminateProcess";
  table[258] = "ntdll.dll!ZwTerminateThread";
  table[259] = "ntdll.dll!NtTestAlert";
  table[260] = "ntdll.dll!NtTraceEvent";
  table[261] = "ntdll.dll!NtTranslateFilePath";
  table[262] = "ntdll.dll!ZwUnloadDriver";
  table[263] = "ntdll.dll!NtUnloadKey";
  table[264] = "ntdll.dll!ZwUnloadKeyEx";
  table[265] = "ntdll.dll!ZwUnlockFile";
  table[266] = "ntdll.dll!NtUnlockVirtualMemory";
  table[267] = "ntdll.dll!NtUnmapViewOfSection";
  table[268] = "ntdll.dll!NtVdmControl";
  table[269] = "ntdll.dll!NtWaitForDebugEvent";
  table[270] = "ntdll.dll!NtWaitForMultipleObjects";
  table[271] = "ntdll.dll!ZwWaitForSingleObject";
  table[272] = "ntdll.dll!ZwWaitHighEventPair";
  table[273] = "ntdll.dll!NtWaitLowEventPair";
  table[274] = "ntdll.dll!NtWriteFile";
  table[275] = "ntdll.dll!NtWriteFileGather";
  table[276] = "ntdll.dll!NtWriteRequestData";
  table[277] = "ntdll.dll!NtWriteVirtualMemory";
  table[278] = "ntdll.dll!ZwYieldExecution";
  table[279] = "ntdll.dll!ZwCreateKeyedEvent";
  table[280] = "ntdll.dll!NtOpenKeyedEvent";
  table[281] = "ntdll.dll!NtReleaseKeyedEvent";
  table[282] = "ntdll.dll!NtWaitForKeyedEvent";
  table[283] = "ntdll.dll!ZwQueryPortInformationProcess";
  table[4096] = "gdi32.dll!NtGdiAbortDoc";
  table[4097] = "gdi32.dll!NtGdiAbortPath";
  table[4098] = "gdi32.dll!NtGdiAddFontResourceW";
  table[4099] = "gdi32.dll!NtGdiAddRemoteFontToDC";
  table[4100] = "gdi32.dll!NtGdiAddFontMemResourceEx";
  table[4101] = "gdi32.dll!NtGdiRemoveMergeFont";
  table[4102] = "gdi32.dll!NtGdiAddRemoteMMInstanceToDC";
  table[4103] = "gdi32.dll!NtGdiAlphaBlend";
  table[4104] = "gdi32.dll!NtGdiAngleArc";
  table[4105] = "gdi32.dll!NtGdiAnyLinkedFonts";
  table[4106] = "gdi32.dll!NtGdiFontIsLinked";
  table[4107] = "gdi32.dll!NtGdiArcInternal";
  table[4108] = "gdi32.dll!NtGdiBeginPath";
  table[4109] = "gdi32.dll!NtGdiBitBlt";
  table[4110] = "gdi32.dll!NtGdiCancelDC";
  table[4111] = "gdi32.dll!NtGdiCheckBitmapBits";
  table[4112] = "gdi32.dll!NtGdiCloseFigure";
  table[4113] = "gdi32.dll!NtGdiClearBitmapAttributes";
  table[4114] = "gdi32.dll!NtGdiClearBrushAttributes";
  table[4115] = "gdi32.dll!NtGdiColorCorrectPalette";
  table[4116] = "gdi32.dll!NtGdiCombineRgn";
  table[4117] = "gdi32.dll!CombineTransform";
  table[4118] = "gdi32.dll!NtGdiComputeXformCoefficients";
  table[4119] = "gdi32.dll!NtGdiConsoleTextOut";
  table[4120] = "gdi32.dll!NtGdiConvertMetafileRect";
  table[4121] = "gdi32.dll!NtGdiCreateBitmap";
  table[4122] = "gdi32.dll!NtGdiCreateClientObj";
  table[4123] = "gdi32.dll!NtGdiCreateColorSpace";
  table[4124] = "gdi32.dll!NtGdiCreateColorTransform";
  table[4125] = "gdi32.dll!NtGdiCreateCompatibleBitmap";
  table[4126] = "gdi32.dll!NtGdiCreateCompatibleDC";
  table[4127] = "gdi32.dll!NtGdiCreateDIBBrush";
  table[4128] = "gdi32.dll!NtGdiCreateDIBitmapInternal";
  table[4129] = "gdi32.dll!NtGdiCreateDIBSection";
  table[4130] = "gdi32.dll!NtGdiCreateEllipticRgn";
  table[4131] = "gdi32.dll!NtGdiCreateHalftonePalette";
  table[4132] = "gdi32.dll!NtGdiCreateHatchBrushInternal";
  table[4133] = "gdi32.dll!NtGdiCreateMetafileDC";
  table[4134] = "gdi32.dll!NtGdiCreatePaletteInternal";
  table[4135] = "gdi32.dll!NtGdiCreatePatternBrushInternal";
  table[4136] = "gdi32.dll!CreatePen";
  table[4137] = "gdi32.dll!NtGdiCreateRectRgn";
  table[4138] = "gdi32.dll!CreateRoundRectRgn";
  table[4139] = "gdi32.dll!NtGdiCreateServerMetaFile";
  table[4140] = "gdi32.dll!NtGdiCreateSolidBrush";
  table[4141] = "gdi32.dll!NtGdiD3dContextCreate";
  table[4142] = "gdi32.dll!NtGdiD3dContextDestroy";
  table[4143] = "gdi32.dll!NtGdiD3dContextDestroyAll";
  table[4144] = "gdi32.dll!NtGdiD3dValidateTextureStageState";
  table[4145] = "gdi32.dll!NtGdiD3dDrawPrimitives2";
  table[4146] = "gdi32.dll!NtGdiDdGetDriverState";
  table[4147] = "gdi32.dll!NtGdiDdAddAttachedSurface";
  table[4148] = "gdi32.dll!NtGdiDdAlphaBlt";
  table[4149] = "gdi32.dll!NtGdiDdAttachSurface";
  table[4150] = "gdi32.dll!NtGdiDdBeginMoCompFrame";
  table[4151] = "gdi32.dll!NtGdiDdBlt";
  table[4152] = "gdi32.dll!NtGdiDdCanCreateSurface";
  table[4153] = "gdi32.dll!NtGdiDdCanCreateD3DBuffer";
  table[4154] = "gdi32.dll!NtGdiDdColorControl";
  table[4155] = "gdi32.dll!NtGdiDdCreateDirectDrawObject";
  table[4156] = "gdi32.dll!NtGdiDdCreateSurface";
  table[4157] = "gdi32.dll!NtGdiDdCreateD3DBuffer";
  table[4158] = "gdi32.dll!NtGdiDdCreateMoComp";
  table[4159] = "gdi32.dll!NtGdiDdCreateSurfaceObject";
  table[4160] = "gdi32.dll!NtGdiDdDeleteDirectDrawObject";
  table[4161] = "gdi32.dll!NtGdiDdDeleteSurfaceObject";
  table[4162] = "gdi32.dll!NtGdiDdDestroyMoComp";
  table[4163] = "gdi32.dll!NtGdiDdDestroySurface";
  table[4164] = "gdi32.dll!NtGdiDdDestroyD3DBuffer";
  table[4165] = "gdi32.dll!NtGdiDdEndMoCompFrame";
  table[4166] = "gdi32.dll!NtGdiDdFlip";
  table[4167] = "gdi32.dll!NtGdiDdFlipToGDISurface";
  table[4168] = "gdi32.dll!NtGdiDdGetAvailDriverMemory";
  table[4169] = "gdi32.dll!NtGdiDdGetBltStatus";
  table[4170] = "gdi32.dll!NtGdiDdGetDC";
  table[4171] = "gdi32.dll!NtGdiDdGetDriverInfo";
  table[4172] = "gdi32.dll!NtGdiDdGetDxHandle";
  table[4173] = "gdi32.dll!NtGdiDdGetFlipStatus";
  table[4174] = "gdi32.dll!NtGdiDdGetInternalMoCompInfo";
  table[4175] = "gdi32.dll!NtGdiDdGetMoCompBuffInfo";
  table[4176] = "gdi32.dll!NtGdiDdGetMoCompGuids";
  table[4177] = "gdi32.dll!NtGdiDdGetMoCompFormats";
  table[4178] = "gdi32.dll!NtGdiDdGetScanLine";
  table[4179] = "gdi32.dll!NtGdiDdLock";
  table[4180] = "gdi32.dll!NtGdiDdLockD3D";
  table[4181] = "gdi32.dll!NtGdiDdQueryDirectDrawObject";
  table[4182] = "gdi32.dll!NtGdiDdQueryMoCompStatus";
  table[4183] = "gdi32.dll!NtGdiDdReenableDirectDrawObject";
  table[4184] = "gdi32.dll!NtGdiDdReleaseDC";
  table[4185] = "gdi32.dll!NtGdiDdRenderMoComp";
  table[4186] = "gdi32.dll!NtGdiDdResetVisrgn";
  table[4187] = "gdi32.dll!NtGdiDdSetColorKey";
  table[4188] = "gdi32.dll!NtGdiDdSetExclusiveMode";
  table[4189] = "gdi32.dll!NtGdiDdSetGammaRamp";
  table[4190] = "gdi32.dll!NtGdiDdCreateSurfaceEx";
  table[4191] = "gdi32.dll!NtGdiDdSetOverlayPosition";
  table[4192] = "gdi32.dll!NtGdiDdUnattachSurface";
  table[4193] = "gdi32.dll!NtGdiDdUnlock";
  table[4194] = "gdi32.dll!NtGdiDdUnlockD3D";
  table[4195] = "gdi32.dll!NtGdiDdUpdateOverlay";
  table[4196] = "gdi32.dll!NtGdiDdWaitForVerticalBlank";
  table[4197] = "gdi32.dll!NtGdiDvpCanCreateVideoPort";
  table[4198] = "gdi32.dll!NtGdiDvpColorControl";
  table[4199] = "gdi32.dll!NtGdiDvpCreateVideoPort";
  table[4200] = "gdi32.dll!NtGdiDvpDestroyVideoPort";
  table[4201] = "gdi32.dll!NtGdiDvpFlipVideoPort";
  table[4202] = "gdi32.dll!NtGdiDvpGetVideoPortBandwidth";
  table[4203] = "gdi32.dll!NtGdiDvpGetVideoPortField";
  table[4204] = "gdi32.dll!NtGdiDvpGetVideoPortFlipStatus";
  table[4205] = "gdi32.dll!NtGdiDvpGetVideoPortInputFormats";
  table[4206] = "gdi32.dll!NtGdiDvpGetVideoPortLine";
  table[4207] = "gdi32.dll!NtGdiDvpGetVideoPortOutputFormats";
  table[4208] = "gdi32.dll!NtGdiDvpGetVideoPortConnectInfo";
  table[4209] = "gdi32.dll!NtGdiDvpGetVideoSignalStatus";
  table[4210] = "gdi32.dll!NtGdiDvpUpdateVideoPort";
  table[4211] = "gdi32.dll!NtGdiDvpWaitForVideoPortSync";
  table[4212] = "gdi32.dll!NtGdiDvpAcquireNotification";
  table[4213] = "gdi32.dll!NtGdiDvpReleaseNotification";
  table[4214] = "gdi32.dll!NtGdiDxgGenericThunk";
  table[4215] = "gdi32.dll!NtGdiDeleteClientObj";
  table[4216] = "gdi32.dll!NtGdiDeleteColorSpace";
  table[4217] = "gdi32.dll!NtGdiDeleteColorTransform";
  table[4218] = "gdi32.dll!DeleteObject";
  table[4219] = "gdi32.dll!NtGdiDescribePixelFormat";
  table[4220] = "gdi32.dll!NtGdiGetPerBandInfo";
  table[4221] = "gdi32.dll!NtGdiDoBanding";
  table[4222] = "gdi32.dll!NtGdiDoPalette";
  table[4223] = "gdi32.dll!NtGdiDrawEscape";
  table[4224] = "gdi32.dll!NtGdiEllipse";
  table[4225] = "gdi32.dll!NtGdiEnableEudc";
  table[4226] = "gdi32.dll!NtGdiEndDoc";
  table[4227] = "gdi32.dll!NtGdiEndPage";
  table[4228] = "gdi32.dll!NtGdiEndPath";
  table[4229] = "gdi32.dll!NtGdiEnumFontChunk";
  table[4230] = "gdi32.dll!NtGdiEnumFontClose";
  table[4231] = "gdi32.dll!NtGdiEnumFontOpen";
  table[4232] = "gdi32.dll!NtGdiEnumObjects";
  table[4233] = "gdi32.dll!NtGdiEqualRgn";
  table[4234] = "gdi32.dll!NtGdiEudcLoadUnloadLink";
  table[4235] = "gdi32.dll!NtGdiExcludeClipRect";
  table[4236] = "gdi32.dll!NtGdiExtCreatePen";
  table[4237] = "gdi32.dll!NtGdiExtCreateRegion";
  table[4238] = "gdi32.dll!NtGdiExtEscape";
  table[4239] = "gdi32.dll!NtGdiExtFloodFill";
  table[4240] = "gdi32.dll!NtGdiExtGetObjectW";
  table[4241] = "gdi32.dll!ExtSelectClipRgn";
  table[4242] = "gdi32.dll!NtGdiExtTextOutW";
  table[4243] = "gdi32.dll!NtGdiFillPath";
  table[4244] = "gdi32.dll!NtGdiFillRgn";
  table[4245] = "gdi32.dll!NtGdiFlattenPath";
  table[4247] = "gdi32.dll!NtGdiFlush";
  table[4248] = "gdi32.dll!NtGdiForceUFIMapping";
  table[4249] = "gdi32.dll!NtGdiFrameRgn";
  table[4250] = "gdi32.dll!NtGdiFullscreenControl";
  table[4251] = "gdi32.dll!NtGdiGetAndSetDCDword";
  table[4252] = "gdi32.dll!GetClipBox";
  table[4253] = "gdi32.dll!GetBitmapBits";
  table[4254] = "gdi32.dll!NtGdiGetBitmapDimension";
  table[4255] = "gdi32.dll!NtGdiGetBoundsRect";
  table[4256] = "gdi32.dll!NtGdiGetCharABCWidthsW";
  table[4257] = "gdi32.dll!NtGdiGetCharacterPlacementW";
  table[4258] = "gdi32.dll!NtGdiGetCharSet";
  table[4259] = "gdi32.dll!NtGdiGetCharWidthW";
  table[4260] = "gdi32.dll!NtGdiGetCharWidthInfo";
  table[4261] = "gdi32.dll!NtGdiGetColorAdjustment";
  table[4263] = "gdi32.dll!NtGdiGetDCDword";
  table[4264] = "gdi32.dll!NtGdiGetDCforBitmap";
  table[4265] = "gdi32.dll!NtGdiGetDCObject";
  table[4266] = "gdi32.dll!NtGdiGetDCPoint";
  table[4267] = "gdi32.dll!NtGdiGetDeviceCaps";
  table[4268] = "gdi32.dll!NtGdiGetDeviceGammaRamp";
  table[4269] = "gdi32.dll!NtGdiGetDeviceCapsAll";
  table[4270] = "gdi32.dll!NtGdiGetDIBitsInternal";
  table[4271] = "gdi32.dll!NtGdiGetETM";
  table[4272] = "gdi32.dll!NtGdiGetEudcTimeStampEx";
  table[4273] = "gdi32.dll!GetFontData";
  table[4274] = "gdi32.dll!NtGdiGetFontResourceInfoInternalW";
  table[4275] = "gdi32.dll!NtGdiGetGlyphIndicesW";
  table[4276] = "gdi32.dll!NtGdiGetGlyphIndicesWInternal";
  table[4277] = "gdi32.dll!NtGdiGetGlyphOutline";
  table[4278] = "gdi32.dll!NtGdiGetKerningPairs";
  table[4279] = "gdi32.dll!NtGdiGetLinkedUFIs";
  table[4280] = "gdi32.dll!GetMiterLimit";
  table[4281] = "gdi32.dll!NtGdiGetMonitorID";
  table[4282] = "gdi32.dll!GetNearestColor";
  table[4283] = "gdi32.dll!NtGdiGetNearestPaletteIndex";
  table[4284] = "gdi32.dll!NtGdiGetObjectBitmapHandle";
  table[4285] = "gdi32.dll!NtGdiGetOutlineTextMetricsInternalW";
  table[4286] = "gdi32.dll!NtGdiGetPath";
  table[4287] = "gdi32.dll!NtGdiGetPixel";
  table[4288] = "gdi32.dll!NtGdiGetRandomRgn";
  table[4289] = "gdi32.dll!GetRasterizerCaps";
  table[4290] = "gdi32.dll!NtGdiGetRealizationInfo";
  table[4291] = "gdi32.dll!GetRegionData";
  table[4292] = "gdi32.dll!NtGdiGetRgnBox";
  table[4293] = "gdi32.dll!NtGdiGetServerMetaFileBits";
  table[4294] = "gdi32.dll!NtGdiGetSpoolMessage";
  table[4296] = "gdi32.dll!NtGdiGetStockObject";
  table[4297] = "gdi32.dll!NtGdiGetStringBitmapW";
  table[4298] = "gdi32.dll!GetSystemPaletteUse";
  table[4299] = "gdi32.dll!NtGdiGetTextCharsetInfo";
  table[4300] = "gdi32.dll!NtGdiGetTextExtent";
  table[4301] = "gdi32.dll!NtGdiGetTextExtentExW";
  table[4302] = "gdi32.dll!NtGdiGetTextFaceW";
  table[4303] = "gdi32.dll!NtGdiGetTextMetricsW";
  table[4304] = "gdi32.dll!NtGdiGetTransform";
  table[4305] = "gdi32.dll!NtGdiGetUFI";
  table[4306] = "gdi32.dll!NtGdiGetEmbUFI";
  table[4307] = "gdi32.dll!NtGdiGetUFIPathname";
  table[4308] = "gdi32.dll!NtGdiGetEmbedFonts";
  table[4309] = "gdi32.dll!NtGdiChangeGhostFont";
  table[4310] = "gdi32.dll!NtGdiAddEmbFontToDC";
  table[4311] = "gdi32.dll!NtGdiGetFontUnicodeRanges";
  table[4312] = "gdi32.dll!NtGdiGetWidthTable";
  table[4313] = "gdi32.dll!NtGdiGradientFill";
  table[4314] = "gdi32.dll!NtGdiHfontCreate";
  table[4315] = "gdi32.dll!NtGdiIcmBrushInfo";
  table[4316] = "gdi32.dll!NtGdiInit";
  table[4317] = "gdi32.dll!NtGdiInitSpool";
  table[4318] = "gdi32.dll!NtGdiIntersectClipRect";
  table[4319] = "gdi32.dll!NtGdiInvertRgn";
  table[4320] = "gdi32.dll!NtGdiLineTo";
  table[4321] = "gdi32.dll!NtGdiMakeFontDir";
  table[4322] = "gdi32.dll!NtGdiMakeInfoDC";
  table[4323] = "gdi32.dll!NtGdiMaskBlt";
  table[4324] = "gdi32.dll!NtGdiModifyWorldTransform";
  table[4325] = "gdi32.dll!NtGdiMonoBitmap";
  table[4327] = "gdi32.dll!NtGdiOffsetClipRgn";
  table[4328] = "gdi32.dll!NtGdiOffsetRgn";
  table[4329] = "gdi32.dll!NtGdiOpenDCW";
  table[4330] = "gdi32.dll!NtGdiPatBlt";
  table[4331] = "gdi32.dll!NtGdiPolyPatBlt";
  table[4332] = "gdi32.dll!NtGdiPathToRegion";
  table[4333] = "gdi32.dll!NtGdiPlgBlt";
  table[4334] = "gdi32.dll!NtGdiPolyDraw";
  table[4335] = "gdi32.dll!NtGdiPolyPolyDraw";
  table[4336] = "gdi32.dll!NtGdiPolyTextOutW";
  table[4337] = "gdi32.dll!NtGdiPtInRegion";
  table[4338] = "gdi32.dll!NtGdiPtVisible";
  table[4339] = "gdi32.dll!NtGdiQueryFonts";
  table[4340] = "gdi32.dll!NtGdiQueryFontAssocInfo";
  table[4341] = "gdi32.dll!NtGdiRectangle";
  table[4342] = "gdi32.dll!NtGdiRectInRegion";
  table[4343] = "gdi32.dll!RectVisible";
  table[4344] = "gdi32.dll!NtGdiRemoveFontResourceW";
  table[4345] = "gdi32.dll!NtGdiRemoveFontMemResourceEx";
  table[4346] = "gdi32.dll!NtGdiResetDC";
  table[4347] = "gdi32.dll!NtGdiResizePalette";
  table[4348] = "gdi32.dll!NtGdiRestoreDC";
  table[4349] = "gdi32.dll!NtGdiRoundRect";
  table[4350] = "gdi32.dll!NtGdiSaveDC";
  table[4351] = "gdi32.dll!NtGdiScaleViewportExtEx";
  table[4352] = "gdi32.dll!NtGdiScaleWindowExtEx";
  table[4353] = "gdi32.dll!NtGdiSelectBitmap";
  table[4355] = "gdi32.dll!NtGdiSelectClipPath";
  table[4356] = "gdi32.dll!NtGdiSelectFont";
  table[4357] = "gdi32.dll!NtGdiSelectPen";
  table[4358] = "gdi32.dll!NtGdiSetBitmapAttributes";
  table[4359] = "gdi32.dll!SetBitmapBits";
  table[4360] = "gdi32.dll!NtGdiSetBitmapDimension";
  table[4361] = "gdi32.dll!NtGdiSetBoundsRect";
  table[4362] = "gdi32.dll!NtGdiSetBrushAttributes";
  table[4363] = "gdi32.dll!NtGdiSetBrushOrg";
  table[4364] = "gdi32.dll!NtGdiSetColorAdjustment";
  table[4365] = "gdi32.dll!NtGdiSetColorSpace";
  table[4366] = "gdi32.dll!NtGdiSetDeviceGammaRamp";
  table[4367] = "gdi32.dll!NtGdiSetDIBitsToDeviceInternal";
  table[4368] = "gdi32.dll!NtGdiSetFontEnumeration";
  table[4369] = "gdi32.dll!NtGdiSetFontXform";
  table[4370] = "gdi32.dll!NtGdiSetIcmMode";
  table[4371] = "gdi32.dll!NtGdiSetLinkedUFIs";
  table[4372] = "gdi32.dll!NtGdiSetMagicColors";
  table[4373] = "gdi32.dll!NtGdiSetMetaRgn";
  table[4374] = "gdi32.dll!NtGdiSetMiterLimit";
  table[4375] = "gdi32.dll!NtGdiGetDeviceWidth";
  table[4376] = "gdi32.dll!NtGdiMirrorWindowOrg";
  table[4377] = "gdi32.dll!NtGdiSetLayout";
  table[4378] = "gdi32.dll!NtGdiSetPixel";
  table[4379] = "gdi32.dll!NtGdiSetPixelFormat";
  table[4380] = "gdi32.dll!NtGdiSetRectRgn";
  table[4381] = "gdi32.dll!NtGdiSetSystemPaletteUse";
  table[4383] = "gdi32.dll!NtGdiSetupPublicCFONT";
  table[4384] = "gdi32.dll!NtGdiSetVirtualResolution";
  table[4385] = "gdi32.dll!NtGdiSetSizeDevice";
  table[4386] = "gdi32.dll!NtGdiStartDoc";
  table[4387] = "gdi32.dll!NtGdiStartPage";
  table[4388] = "gdi32.dll!NtGdiStretchBlt";
  table[4389] = "gdi32.dll!NtGdiStretchDIBitsInternal";
  table[4390] = "gdi32.dll!NtGdiStrokeAndFillPath";
  table[4391] = "gdi32.dll!NtGdiStrokePath";
  table[4392] = "gdi32.dll!NtGdiSwapBuffers";
  table[4393] = "gdi32.dll!NtGdiTransformPoints";
  table[4394] = "gdi32.dll!NtGdiTransparentBlt";
  table[4395] = "gdi32.dll!NtGdiUnloadPrinterDriver";
  table[4397] = "gdi32.dll!NtGdiUnrealizeObject";
  table[4398] = "gdi32.dll!NtGdiUpdateColors";
  table[4399] = "gdi32.dll!NtGdiWidenPath";
  table[4400] = "user32.dll!NtUserActivateKeyboardLayout";
  table[4401] = "user32.dll!NtUserAlterWindowStyle";
  table[4402] = "imm32.dll!NtUserAssociateInputContext";
  table[4403] = "user32.dll!NtUserAttachThreadInput";
  table[4404] = "user32.dll!NtUserBeginPaint";
  table[4405] = "user32.dll!NtUserBitBltSysBmp";
  table[4406] = "user32.dll!NtUserBlockInput";
  table[4407] = "imm32.dll!NtUserBuildHimcList";
  table[4408] = "user32.dll!NtUserBuildHwndList";
  table[4409] = "user32.dll!NtUserBuildNameList";
  table[4410] = "user32.dll!NtUserBuildPropList";
  table[4411] = "user32.dll!NtUserCallHwnd";
  table[4412] = "user32.dll!NtUserCallHwndLock";
  table[4413] = "user32.dll!NtUserCallHwndOpt";
  table[4414] = "user32.dll!NtUserCallHwndParam";
  table[4415] = "user32.dll!NtUserCallHwndParamLock";
  table[4416] = "user32.dll!NtUserCallMsgFilter";
  table[4417] = "user32.dll!NtUserCallNextHookEx";
  table[4418] = "user32.dll!NtUserCallNoParam";
  table[4419] = "imm32.dll!NtUserCallOneParam";
  table[4419] = "user32.dll!NtUserCallOneParam";
  table[4420] = "user32.dll!NtUserCallTwoParam";
  table[4421] = "user32.dll!NtUserChangeClipboardChain";
  table[4422] = "user32.dll!NtUserChangeDisplaySettings";
  table[4424] = "user32.dll!NtUserCheckMenuItem";
  table[4425] = "user32.dll!NtUserChildWindowFromPointEx";
  table[4426] = "user32.dll!NtUserClipCursor";
  table[4427] = "user32.dll!NtUserCloseClipboard";
  table[4428] = "user32.dll!NtUserCloseDesktop";
  table[4429] = "user32.dll!NtUserCloseWindowStation";
  table[4431] = "user32.dll!NtUserConvertMemHandle";
  table[4432] = "user32.dll!NtUserCopyAcceleratorTable";
  table[4433] = "user32.dll!NtUserCountClipboardFormats";
  table[4434] = "user32.dll!NtUserCreateAcceleratorTable";
  table[4435] = "user32.dll!NtUserCreateCaret";
  table[4436] = "user32.dll!NtUserCreateDesktop";
  table[4437] = "imm32.dll!NtUserCreateInputContext";
  table[4438] = "user32.dll!NtUserCreateLocalMemHandle";
  table[4439] = "user32.dll!NtUserCreateWindowEx";
  table[4440] = "user32.dll!NtUserCreateWindowStation";
  table[4441] = "user32.dll!NtUserDdeGetQualityOfService";
  table[4442] = "user32.dll!NtUserDdeInitialize";
  table[4443] = "user32.dll!NtUserDdeSetQualityOfService";
  table[4444] = "user32.dll!NtUserDeferWindowPos";
  table[4445] = "user32.dll!NtUserDefSetText";
  table[4446] = "user32.dll!NtUserDeleteMenu";
  table[4447] = "user32.dll!DestroyAcceleratorTable";
  table[4448] = "user32.dll!NtUserDestroyCursor";
  table[4449] = "imm32.dll!NtUserDestroyInputContext";
  table[4450] = "user32.dll!NtUserDestroyMenu";
  table[4451] = "user32.dll!NtUserDestroyWindow";
  table[4452] = "imm32.dll!NtUserDisableThreadIme";
  table[4453] = "user32.dll!NtUserDispatchMessage";
  table[4454] = "user32.dll!NtUserDragDetect";
  table[4455] = "user32.dll!NtUserDragObject";
  table[4456] = "user32.dll!NtUserDrawAnimatedRects";
  table[4457] = "user32.dll!NtUserDrawCaption";
  table[4458] = "user32.dll!NtUserDrawCaptionTemp";
  table[4459] = "user32.dll!NtUserDrawIconEx";
  table[4460] = "user32.dll!NtUserDrawMenuBarTemp";
  table[4461] = "user32.dll!NtUserEmptyClipboard";
  table[4462] = "user32.dll!NtUserEnableMenuItem";
  table[4463] = "user32.dll!NtUserEnableScrollBar";
  table[4464] = "user32.dll!NtUserEndDeferWindowPosEx";
  table[4465] = "user32.dll!NtUserEndMenu";
  table[4466] = "user32.dll!NtUserEndPaint";
  table[4467] = "user32.dll!NtUserEnumDisplayDevices";
  table[4468] = "user32.dll!NtUserEnumDisplayMonitors";
  table[4469] = "user32.dll!NtUserEnumDisplaySettings";
  table[4470] = "user32.dll!NtUserEvent";
  table[4471] = "user32.dll!NtUserExcludeUpdateRgn";
  table[4472] = "user32.dll!NtUserFillWindow";
  table[4473] = "user32.dll!NtUserFindExistingCursorIcon";
  table[4474] = "user32.dll!NtUserFindWindowEx";
  table[4475] = "user32.dll!NtUserFlashWindowEx";
  table[4476] = "user32.dll!NtUserGetAltTabInfo";
  table[4477] = "user32.dll!NtUserGetAncestor";
  table[4478] = "imm32.dll!NtUserGetAppImeLevel";
  table[4479] = "user32.dll!GetAsyncKeyState";
  table[4480] = "user32.dll!NtUserGetAtomName";
  table[4481] = "user32.dll!NtUserGetCaretBlinkTime";
  table[4482] = "user32.dll!NtUserGetCaretPos";
  table[4483] = "user32.dll!NtUserGetClassInfo";
  table[4484] = "user32.dll!NtUserGetClassName";
  table[4485] = "user32.dll!NtUserGetClipboardData";
  table[4486] = "user32.dll!NtUserGetClipboardFormatName";
  table[4487] = "user32.dll!NtUserGetClipboardOwner";
  table[4488] = "user32.dll!NtUserGetClipboardSequenceNumber";
  table[4489] = "user32.dll!NtUserGetClipboardViewer";
  table[4490] = "user32.dll!NtUserGetClipCursor";
  table[4491] = "user32.dll!NtUserGetComboBoxInfo";
  table[4492] = "user32.dll!NtUserGetControlBrush";
  table[4493] = "user32.dll!NtUserGetControlColor";
  table[4494] = "user32.dll!NtUserGetCPD";
  table[4495] = "user32.dll!NtUserGetCursorFrameInfo";
  table[4496] = "user32.dll!NtUserGetCursorInfo";
  table[4497] = "user32.dll!NtUserGetDC";
  table[4498] = "user32.dll!NtUserGetDCEx";
  table[4499] = "user32.dll!NtUserGetDoubleClickTime";
  table[4500] = "user32.dll!NtUserGetForegroundWindow";
  table[4501] = "user32.dll!NtUserGetGuiResources";
  table[4502] = "user32.dll!NtUserGetGUIThreadInfo";
  table[4503] = "user32.dll!NtUserGetIconInfo";
  table[4504] = "user32.dll!NtUserGetIconSize";
  table[4505] = "imm32.dll!NtUserGetImeHotKey";
  table[4505] = "user32.dll!NtUserGetImeHotKey";
  table[4506] = "imm32.dll!NtUserGetImeInfoEx";
  table[4507] = "user32.dll!NtUserGetInternalWindowPos";
  table[4508] = "user32.dll!NtUserGetKeyboardLayoutList";
  table[4509] = "user32.dll!NtUserGetKeyboardLayoutName";
  table[4510] = "user32.dll!NtUserGetKeyboardState";
  table[4511] = "user32.dll!NtUserGetKeyNameText";
  table[4512] = "user32.dll!NtUserGetKeyState";
  table[4513] = "user32.dll!NtUserGetListBoxInfo";
  table[4514] = "user32.dll!NtUserGetMenuBarInfo";
  table[4515] = "user32.dll!NtUserGetMenuIndex";
  table[4516] = "user32.dll!NtUserGetMenuItemRect";
  table[4517] = "user32.dll!NtUserGetMessage";
  table[4518] = "user32.dll!NtUserGetMouseMovePointsEx";
  table[4519] = "user32.dll!NtUserGetObjectInformation";
  table[4520] = "user32.dll!NtUserGetOpenClipboardWindow";
  table[4521] = "user32.dll!NtUserGetPriorityClipboardFormat";
  table[4522] = "user32.dll!NtUserGetProcessWindowStation";
  table[4523] = "user32.dll!NtUserGetRawInputBuffer";
  table[4524] = "user32.dll!NtUserGetRawInputData";
  table[4525] = "user32.dll!NtUserGetRawInputDeviceInfo";
  table[4526] = "user32.dll!NtUserGetRawInputDeviceList";
  table[4527] = "user32.dll!NtUserGetRegisteredRawInputDevices";
  table[4528] = "user32.dll!NtUserGetScrollBarInfo";
  table[4529] = "user32.dll!NtUserGetSystemMenu";
  table[4530] = "user32.dll!NtUserGetThreadDesktop";
  table[4531] = "imm32.dll!NtUserGetThreadState";
  table[4531] = "user32.dll!NtUserGetThreadState";
  table[4532] = "user32.dll!NtUserGetTitleBarInfo";
  table[4533] = "user32.dll!GetUpdateRect";
  table[4534] = "user32.dll!GetUpdateRgn";
  table[4535] = "user32.dll!NtUserGetWindowDC";
  table[4536] = "user32.dll!NtUserGetWindowPlacement";
  table[4537] = "user32.dll!NtUserGetWOWClass";
  table[4539] = "user32.dll!NtUserHideCaret";
  table[4540] = "user32.dll!NtUserHiliteMenuItem";
  table[4541] = "user32.dll!NtUserImpersonateDdeClientWindow";
  table[4543] = "user32.dll!NtUserInitializeClientPfnArrays";
  table[4544] = "user32.dll!NtUserInitTask";
  table[4545] = "user32.dll!NtUserInternalGetWindowText";
  table[4546] = "user32.dll!NtUserInvalidateRect";
  table[4547] = "user32.dll!NtUserInvalidateRgn";
  table[4548] = "user32.dll!NtUserIsClipboardFormatAvailable";
  table[4549] = "user32.dll!NtUserKillTimer";
  table[4550] = "user32.dll!NtUserLoadKeyboardLayoutEx";
  table[4551] = "user32.dll!NtUserLockWindowStation";
  table[4552] = "user32.dll!NtUserLockWindowUpdate";
  table[4553] = "user32.dll!NtUserLockWorkStation";
  table[4554] = "user32.dll!NtUserMapVirtualKeyEx";
  table[4555] = "user32.dll!NtUserMenuItemFromPoint";
  table[4556] = "user32.dll!NtUserMessageCall";
  table[4557] = "user32.dll!NtUserMinMaximize";
  table[4558] = "user32.dll!NtUserMNDragLeave";
  table[4559] = "user32.dll!NtUserMNDragOver";
  table[4560] = "user32.dll!NtUserModifyUserStartupInfoFlags";
  table[4561] = "user32.dll!NtUserMoveWindow";
  table[4562] = "imm32.dll!NtUserNotifyIMEStatus";
  table[4562] = "user32.dll!NtUserNotifyIMEStatus";
  table[4564] = "user32.dll!NtUserNotifyWinEvent";
  table[4565] = "user32.dll!NtUserOpenClipboard";
  table[4566] = "user32.dll!NtUserOpenDesktop";
  table[4567] = "user32.dll!NtUserOpenInputDesktop";
  table[4568] = "user32.dll!NtUserOpenWindowStation";
  table[4569] = "user32.dll!NtUserPaintDesktop";
  table[4570] = "user32.dll!PeekMessageW";
  table[4571] = "user32.dll!NtUserPostMessage";
  table[4572] = "user32.dll!NtUserPostThreadMessage";
  table[4573] = "user32.dll!NtUserPrintWindow";
  table[4574] = "user32.dll!NtUserProcessConnect";
  table[4576] = "imm32.dll!NtUserQueryInputContext";
  table[4577] = "user32.dll!NtUserQuerySendMessage";
  table[4578] = "user32.dll!NtUserQueryUserCounters";
  table[4579] = "imm32.dll!NtUserQueryWindow";
  table[4579] = "user32.dll!NtUserQueryWindow";
  table[4580] = "user32.dll!NtUserRealChildWindowFromPoint";
  table[4581] = "user32.dll!NtUserRealInternalGetMessage";
  table[4582] = "user32.dll!NtUserRealWaitMessageEx";
  table[4583] = "user32.dll!NtUserRedrawWindow";
  table[4584] = "user32.dll!NtUserRegisterClassExWOW";
  table[4585] = "user32.dll!NtUserRegisterUserApiHook";
  table[4586] = "user32.dll!NtUserRegisterHotKey";
  table[4587] = "user32.dll!NtUserRegisterRawInputDevices";
  table[4588] = "user32.dll!NtUserRegisterTasklist";
  table[4589] = "user32.dll!NtUserRegisterWindowMessage";
  table[4590] = "user32.dll!NtUserRemoveMenu";
  table[4591] = "user32.dll!NtUserRemoveProp";
  table[4593] = "user32.dll!NtUserResolveDesktopForWOW";
  table[4594] = "user32.dll!NtUserSBGetParms";
  table[4595] = "user32.dll!ScrollDC";
  table[4596] = "user32.dll!NtUserScrollWindowEx";
  table[4597] = "gdi32.dll!NtUserSelectPalette";
  table[4598] = "user32.dll!NtUserSendInput";
  table[4599] = "user32.dll!NtUserSetActiveWindow";
  table[4600] = "imm32.dll!NtUserSetAppImeLevel";
  table[4601] = "user32.dll!NtUserSetCapture";
  table[4602] = "user32.dll!NtUserSetClassLong";
  table[4603] = "user32.dll!NtUserSetClassWord";
  table[4604] = "user32.dll!NtUserSetClipboardData";
  table[4605] = "user32.dll!NtUserSetClipboardViewer";
  table[4606] = "user32.dll!NtUserSetConsoleReserveKeys";
  table[4607] = "user32.dll!NtUserSetCursor";
  table[4608] = "user32.dll!NtUserSetCursorContents";
  table[4609] = "user32.dll!NtUserSetCursorIconData";
  table[4610] = "user32.dll!NtUserSetDbgTag";
  table[4611] = "user32.dll!NtUserSetFocus";
  table[4612] = "user32.dll!NtUserSetImeHotKey";
  table[4613] = "imm32.dll!NtUserSetImeInfoEx";
  table[4614] = "user32.dll!NtUserSetImeOwnerWindow";
  table[4616] = "user32.dll!NtUserSetInformationThread";
  table[4617] = "user32.dll!NtUserSetInternalWindowPos";
  table[4618] = "user32.dll!NtUserSetKeyboardState";
  table[4619] = "user32.dll!NtUserSetLogonNotifyWindow";
  table[4620] = "user32.dll!NtUserSetMenu";
  table[4621] = "user32.dll!NtUserSetMenuContextHelpId";
  table[4622] = "user32.dll!NtUserSetMenuDefaultItem";
  table[4623] = "user32.dll!NtUserSetMenuFlagRtoL";
  table[4624] = "user32.dll!NtUserSetObjectInformation";
  table[4625] = "user32.dll!NtUserSetParent";
  table[4626] = "user32.dll!NtUserSetProcessWindowStation";
  table[4627] = "user32.dll!NtUserSetProp";
  table[4628] = "user32.dll!NtUserSetRipFlags";
  table[4629] = "user32.dll!NtUserSetScrollInfo";
  table[4630] = "user32.dll!NtUserSetShellWindowEx";
  table[4631] = "user32.dll!NtUserSetSysColors";
  table[4632] = "user32.dll!NtUserSetSystemCursor";
  table[4633] = "user32.dll!NtUserSetSystemMenu";
  table[4634] = "user32.dll!NtUserSetSystemTimer";
  table[4635] = "user32.dll!NtUserSetThreadDesktop";
  table[4636] = "imm32.dll!NtUserSetThreadLayoutHandles";
  table[4637] = "user32.dll!NtUserSetThreadState";
  table[4638] = "user32.dll!NtUserSetTimer";
  table[4639] = "user32.dll!NtUserSetWindowFNID";
  table[4640] = "user32.dll!NtUserSetWindowLong";
  table[4641] = "user32.dll!NtUserSetWindowPlacement";
  table[4642] = "user32.dll!NtUserSetWindowPos";
  table[4643] = "user32.dll!NtUserSetWindowRgn";
  table[4644] = "user32.dll!NtUserSetWindowsHookAW";
  table[4645] = "user32.dll!NtUserSetWindowsHookEx";
  table[4646] = "user32.dll!NtUserSetWindowStationUser";
  table[4647] = "user32.dll!NtUserSetWindowWord";
  table[4648] = "user32.dll!NtUserSetWinEventHook";
  table[4649] = "user32.dll!NtUserShowCaret";
  table[4650] = "user32.dll!NtUserShowScrollBar";
  table[4651] = "user32.dll!NtUserShowWindow";
  table[4652] = "user32.dll!NtUserShowWindowAsync";
  table[4654] = "user32.dll!NtUserSwitchDesktop";
  table[4655] = "user32.dll!NtUserSystemParametersInfo";
  table[4657] = "user32.dll!NtUserThunkedMenuInfo";
  table[4658] = "user32.dll!NtUserThunkedMenuItemInfo";
  table[4659] = "user32.dll!NtUserToUnicodeEx";
  table[4660] = "user32.dll!NtUserTrackMouseEvent";
  table[4661] = "user32.dll!NtUserTrackPopupMenuEx";
  table[4662] = "user32.dll!NtUserCalcMenuBar";
  table[4663] = "user32.dll!NtUserPaintMenuBar";
  table[4664] = "user32.dll!TranslateAcceleratorA";
  table[4665] = "user32.dll!NtUserTranslateMessage";
  table[4666] = "user32.dll!NtUserUnhookWindowsHookEx";
  table[4667] = "user32.dll!NtUserUnhookWinEvent";
  table[4668] = "user32.dll!NtUserUnloadKeyboardLayout";
  table[4669] = "user32.dll!NtUserUnlockWindowStation";
  table[4670] = "user32.dll!NtUserUnregisterClass";
  table[4671] = "user32.dll!NtUserUnregisterUserApiHook";
  table[4672] = "user32.dll!NtUserUnregisterHotKey";
  table[4673] = "imm32.dll!NtUserUpdateInputContext";
  table[4673] = "user32.dll!NtUserUpdateInputContext";
  table[4674] = "user32.dll!NtUserUpdateInstance";
  table[4675] = "user32.dll!NtUserUpdateLayeredWindow";
  table[4676] = "user32.dll!NtUserGetLayeredWindowAttributes";
  table[4677] = "user32.dll!NtUserSetLayeredWindowAttributes";
  table[4678] = "user32.dll!NtUserUpdatePerUserSystemParameters";
  table[4679] = "user32.dll!NtUserUserHandleGrantAccess";
  table[4680] = "imm32.dll!NtUserValidateHandleSecure";
  table[4680] = "user32.dll!NtUserValidateHandleSecure";
  table[4681] = "user32.dll!NtUserValidateRect";
  table[4682] = "user32.dll!NtUserValidateTimerCallback";
  table[4683] = "user32.dll!NtUserVkKeyScanEx";
  table[4684] = "user32.dll!NtUserWaitForInputIdle";
  table[4685] = "user32.dll!NtUserWaitForMsgAndEvent";
  table[4686] = "user32.dll!NtUserWaitMessage";
  table[4687] = "user32.dll!NtUserWin32PoolAllocationStats";
  table[4688] = "user32.dll!NtUserWindowFromPoint";
  table[4689] = "user32.dll!NtUserYieldTask";
  table[4695] = "gdi32.dll!NtGdiEngAssociateSurface";
  table[4696] = "gdi32.dll!NtGdiEngCreateBitmap";
  table[4697] = "gdi32.dll!NtGdiEngCreateDeviceSurface";
  table[4698] = "gdi32.dll!NtGdiEngCreateDeviceBitmap";
  table[4699] = "gdi32.dll!NtGdiEngCreatePalette";
  table[4700] = "gdi32.dll!NtGdiEngComputeGlyphSet";
  table[4701] = "gdi32.dll!NtGdiEngCopyBits";
  table[4702] = "gdi32.dll!NtGdiEngDeletePalette";
  table[4703] = "gdi32.dll!NtGdiEngDeleteSurface";
  table[4704] = "gdi32.dll!NtGdiEngEraseSurface";
  table[4705] = "gdi32.dll!NtGdiEngUnlockSurface";
  table[4706] = "gdi32.dll!NtGdiEngLockSurface";
  table[4707] = "gdi32.dll!NtGdiEngBitBlt";
  table[4708] = "gdi32.dll!NtGdiEngStretchBlt";
  table[4709] = "gdi32.dll!NtGdiEngPlgBlt";
  table[4710] = "gdi32.dll!NtGdiEngMarkBandingSurface";
  table[4711] = "gdi32.dll!NtGdiEngStrokePath";
  table[4712] = "gdi32.dll!NtGdiEngFillPath";
  table[4713] = "gdi32.dll!NtGdiEngStrokeAndFillPath";
  table[4714] = "gdi32.dll!NtGdiEngPaint";
  table[4715] = "gdi32.dll!NtGdiEngLineTo";
  table[4716] = "gdi32.dll!NtGdiEngAlphaBlend";
  table[4717] = "gdi32.dll!NtGdiEngGradientFill";
  table[4718] = "gdi32.dll!NtGdiEngTransparentBlt";
  table[4719] = "gdi32.dll!NtGdiEngTextOut";
  table[4720] = "gdi32.dll!NtGdiEngStretchBltROP";
  table[4721] = "gdi32.dll!NtGdiXLATEOBJ_cGetPalette";
  table[4722] = "gdi32.dll!NtGdiXLATEOBJ_iXlate";
  table[4723] = "gdi32.dll!NtGdiXLATEOBJ_hGetColorTransform";
  table[4724] = "gdi32.dll!NtGdiCLIPOBJ_bEnum";
  table[4725] = "gdi32.dll!NtGdiCLIPOBJ_cEnumStart";
  table[4726] = "gdi32.dll!NtGdiCLIPOBJ_ppoGetPath";
  table[4727] = "gdi32.dll!NtGdiEngDeletePath";
  table[4728] = "gdi32.dll!NtGdiEngCreateClip";
  table[4729] = "gdi32.dll!NtGdiEngDeleteClip";
  table[4730] = "gdi32.dll!NtGdiBRUSHOBJ_ulGetBrushColor";
  table[4731] = "gdi32.dll!NtGdiBRUSHOBJ_pvAllocRbrush";
  table[4732] = "gdi32.dll!NtGdiBRUSHOBJ_pvGetRbrush";
  table[4733] = "gdi32.dll!NtGdiBRUSHOBJ_hGetColorTransform";
  table[4734] = "gdi32.dll!NtGdiXFORMOBJ_bApplyXform";
  table[4735] = "gdi32.dll!NtGdiXFORMOBJ_iGetXform";
  table[4736] = "gdi32.dll!NtGdiFONTOBJ_vGetInfo";
  table[4737] = "gdi32.dll!NtGdiFONTOBJ_pxoGetXform";
  table[4738] = "gdi32.dll!NtGdiFONTOBJ_cGetGlyphs";
  table[4739] = "gdi32.dll!NtGdiFONTOBJ_pifi";
  table[4740] = "gdi32.dll!NtGdiFONTOBJ_pfdg";
  table[4741] = "gdi32.dll!NtGdiFONTOBJ_pQueryGlyphAttrs";
  table[4742] = "gdi32.dll!NtGdiFONTOBJ_pvTrueTypeFontFile";
  table[4743] = "gdi32.dll!NtGdiFONTOBJ_cGetAllGlyphHandles";
  table[4744] = "gdi32.dll!NtGdiSTROBJ_bEnum";
  table[4745] = "gdi32.dll!NtGdiSTROBJ_bEnumPositionsOnly";
  table[4746] = "gdi32.dll!NtGdiSTROBJ_bGetAdvanceWidths";
  table[4747] = "gdi32.dll!NtGdiSTROBJ_vEnumStart";
  table[4748] = "gdi32.dll!NtGdiSTROBJ_dwGetCodePage";
  table[4749] = "gdi32.dll!NtGdiPATHOBJ_vGetBounds";
  table[4750] = "gdi32.dll!NtGdiPATHOBJ_bEnum";
  table[4751] = "gdi32.dll!NtGdiPATHOBJ_vEnumStart";
  table[4752] = "gdi32.dll!NtGdiPATHOBJ_vEnumStartClipLines";
  table[4753] = "gdi32.dll!NtGdiPATHOBJ_bEnumClipLines";
  table[4754] = "gdi32.dll!NtGdiGetDhpdev";
  table[4755] = "gdi32.dll!NtGdiEngCheckAbort";
  table[4756] = "gdi32.dll!NtGdiHT_Get8BPPFormatPalette";
  table[4757] = "gdi32.dll!NtGdiHT_Get8BPPMaskPalette";
  table[4758] = "gdi32.dll!NtGdiUpdateTransform";
  table[4759] = "gdi32.dll!NtGdiSetPUMPDOBJ";
  table[4760] = "gdi32.dll!NtGdiBRUSHOBJ_DeleteRbrush";
  table[4761] = "gdi32.dll!NtGdiUMPDEngFreeUserMem";
  table[4762] = "gdi32.dll!NtGdiDrawStream";
} else {  // Vista table.
  table[4272] = "gdi32.dll!NtGdiGetDeviceCaps";
  table[4220] = "gdi32.dll!NtGdiDeleteObjectApp";
  table[4249] = "gdi32.dll!NtGdiFlush";
  table[4120] = "gdi32.dll!NtGdiConsoleTextOut";
  table[4825] = "gdi32.dll!NtGdiDdDDIEscape";
  table[4299] = "gdi32.dll!GetRgnBox";
  table[4828] = "gdi32.dll!NtGdiDdDDIGetPresentHistory";
  table[4835] = "gdi32.dll!NtGdiDdDDIGetDeviceState";
  table[4850] = "gdi32.dll!NtGdiDdDDICheckExclusiveOwnership";
  table[4849] = "gdi32.dll!NtGdiDdDDICheckMonitorPowerState";
  table[4833] = "gdi32.dll!NtGdiDdDDIWaitForVerticalBlankEvent";
  table[4298] = "gdi32.dll!GetRegionData";
  table[4796] = "gdi32.dll!NtGdiDwmGetDirtyRgn";
  table[4820] = "gdi32.dll!NtGdiDdDDIRender";
  table[4819] = "gdi32.dll!NtGdiDdDDIPresent";
  table[4815] = "gdi32.dll!NtGdiDdDDIUnlock";
  table[4814] = "gdi32.dll!NtGdiDdDDILock";
  table[4240] = "gdi32.dll!NtGdiExtCreateRegion";
  table[4339] = "gdi32.dll!NtGdiPolyPatBlt";
  table[4361] = "gdi32.dll!NtGdiSelectBitmap";
  table[4127] = "gdi32.dll!NtGdiCreateCompatibleDC";
  table[4142] = "gdi32.dll!NtGdiCreateSolidBrush";
  table[4122] = "gdi32.dll!CreateBitmap";
  table[4303] = "gdi32.dll!CreateBitmap";
  table[4348] = "gdi32.dll!NtGdiQueryFontAssocInfo";
  table[4126] = "gdi32.dll!NtGdiCreateCompatibleBitmap";
  table[4109] = "gdi32.dll!NtGdiBitBlt";
  table[4243] = "gdi32.dll!NtGdiExtGetObjectW";
  table[4270] = "gdi32.dll!NtGdiGetDCObject";
  table[4620] = "gdi32.dll!NtUserSelectPalette";
  table[4338] = "gdi32.dll!NtGdiPatBlt";
  table[4275] = "gdi32.dll!NtGdiGetDIBitsInternal";
  table[4398] = "gdi32.dll!NtGdiStretchDIBitsInternal";
  table[4130] = "gdi32.dll!NtGdiCreateDIBSection";
  table[4356] = "gdi32.dll!NtGdiRestoreDC";
  table[4358] = "gdi32.dll!NtGdiSaveDC";
  table[4103] = "gdi32.dll!NtGdiAlphaBlend";
  table[4349] = "gdi32.dll!NtGdiRectangle";
  table[4295] = "gdi32.dll!NtGdiGetRandomRgn";
  table[4244] = "gdi32.dll!NtGdiExtSelectClipRgn";
  table[4268] = "gdi32.dll!NtGdiGetDCDword";
  table[4245] = "gdi32.dll!NtGdiExtTextOutW";
  table[4254] = "gdi32.dll!GetClipBox";
  table[4397] = "gdi32.dll!NtGdiStretchBlt";
  table[4331] = "gdi32.dll!NtGdiMaskBlt";
  table[4324] = "gdi32.dll!NtGdiInit";
  table[4262] = "gdi32.dll!NtGdiGetCharSet";
  table[4336] = "gdi32.dll!NtGdiOffsetRgn";
  table[4326] = "gdi32.dll!NtGdiIntersectClipRect";
  table[4795] = "gdi32.dll!NtGdiDrawStream";
  table[4364] = "gdi32.dll!NtGdiSelectFont";
  table[4116] = "gdi32.dll!NtGdiCombineRgn";
  table[4238] = "gdi32.dll!NtGdiExcludeClipRect";
  table[4802] = "gdi32.dll!NtGdiDdDDISetAllocationPriority";
  table[4798] = "gdi32.dll!NtGdiDdDDICreateAllocation";
  table[4801] = "gdi32.dll!NtGdiDdDDIDestroyAllocation";
  table[4797] = "gdi32.dll!NtGdiDwmGetSurfaceData";
  table[4140] = "gdi32.dll!CreateRoundRectRgn";
  table[4840] = "gdi32.dll!NtGdiDdDDISetProcessSchedulingPriorityClass";
  table[4307] = "gdi32.dll!NtGdiGetTextCharsetInfo";
  table[4351] = "gdi32.dll!RectVisible";
  table[4139] = "gdi32.dll!NtGdiCreateRectRgn";
  table[4369] = "gdi32.dll!NtGdiSetBoundsRect";
  table[4257] = "gdi32.dll!NtGdiGetBoundsRect";
  table[4309] = "gdi32.dll!NtGdiGetTextExtentExW";
  table[4402] = "gdi32.dll!NtGdiTransformPoints";
  table[4118] = "gdi32.dll!NtGdiComputeXformCoefficients";
  table[4337] = "gdi32.dll!NtGdiOpenDCW";
  table[4813] = "gdi32.dll!NtGdiDdDDIQueryAdapterInfo";
  table[4822] = "gdi32.dll!NtGdiDdDDIOpenAdapterFromHdc";
  table[4816] = "gdi32.dll!NtGdiDdDDIGetDisplayModeList";
  table[4823] = "gdi32.dll!NtGdiDdDDICloseAdapter";
  table[4804] = "gdi32.dll!NtGdiDdDDICreateDevice";
  table[4806] = "gdi32.dll!NtGdiDdDDICreateContext";
  table[4271] = "gdi32.dll!NtGdiGetDCPoint";
  table[4225] = "gdi32.dll!NtGdiDoPalette";
  table[4288] = "gdi32.dll!GetNearestColor";
  table[4129] = "gdi32.dll!NtGdiCreateDIBitmapInternal";
  table[4322] = "gdi32.dll!NtGdiHfontCreate";
  table[4137] = "gdi32.dll!NtGdiCreatePatternBrushInternal";
  table[4136] = "gdi32.dll!NtGdiCreatePaletteInternal";
  table[4132] = "gdi32.dll!NtGdiCreateHalftonePalette";
  table[4375] = "gdi32.dll!NtGdiSetDIBitsToDeviceInternal";
  table[4269] = "gdi32.dll!NtGdiGetDCforBitmap";
  table[4392] = "gdi32.dll!NtGdiSetupPublicCFONT";
  table[4836] = "gdi32.dll!NtGdiDdDDICreateDCFromMemory";
  table[4264] = "gdi32.dll!NtGdiGetCharWidthInfo";
  table[4367] = "gdi32.dll!SetBitmapBits";
  table[4255] = "gdi32.dll!GetBitmapBits";
  table[4311] = "gdi32.dll!NtGdiGetTextMetricsW";
  table[4297] = "gdi32.dll!NtGdiGetRealizationInfo";
  table[4310] = "gdi32.dll!NtGdiGetTextFaceW";
  table[4292] = "gdi32.dll!NtGdiGetOutlineTextMetricsInternalW";
  table[4280] = "gdi32.dll!NtGdiGetGlyphIndicesW";
  table[4320] = "gdi32.dll!NtGdiGetWidthTable";
  table[4234] = "gdi32.dll!NtGdiEnumFontOpen";
  table[4233] = "gdi32.dll!NtGdiEnumFontClose";
  table[4232] = "gdi32.dll!NtGdiEnumFontChunk";
  table[4260] = "gdi32.dll!NtGdiGetCharABCWidthsW";
  table[4105] = "gdi32.dll!NtGdiAnyLinkedFonts";
  table[4278] = "gdi32.dll!NtGdiGetFontData";
  table[4106] = "gdi32.dll!NtGdiFontIsLinked";
  table[4332] = "gdi32.dll!NtGdiModifyWorldTransform";
  table[4312] = "gdi32.dll!NtGdiGetTransform";
  table[4321] = "gdi32.dll!NtGdiGradientFill";
  table[4294] = "gdi32.dll!NtGdiGetPixel";
  table[4403] = "gdi32.dll!NtGdiTransparentBlt";
  table[4319] = "gdi32.dll!NtGdiGetFontUnicodeRanges";
  table[4817] = "gdi32.dll!NtGdiDdDDISetDisplayMode";
  table[4827] = "gdi32.dll!NtGdiDdDDISetVidPnSourceOwner";
  table[4273] = "gdi32.dll!NtGdiGetDeviceGammaRamp";
  table[4374] = "gdi32.dll!NtGdiSetDeviceGammaRamp";
  table[4366] = "gdi32.dll!NtGdiSetBitmapAttributes";
  table[4098] = "gdi32.dll!NtGdiAddFontResourceW";
  table[4376] = "gdi32.dll!NtGdiSetFontEnumeration";
  table[4228] = "gdi32.dll!NtGdiEnableEudc";
  table[4343] = "gdi32.dll!NtGdiPolyPolyDraw";
  table[4328] = "gdi32.dll!NtGdiLineTo";
  table[4138] = "gdi32.dll!NtGdiCreatePen";
  table[4236] = "gdi32.dll!EqualRgn";
  table[4805] = "gdi32.dll!NtGdiDdDDIDestroyDevice";
  table[4807] = "gdi32.dll!NtGdiDdDDIDestroyContext";
  table[4799] = "gdi32.dll!NtGdiDdDDIQueryResourceInfo";
  table[4800] = "gdi32.dll!NtGdiDdDDIOpenResource";
  table[4838] = "gdi32.dll!NtGdiDdDDISetContextSchedulingPriority";
  table[4263] = "gdi32.dll!NtGdiGetCharWidthW";
  table[4837] = "gdi32.dll!NtGdiDdDDIDestroyDCFromMemory";
  table[4803] = "gdi32.dll!NtGdiDdDDIQueryAllocationResidency";
  table[4824] = "gdi32.dll!NtGdiDdDDIGetSharedPrimaryHandle";
  table[4385] = "gdi32.dll!NtGdiSetLayout";
  table[4371] = "gdi32.dll!NtGdiSetBrushOrg";
  table[4157] = "gdi32.dll!NtGdiDdCreateDirectDrawObject";
  table[4128] = "gdi32.dll!NtGdiCreateDIBBrush";
  table[4387] = "gdi32.dll!NtGdiSetPixel";
  table[4345] = "gdi32.dll!PtInRegion";
  table[4821] = "gdi32.dll!NtGdiDdDDIOpenAdapterFromDeviceName";
  table[4253] = "gdi32.dll!NtGdiGetAndSetDCDword";
  table[4274] = "gdi32.dll!NtGdiGetDeviceCapsAll";
  table[4247] = "gdi32.dll!NtGdiFillRgn";
  table[4289] = "gdi32.dll!GetNearestPaletteIndex";
  table[4378] = "gdi32.dll!NtGdiSetIcmMode";
  table[4327] = "gdi32.dll!NtGdiInvertRgn";
  table[4792] = "gdi32.dll!NtGdiSetPUMPDOBJ";
  table[4735] = "gdi32.dll!NtGdiEngDeletePalette";
  table[4732] = "gdi32.dll!NtGdiEngCreatePalette";
  table[4241] = "gdi32.dll!NtGdiExtEscape";
  table[4217] = "gdi32.dll!NtGdiDeleteClientObj";
  table[4123] = "gdi32.dll!NtGdiCreateClientObj";
  table[4354] = "gdi32.dll!NtGdiResetDC";
  table[4235] = "gdi32.dll!NtGdiEnumObjects";
  table[4135] = "gdi32.dll!NtGdiCreateOPMProtectedOutputs";
  table[4222] = "gdi32.dll!NtGdiDestroyOPMProtectedOutput";
  table[4258] = "gdi32.dll!NtGdiGetCertificate";
  table[4259] = "gdi32.dll!NtGdiGetCertificateSize";
  table[4291] = "gdi32.dll!NtGdiGetOPMRandomNumber";
  table[4305] = "gdi32.dll!NtGdiGetSuggestedOPMProtectedOutputArraySize";
  table[4386] = "gdi32.dll!NtGdiSetOPMSigningKeyAndSequenceNumbers";
  table[4844] = "gdi32.dll!NtGdiDdDDISetQueuedLimit";
  table[4341] = "gdi32.dll!NtGdiPlgBlt";
  table[4117] = "gdi32.dll!CombineTransform";
  table[4134] = "gdi32.dll!NtGdiCreateMetafileDC";
  table[4393] = "gdi32.dll!NtGdiSetVirtualResolution";
  table[4394] = "gdi32.dll!NtGdiSetSizeDevice";
  table[4381] = "gdi32.dll!NtGdiSetMetaRgn";
  table[4382] = "gdi32.dll!NtGdiSetMiterLimit";
  table[4377] = "gdi32.dll!NtGdiSetFontXform";
  table[4333] = "gdi32.dll!NtGdiMonoBitmap";
  table[4768] = "gdi32.dll!NtGdiXFORMOBJ_iGetXform";
  table[4770] = "gdi32.dll!NtGdiFONTOBJ_pxoGetXform";
  table[4239] = "gdi32.dll!NtGdiExtCreatePen";
  table[4286] = "gdi32.dll!GetMiterLimit";
  table[4290] = "gdi32.dll!NtGdiGetObjectBitmapHandle";
  table[4287] = "gdi32.dll!NtGdiGetMonitorID";
  table[4284] = "gdi32.dll!NtGdiGetKerningPairs";
  table[4357] = "gdi32.dll!NtGdiRoundRect";
  table[4242] = "gdi32.dll!NtGdiExtFloodFill";
  table[4306] = "gdi32.dll!GetSystemPaletteUse";
  table[4096] = "gdi32.dll!NtGdiAbortDoc";
  table[4097] = "gdi32.dll!NtGdiAbortPath";
  table[4099] = "gdi32.dll!NtGdiAddRemoteFontToDC";
  table[4100] = "gdi32.dll!NtGdiAddFontMemResourceEx";
  table[4101] = "gdi32.dll!NtGdiRemoveMergeFont";
  table[4102] = "gdi32.dll!NtGdiAddRemoteMMInstanceToDC";
  table[4104] = "gdi32.dll!NtGdiAngleArc";
  table[4107] = "gdi32.dll!NtGdiArcInternal";
  table[4108] = "gdi32.dll!NtGdiBeginPath";
  table[4110] = "gdi32.dll!NtGdiCancelDC";
  table[4111] = "gdi32.dll!NtGdiCheckBitmapBits";
  table[4112] = "gdi32.dll!NtGdiCloseFigure";
  table[4113] = "gdi32.dll!NtGdiClearBitmapAttributes";
  table[4114] = "gdi32.dll!NtGdiClearBrushAttributes";
  table[4115] = "gdi32.dll!NtGdiColorCorrectPalette";
  table[4119] = "gdi32.dll!NtGdiConfigureOPMProtectedOutput";
  table[4121] = "gdi32.dll!NtGdiConvertMetafileRect";
  table[4124] = "gdi32.dll!NtGdiCreateColorSpace";
  table[4125] = "gdi32.dll!NtGdiCreateColorTransform";
  table[4131] = "gdi32.dll!NtGdiCreateEllipticRgn";
  table[4133] = "gdi32.dll!NtGdiCreateHatchBrushInternal";
  table[4141] = "gdi32.dll!NtGdiCreateServerMetaFile";
  table[4143] = "gdi32.dll!NtGdiD3dContextCreate";
  table[4144] = "gdi32.dll!NtGdiD3dContextDestroy";
  table[4145] = "gdi32.dll!NtGdiD3dContextDestroyAll";
  table[4146] = "gdi32.dll!NtGdiD3dValidateTextureStageState";
  table[4147] = "gdi32.dll!NtGdiD3dDrawPrimitives2";
  table[4148] = "gdi32.dll!NtGdiDdGetDriverState";
  table[4149] = "gdi32.dll!NtGdiDdAddAttachedSurface";
  table[4150] = "gdi32.dll!NtGdiDdAlphaBlt";
  table[4151] = "gdi32.dll!NtGdiDdAttachSurface";
  table[4152] = "gdi32.dll!NtGdiDdBeginMoCompFrame";
  table[4153] = "gdi32.dll!NtGdiDdBlt";
  table[4154] = "gdi32.dll!NtGdiDdCanCreateSurface";
  table[4155] = "gdi32.dll!NtGdiDdCanCreateD3DBuffer";
  table[4156] = "gdi32.dll!NtGdiDdColorControl";
  table[4158] = "gdi32.dll!NtGdiDdCreateSurface";
  table[4159] = "gdi32.dll!NtGdiDdCreateD3DBuffer";
  table[4160] = "gdi32.dll!NtGdiDdCreateMoComp";
  table[4161] = "gdi32.dll!NtGdiDdCreateSurfaceObject";
  table[4162] = "gdi32.dll!NtGdiDdDeleteDirectDrawObject";
  table[4163] = "gdi32.dll!NtGdiDdDeleteSurfaceObject";
  table[4164] = "gdi32.dll!NtGdiDdDestroyMoComp";
  table[4165] = "gdi32.dll!NtGdiDdDestroySurface";
  table[4166] = "gdi32.dll!NtGdiDdDestroyD3DBuffer";
  table[4167] = "gdi32.dll!NtGdiDdEndMoCompFrame";
  table[4168] = "gdi32.dll!NtGdiDdFlip";
  table[4169] = "gdi32.dll!NtGdiDdFlipToGDISurface";
  table[4170] = "gdi32.dll!NtGdiDdGetAvailDriverMemory";
  table[4171] = "gdi32.dll!NtGdiDdGetBltStatus";
  table[4172] = "gdi32.dll!NtGdiDdGetDC";
  table[4173] = "gdi32.dll!NtGdiDdGetDriverInfo";
  table[4174] = "gdi32.dll!NtGdiDdGetDxHandle";
  table[4175] = "gdi32.dll!NtGdiDdGetFlipStatus";
  table[4176] = "gdi32.dll!NtGdiDdGetInternalMoCompInfo";
  table[4177] = "gdi32.dll!NtGdiDdGetMoCompBuffInfo";
  table[4178] = "gdi32.dll!NtGdiDdGetMoCompGuids";
  table[4179] = "gdi32.dll!NtGdiDdGetMoCompFormats";
  table[4180] = "gdi32.dll!NtGdiDdGetScanLine";
  table[4181] = "gdi32.dll!NtGdiDdLock";
  table[4182] = "gdi32.dll!NtGdiDdLockD3D";
  table[4183] = "gdi32.dll!NtGdiDdQueryDirectDrawObject";
  table[4184] = "gdi32.dll!NtGdiDdQueryMoCompStatus";
  table[4185] = "gdi32.dll!NtGdiDdReenableDirectDrawObject";
  table[4186] = "gdi32.dll!NtGdiDdReleaseDC";
  table[4187] = "gdi32.dll!NtGdiDdRenderMoComp";
  table[4188] = "gdi32.dll!NtGdiDdResetVisrgn";
  table[4189] = "gdi32.dll!NtGdiDdSetColorKey";
  table[4190] = "gdi32.dll!NtGdiDdSetExclusiveMode";
  table[4191] = "gdi32.dll!NtGdiDdSetGammaRamp";
  table[4192] = "gdi32.dll!NtGdiDdCreateSurfaceEx";
  table[4193] = "gdi32.dll!NtGdiDdSetOverlayPosition";
  table[4194] = "gdi32.dll!NtGdiDdUnattachSurface";
  table[4195] = "gdi32.dll!NtGdiDdUnlock";
  table[4196] = "gdi32.dll!NtGdiDdUnlockD3D";
  table[4197] = "gdi32.dll!NtGdiDdUpdateOverlay";
  table[4198] = "gdi32.dll!NtGdiDdWaitForVerticalBlank";
  table[4199] = "gdi32.dll!NtGdiDvpCanCreateVideoPort";
  table[4200] = "gdi32.dll!NtGdiDvpColorControl";
  table[4201] = "gdi32.dll!NtGdiDvpCreateVideoPort";
  table[4202] = "gdi32.dll!NtGdiDvpDestroyVideoPort";
  table[4203] = "gdi32.dll!NtGdiDvpFlipVideoPort";
  table[4204] = "gdi32.dll!NtGdiDvpGetVideoPortBandwidth";
  table[4205] = "gdi32.dll!NtGdiDvpGetVideoPortField";
  table[4206] = "gdi32.dll!NtGdiDvpGetVideoPortFlipStatus";
  table[4207] = "gdi32.dll!NtGdiDvpGetVideoPortInputFormats";
  table[4208] = "gdi32.dll!NtGdiDvpGetVideoPortLine";
  table[4209] = "gdi32.dll!NtGdiDvpGetVideoPortOutputFormats";
  table[4210] = "gdi32.dll!NtGdiDvpGetVideoPortConnectInfo";
  table[4211] = "gdi32.dll!NtGdiDvpGetVideoSignalStatus";
  table[4212] = "gdi32.dll!NtGdiDvpUpdateVideoPort";
  table[4213] = "gdi32.dll!NtGdiDvpWaitForVideoPortSync";
  table[4214] = "gdi32.dll!NtGdiDvpAcquireNotification";
  table[4215] = "gdi32.dll!NtGdiDvpReleaseNotification";
  table[4216] = "gdi32.dll!NtGdiDxgGenericThunk";
  table[4218] = "gdi32.dll!NtGdiDeleteColorSpace";
  table[4219] = "gdi32.dll!NtGdiDeleteColorTransform";
  table[4221] = "gdi32.dll!NtGdiDescribePixelFormat";
  table[4223] = "gdi32.dll!NtGdiGetPerBandInfo";
  table[4224] = "gdi32.dll!NtGdiDoBanding";
  table[4226] = "gdi32.dll!NtGdiDrawEscape";
  table[4227] = "gdi32.dll!NtGdiEllipse";
  table[4229] = "gdi32.dll!NtGdiEndDoc";
  table[4230] = "gdi32.dll!NtGdiEndPage";
  table[4231] = "gdi32.dll!NtGdiEndPath";
  table[4237] = "gdi32.dll!NtGdiEudcLoadUnloadLink";
  table[4246] = "gdi32.dll!NtGdiFillPath";
  table[4248] = "gdi32.dll!NtGdiFlattenPath";
  table[4250] = "gdi32.dll!NtGdiForceUFIMapping";
  table[4251] = "gdi32.dll!NtGdiFrameRgn";
  table[4252] = "gdi32.dll!NtGdiFullscreenControl";
  table[4256] = "gdi32.dll!NtGdiGetBitmapDimension";
  table[4261] = "gdi32.dll!NtGdiGetCharacterPlacementW";
  table[4265] = "gdi32.dll!NtGdiGetColorAdjustment";
  table[4267] = "gdi32.dll!NtGdiGetCOPPCompatibleOPMInformation";
  table[4276] = "gdi32.dll!NtGdiGetETM";
  table[4277] = "gdi32.dll!NtGdiGetEudcTimeStampEx";
  table[4279] = "gdi32.dll!NtGdiGetFontResourceInfoInternalW";
  table[4281] = "gdi32.dll!NtGdiGetGlyphIndicesWInternal";
  table[4282] = "gdi32.dll!NtGdiGetGlyphOutline";
  table[4283] = "gdi32.dll!NtGdiGetOPMInformation";
  table[4285] = "gdi32.dll!NtGdiGetLinkedUFIs";
  table[4293] = "gdi32.dll!NtGdiGetPath";
  table[4296] = "gdi32.dll!NtGdiGetRasterizerCaps";
  table[4300] = "gdi32.dll!NtGdiGetServerMetaFileBits";
  table[4301] = "gdi32.dll!NtGdiGetSpoolMessage";
  table[4304] = "gdi32.dll!NtGdiGetStringBitmapW";
  table[4308] = "gdi32.dll!NtGdiGetTextExtent";
  table[4313] = "gdi32.dll!NtGdiGetUFI";
  table[4314] = "gdi32.dll!NtGdiGetEmbUFI";
  table[4315] = "gdi32.dll!NtGdiGetUFIPathname";
  table[4316] = "gdi32.dll!NtGdiGetEmbedFonts";
  table[4317] = "gdi32.dll!NtGdiChangeGhostFont";
  table[4318] = "gdi32.dll!NtGdiAddEmbFontToDC";
  table[4323] = "gdi32.dll!NtGdiIcmBrushInfo";
  table[4325] = "gdi32.dll!NtGdiInitSpool";
  table[4329] = "gdi32.dll!NtGdiMakeFontDir";
  table[4330] = "gdi32.dll!NtGdiMakeInfoDC";
  table[4335] = "gdi32.dll!NtGdiOffsetClipRgn";
  table[4340] = "gdi32.dll!NtGdiPathToRegion";
  table[4342] = "gdi32.dll!NtGdiPolyDraw";
  table[4344] = "gdi32.dll!NtGdiPolyTextOutW";
  table[4346] = "gdi32.dll!NtGdiPtVisible";
  table[4347] = "gdi32.dll!NtGdiQueryFonts";
  table[4350] = "gdi32.dll!NtGdiRectInRegion";
  table[4352] = "gdi32.dll!NtGdiRemoveFontResourceW";
  table[4353] = "gdi32.dll!NtGdiRemoveFontMemResourceEx";
  table[4355] = "gdi32.dll!NtGdiResizePalette";
  table[4359] = "gdi32.dll!NtGdiScaleViewportExtEx";
  table[4360] = "gdi32.dll!NtGdiScaleWindowExtEx";
  table[4363] = "gdi32.dll!NtGdiSelectClipPath";
  table[4365] = "gdi32.dll!NtGdiSelectPen";
  table[4368] = "gdi32.dll!NtGdiSetBitmapDimension";
  table[4370] = "gdi32.dll!NtGdiSetBrushAttributes";
  table[4372] = "gdi32.dll!NtGdiSetColorAdjustment";
  table[4373] = "gdi32.dll!NtGdiSetColorSpace";
  table[4379] = "gdi32.dll!NtGdiSetLinkedUFIs";
  table[4380] = "gdi32.dll!NtGdiSetMagicColors";
  table[4383] = "gdi32.dll!NtGdiGetDeviceWidth";
  table[4384] = "gdi32.dll!NtGdiMirrorWindowOrg";
  table[4388] = "gdi32.dll!NtGdiSetPixelFormat";
  table[4389] = "gdi32.dll!NtGdiSetRectRgn";
  table[4390] = "gdi32.dll!NtGdiSetSystemPaletteUse";
  table[4395] = "gdi32.dll!NtGdiStartDoc";
  table[4396] = "gdi32.dll!NtGdiStartPage";
  table[4399] = "gdi32.dll!NtGdiStrokeAndFillPath";
  table[4400] = "gdi32.dll!NtGdiStrokePath";
  table[4401] = "gdi32.dll!NtGdiSwapBuffers";
  table[4404] = "gdi32.dll!NtGdiUnloadPrinterDriver";
  table[4406] = "gdi32.dll!NtGdiUnrealizeObject";
  table[4407] = "gdi32.dll!NtGdiUpdateColors";
  table[4408] = "gdi32.dll!NtGdiWidenPath";
  table[4728] = "gdi32.dll!NtGdiEngAssociateSurface";
  table[4729] = "gdi32.dll!NtGdiEngCreateBitmap";
  table[4730] = "gdi32.dll!NtGdiEngCreateDeviceSurface";
  table[4731] = "gdi32.dll!NtGdiEngCreateDeviceBitmap";
  table[4733] = "gdi32.dll!NtGdiEngComputeGlyphSet";
  table[4734] = "gdi32.dll!NtGdiEngCopyBits";
  table[4736] = "gdi32.dll!NtGdiEngDeleteSurface";
  table[4737] = "gdi32.dll!NtGdiEngEraseSurface";
  table[4738] = "gdi32.dll!NtGdiEngUnlockSurface";
  table[4739] = "gdi32.dll!NtGdiEngLockSurface";
  table[4740] = "gdi32.dll!NtGdiEngBitBlt";
  table[4741] = "gdi32.dll!NtGdiEngStretchBlt";
  table[4742] = "gdi32.dll!NtGdiEngPlgBlt";
  table[4743] = "gdi32.dll!NtGdiEngMarkBandingSurface";
  table[4744] = "gdi32.dll!NtGdiEngStrokePath";
  table[4745] = "gdi32.dll!NtGdiEngFillPath";
  table[4746] = "gdi32.dll!NtGdiEngStrokeAndFillPath";
  table[4747] = "gdi32.dll!NtGdiEngPaint";
  table[4748] = "gdi32.dll!NtGdiEngLineTo";
  table[4749] = "gdi32.dll!NtGdiEngAlphaBlend";
  table[4750] = "gdi32.dll!NtGdiEngGradientFill";
  table[4751] = "gdi32.dll!NtGdiEngTransparentBlt";
  table[4752] = "gdi32.dll!NtGdiEngTextOut";
  table[4753] = "gdi32.dll!NtGdiEngStretchBltROP";
  table[4754] = "gdi32.dll!NtGdiXLATEOBJ_cGetPalette";
  table[4755] = "gdi32.dll!NtGdiXLATEOBJ_iXlate";
  table[4756] = "gdi32.dll!NtGdiXLATEOBJ_hGetColorTransform";
  table[4757] = "gdi32.dll!NtGdiCLIPOBJ_bEnum";
  table[4758] = "gdi32.dll!NtGdiCLIPOBJ_cEnumStart";
  table[4759] = "gdi32.dll!NtGdiCLIPOBJ_ppoGetPath";
  table[4760] = "gdi32.dll!NtGdiEngDeletePath";
  table[4761] = "gdi32.dll!NtGdiEngCreateClip";
  table[4762] = "gdi32.dll!NtGdiEngDeleteClip";
  table[4763] = "gdi32.dll!NtGdiBRUSHOBJ_ulGetBrushColor";
  table[4764] = "gdi32.dll!NtGdiBRUSHOBJ_pvAllocRbrush";
  table[4765] = "gdi32.dll!NtGdiBRUSHOBJ_pvGetRbrush";
  table[4766] = "gdi32.dll!NtGdiBRUSHOBJ_hGetColorTransform";
  table[4767] = "gdi32.dll!NtGdiXFORMOBJ_bApplyXform";
  table[4769] = "gdi32.dll!NtGdiFONTOBJ_vGetInfo";
  table[4771] = "gdi32.dll!NtGdiFONTOBJ_cGetGlyphs";
  table[4772] = "gdi32.dll!NtGdiFONTOBJ_pifi";
  table[4773] = "gdi32.dll!NtGdiFONTOBJ_pfdg";
  table[4774] = "gdi32.dll!NtGdiFONTOBJ_pQueryGlyphAttrs";
  table[4775] = "gdi32.dll!NtGdiFONTOBJ_pvTrueTypeFontFile";
  table[4776] = "gdi32.dll!NtGdiFONTOBJ_cGetAllGlyphHandles";
  table[4777] = "gdi32.dll!NtGdiSTROBJ_bEnum";
  table[4778] = "gdi32.dll!NtGdiSTROBJ_bEnumPositionsOnly";
  table[4779] = "gdi32.dll!NtGdiSTROBJ_bGetAdvanceWidths";
  table[4780] = "gdi32.dll!NtGdiSTROBJ_vEnumStart";
  table[4781] = "gdi32.dll!NtGdiSTROBJ_dwGetCodePage";
  table[4782] = "gdi32.dll!NtGdiPATHOBJ_vGetBounds";
  table[4783] = "gdi32.dll!NtGdiPATHOBJ_bEnum";
  table[4784] = "gdi32.dll!NtGdiPATHOBJ_vEnumStart";
  table[4785] = "gdi32.dll!NtGdiPATHOBJ_vEnumStartClipLines";
  table[4786] = "gdi32.dll!NtGdiPATHOBJ_bEnumClipLines";
  table[4787] = "gdi32.dll!NtGdiGetDhpdev";
  table[4788] = "gdi32.dll!NtGdiEngCheckAbort";
  table[4789] = "gdi32.dll!NtGdiHT_Get8BPPFormatPalette";
  table[4790] = "gdi32.dll!NtGdiHT_Get8BPPMaskPalette";
  table[4791] = "gdi32.dll!NtGdiUpdateTransform";
  table[4793] = "gdi32.dll!NtGdiBRUSHOBJ_DeleteRbrush";
  table[4794] = "gdi32.dll!NtGdiUMPDEngFreeUserMem";
  table[4808] = "gdi32.dll!NtGdiDdDDICreateSynchronizationObject";
  table[4809] = "gdi32.dll!NtGdiDdDDIDestroySynchronizationObject";
  table[4810] = "gdi32.dll!NtGdiDdDDIWaitForSynchronizationObject";
  table[4811] = "gdi32.dll!NtGdiDdDDISignalSynchronizationObject";
  table[4812] = "gdi32.dll!NtGdiDdDDIGetRuntimeData";
  table[4818] = "gdi32.dll!NtGdiDdDDIGetMultisampleMethodList";
  table[4826] = "gdi32.dll!NtGdiDdDDIQueryStatistics";
  table[4829] = "gdi32.dll!NtGdiDdDDICreateOverlay";
  table[4830] = "gdi32.dll!NtGdiDdDDIUpdateOverlay";
  table[4831] = "gdi32.dll!NtGdiDdDDIFlipOverlay";
  table[4832] = "gdi32.dll!NtGdiDdDDIDestroyOverlay";
  table[4834] = "gdi32.dll!NtGdiDdDDISetGammaRamp";
  table[4839] = "gdi32.dll!NtGdiDdDDIGetContextSchedulingPriority";
  table[4841] = "gdi32.dll!NtGdiDdDDIGetProcessSchedulingPriorityClass";
  table[4842] = "gdi32.dll!NtGdiDdDDIReleaseProcessVidPnSourceOwners";
  table[4843] = "gdi32.dll!NtGdiDdDDIGetScanLine";
  table[4845] = "gdi32.dll!NtGdiDdDDIPollDisplayChildren";
  table[4846] = "gdi32.dll!NtGdiDdDDIInvalidateActiveVidPn";
  table[4847] = "gdi32.dll!NtGdiDdDDICheckOcclusion";
  table[4848] = "gdi32.dll!NtGdiDdDDIWaitForIdle";
  table[4851] = "gdi32.dll!NtGdiDdDDISetDisplayPrivateDriverFormat";
  table[4852] = "gdi32.dll!NtGdiDdDDISharedPrimaryLockNotification";
  table[4853] = "gdi32.dll!NtGdiDdDDISharedPrimaryUnLockNotification";
  table[4856] = "gdi32.dll!NtGdiGetNumberOfPhysicalMonitors";
  table[4857] = "gdi32.dll!NtGdiGetPhysicalMonitors";
  table[4858] = "gdi32.dll!NtGdiGetPhysicalMonitorDescription";
  table[4859] = "gdi32.dll!NtGdiDestroyPhysicalMonitor";
  table[4860] = "gdi32.dll!NtGdiDDCCIGetVCPFeature";
  table[4861] = "gdi32.dll!NtGdiDDCCISetVCPFeature";
  table[4862] = "gdi32.dll!NtGdiDDCCISaveCurrentSettings";
  table[4863] = "gdi32.dll!NtGdiDDCCIGetCapabilitiesStringLength";
  table[4864] = "gdi32.dll!NtGdiDDCCIGetCapabilitiesString";
  table[4865] = "gdi32.dll!NtGdiDDCCIGetTimingReport";
  table[0] = "ntdll.dll!NtAcceptConnectPort";
  table[1] = "ntdll.dll!NtAccessCheck";
  table[2] = "ntdll.dll!ZwAccessCheckAndAuditAlarm";
  table[3] = "ntdll.dll!NtAccessCheckByType";
  table[4] = "ntdll.dll!NtAccessCheckByTypeAndAuditAlarm";
  table[5] = "ntdll.dll!NtAccessCheckByTypeResultList";
  table[6] = "ntdll.dll!NtAccessCheckByTypeResultListAndAuditAlarm";
  table[7] = "ntdll.dll!ZwAccessCheckByTypeResultListAndAuditAlarmByHandle";
  table[8] = "ntdll.dll!NtAddAtom";
  table[9] = "ntdll.dll!ZwAddBootEntry";
  table[10] = "ntdll.dll!NtAddDriverEntry";
  table[11] = "ntdll.dll!ZwAdjustGroupsToken";
  table[12] = "ntdll.dll!ZwAdjustPrivilegesToken";
  table[13] = "ntdll.dll!NtAlertResumeThread";
  table[14] = "ntdll.dll!NtAlertThread";
  table[15] = "ntdll.dll!ZwAllocateLocallyUniqueId";
  table[16] = "ntdll.dll!NtAllocateUserPhysicalPages";
  table[17] = "ntdll.dll!NtAllocateUuids";
  table[18] = "ntdll.dll!NtAllocateVirtualMemory";
  table[19] = "ntdll.dll!NtAlpcAcceptConnectPort";
  table[20] = "ntdll.dll!ZwAlpcCancelMessage";
  table[21] = "ntdll.dll!ZwAlpcConnectPort";
  table[22] = "ntdll.dll!ZwAlpcCreatePort";
  table[23] = "ntdll.dll!NtAlpcCreatePortSection";
  table[24] = "ntdll.dll!ZwAlpcCreateResourceReserve";
  table[25] = "ntdll.dll!ZwAlpcCreateSectionView";
  table[26] = "ntdll.dll!ZwAlpcCreateSecurityContext";
  table[27] = "ntdll.dll!ZwAlpcDeletePortSection";
  table[28] = "ntdll.dll!NtAlpcDeleteResourceReserve";
  table[29] = "ntdll.dll!NtAlpcDeleteSectionView";
  table[30] = "ntdll.dll!NtAlpcDeleteSecurityContext";
  table[31] = "ntdll.dll!NtAlpcDisconnectPort";
  table[32] = "ntdll.dll!ZwAlpcImpersonateClientOfPort";
  table[33] = "ntdll.dll!ZwAlpcOpenSenderProcess";
  table[34] = "ntdll.dll!ZwAlpcOpenSenderThread";
  table[35] = "ntdll.dll!ZwAlpcQueryInformation";
  table[36] = "ntdll.dll!ZwAlpcQueryInformationMessage";
  table[37] = "ntdll.dll!NtAlpcRevokeSecurityContext";
  table[38] = "ntdll.dll!NtAlpcSendWaitReceivePort";
  table[39] = "ntdll.dll!NtAlpcSetInformation";
  table[40] = "ntdll.dll!NtApphelpCacheControl";
  table[41] = "ntdll.dll!ZwAreMappedFilesTheSame";
  table[42] = "ntdll.dll!ZwAssignProcessToJobObject";
  table[43] = "ntdll.dll!ZwCallbackReturn";
  table[44] = "ntdll.dll!NtCancelDeviceWakeupRequest";
  table[45] = "ntdll.dll!ZwCancelIoFile";
  table[46] = "ntdll.dll!ZwCancelTimer";
  table[47] = "ntdll.dll!NtClearEvent";
  table[48] = "ntdll.dll!NtClose";
  table[49] = "ntdll.dll!ZwCloseObjectAuditAlarm";
  table[50] = "ntdll.dll!NtCompactKeys";
  table[51] = "ntdll.dll!ZwCompareTokens";
  table[52] = "ntdll.dll!NtCompleteConnectPort";
  table[53] = "ntdll.dll!ZwCompressKey";
  table[54] = "ntdll.dll!NtConnectPort";
  table[55] = "ntdll.dll!ZwContinue";
  table[56] = "ntdll.dll!ZwCreateDebugObject";
  table[57] = "ntdll.dll!ZwCreateDirectoryObject";
  table[58] = "ntdll.dll!NtCreateEvent";
  table[59] = "ntdll.dll!NtCreateEventPair";
  table[60] = "ntdll.dll!NtCreateFile";
  table[61] = "ntdll.dll!NtCreateIoCompletion";
  table[62] = "ntdll.dll!ZwCreateJobObject";
  table[63] = "ntdll.dll!NtCreateJobSet";
  table[64] = "ntdll.dll!ZwCreateKey";
  table[65] = "ntdll.dll!NtCreateKeyTransacted";
  table[66] = "ntdll.dll!ZwCreateMailslotFile";
  table[67] = "ntdll.dll!ZwCreateMutant";
  table[68] = "ntdll.dll!ZwCreateNamedPipeFile";
  table[69] = "ntdll.dll!NtCreatePrivateNamespace";
  table[70] = "ntdll.dll!NtCreatePagingFile";
  table[71] = "ntdll.dll!ZwCreatePort";
  table[72] = "ntdll.dll!ZwCreateProcess";
  table[73] = "ntdll.dll!ZwCreateProcessEx";
  table[74] = "ntdll.dll!ZwCreateProfile";
  table[75] = "ntdll.dll!NtCreateSection";
  table[76] = "ntdll.dll!NtCreateSemaphore";
  table[77] = "ntdll.dll!ZwCreateSymbolicLinkObject";
  table[78] = "ntdll.dll!NtCreateThread";
  table[79] = "ntdll.dll!ZwCreateTimer";
  table[80] = "ntdll.dll!NtCreateToken";
  table[81] = "ntdll.dll!NtCreateTransaction";
  table[82] = "ntdll.dll!ZwOpenTransaction";
  table[83] = "ntdll.dll!ZwQueryInformationTransaction";
  table[84] = "ntdll.dll!NtQueryInformationTransactionManager";
  table[85] = "ntdll.dll!NtPrePrepareEnlistment";
  table[86] = "ntdll.dll!ZwPrepareEnlistment";
  table[87] = "ntdll.dll!NtCommitEnlistment";
  table[88] = "ntdll.dll!ZwReadOnlyEnlistment";
  table[89] = "ntdll.dll!ZwRollbackComplete";
  table[90] = "ntdll.dll!NtRollbackEnlistment";
  table[91] = "ntdll.dll!NtCommitTransaction";
  table[92] = "ntdll.dll!NtRollbackTransaction";
  table[93] = "ntdll.dll!ZwPrePrepareComplete";
  table[94] = "ntdll.dll!NtPrepareComplete";
  table[95] = "ntdll.dll!ZwCommitComplete";
  table[96] = "ntdll.dll!ZwSinglePhaseReject";
  table[97] = "ntdll.dll!ZwSetInformationTransaction";
  table[98] = "ntdll.dll!ZwSetInformationTransactionManager";
  table[99] = "ntdll.dll!ZwSetInformationResourceManager";
  table[100] = "ntdll.dll!ZwCreateTransactionManager";
  table[101] = "ntdll.dll!ZwOpenTransactionManager";
  table[102] = "ntdll.dll!NtRenameTransactionManager";
  table[103] = "ntdll.dll!NtRollforwardTransactionManager";
  table[104] = "ntdll.dll!NtRecoverEnlistment";
  table[105] = "ntdll.dll!NtRecoverResourceManager";
  table[106] = "ntdll.dll!ZwRecoverTransactionManager";
  table[107] = "ntdll.dll!ZwCreateResourceManager";
  table[108] = "ntdll.dll!ZwOpenResourceManager";
  table[109] = "ntdll.dll!ZwGetNotificationResourceManager";
  table[110] = "ntdll.dll!ZwQueryInformationResourceManager";
  table[111] = "ntdll.dll!ZwCreateEnlistment";
  table[112] = "ntdll.dll!ZwOpenEnlistment";
  table[113] = "ntdll.dll!NtSetInformationEnlistment";
  table[114] = "ntdll.dll!ZwQueryInformationEnlistment";
  table[115] = "ntdll.dll!ZwCreateWaitablePort";
  table[116] = "ntdll.dll!NtDebugActiveProcess";
  table[117] = "ntdll.dll!ZwDebugContinue";
  table[118] = "ntdll.dll!ZwDelayExecution";
  table[119] = "ntdll.dll!ZwDeleteAtom";
  table[120] = "ntdll.dll!NtDeleteBootEntry";
  table[121] = "ntdll.dll!ZwDeleteDriverEntry";
  table[122] = "ntdll.dll!NtDeleteFile";
  table[123] = "ntdll.dll!ZwDeleteKey";
  table[124] = "ntdll.dll!NtDeletePrivateNamespace";
  table[125] = "ntdll.dll!NtDeleteObjectAuditAlarm";
  table[126] = "ntdll.dll!NtDeleteValueKey";
  table[127] = "ntdll.dll!ZwDeviceIoControlFile";
  table[128] = "ntdll.dll!NtDisplayString";
  table[129] = "ntdll.dll!ZwDuplicateObject";
  table[130] = "ntdll.dll!NtDuplicateToken";
  table[131] = "ntdll.dll!ZwEnumerateBootEntries";
  table[132] = "ntdll.dll!NtEnumerateDriverEntries";
  table[133] = "ntdll.dll!ZwEnumerateKey";
  table[134] = "ntdll.dll!ZwEnumerateSystemEnvironmentValuesEx";
  table[135] = "ntdll.dll!ZwEnumerateTransactionObject";
  table[136] = "ntdll.dll!NtEnumerateValueKey";
  table[137] = "ntdll.dll!ZwExtendSection";
  table[138] = "ntdll.dll!NtFilterToken";
  table[139] = "ntdll.dll!NtFindAtom";
  table[140] = "ntdll.dll!ZwFlushBuffersFile";
  table[141] = "ntdll.dll!ZwFlushInstructionCache";
  table[142] = "ntdll.dll!NtFlushKey";
  table[143] = "ntdll.dll!ZwFlushProcessWriteBuffers";
  table[144] = "ntdll.dll!ZwFlushVirtualMemory";
  table[145] = "ntdll.dll!NtFlushWriteBuffer";
  table[146] = "ntdll.dll!NtFreeUserPhysicalPages";
  table[147] = "ntdll.dll!NtFreeVirtualMemory";
  table[148] = "ntdll.dll!NtFreezeRegistry";
  table[149] = "ntdll.dll!ZwFreezeTransactions";
  table[150] = "ntdll.dll!NtFsControlFile";
  table[151] = "ntdll.dll!NtGetContextThread";
  table[152] = "ntdll.dll!NtGetDevicePowerState";
  table[153] = "ntdll.dll!NtGetNlsSectionPtr";
  table[154] = "ntdll.dll!ZwGetPlugPlayEvent";
  table[155] = "ntdll.dll!NtGetWriteWatch";
  table[156] = "ntdll.dll!NtImpersonateAnonymousToken";
  table[157] = "ntdll.dll!ZwImpersonateClientOfPort";
  table[158] = "ntdll.dll!ZwImpersonateThread";
  table[159] = "ntdll.dll!ZwInitializeNlsFiles";
  table[160] = "ntdll.dll!ZwInitializeRegistry";
  table[161] = "ntdll.dll!NtInitiatePowerAction";
  table[162] = "ntdll.dll!ZwIsProcessInJob";
  table[163] = "ntdll.dll!NtIsSystemResumeAutomatic";
  table[164] = "ntdll.dll!ZwListenPort";
  table[165] = "ntdll.dll!NtLoadDriver";
  table[166] = "ntdll.dll!NtLoadKey";
  table[167] = "ntdll.dll!NtLoadKey2";
  table[168] = "ntdll.dll!NtLoadKeyEx";
  table[169] = "ntdll.dll!NtLockFile";
  table[170] = "ntdll.dll!ZwLockProductActivationKeys";
  table[171] = "ntdll.dll!NtLockRegistryKey";
  table[172] = "ntdll.dll!ZwLockVirtualMemory";
  table[173] = "ntdll.dll!ZwMakePermanentObject";
  table[174] = "ntdll.dll!NtMakeTemporaryObject";
  table[175] = "ntdll.dll!NtMapUserPhysicalPages";
  table[176] = "ntdll.dll!ZwMapUserPhysicalPagesScatter";
  table[177] = "ntdll.dll!ZwMapViewOfSection";
  table[178] = "ntdll.dll!NtModifyBootEntry";
  table[179] = "ntdll.dll!ZwModifyDriverEntry";
  table[180] = "ntdll.dll!NtNotifyChangeDirectoryFile";
  table[181] = "ntdll.dll!NtNotifyChangeKey";
  table[182] = "ntdll.dll!NtNotifyChangeMultipleKeys";
  table[183] = "ntdll.dll!ZwOpenDirectoryObject";
  table[184] = "ntdll.dll!NtOpenEvent";
  table[185] = "ntdll.dll!NtOpenEventPair";
  table[186] = "ntdll.dll!NtOpenFile";
  table[187] = "ntdll.dll!ZwOpenIoCompletion";
  table[188] = "ntdll.dll!ZwOpenJobObject";
  table[189] = "ntdll.dll!ZwOpenKey";
  table[190] = "ntdll.dll!NtOpenKeyTransacted";
  table[191] = "ntdll.dll!NtOpenMutant";
  table[192] = "ntdll.dll!NtOpenPrivateNamespace";
  table[193] = "ntdll.dll!ZwOpenObjectAuditAlarm";
  table[194] = "ntdll.dll!ZwOpenProcess";
  table[195] = "ntdll.dll!ZwOpenProcessToken";
  table[196] = "ntdll.dll!ZwOpenProcessTokenEx";
  table[197] = "ntdll.dll!NtOpenSection";
  table[198] = "ntdll.dll!NtOpenSemaphore";
  table[199] = "ntdll.dll!NtOpenSession";
  table[200] = "ntdll.dll!NtOpenSymbolicLinkObject";
  table[201] = "ntdll.dll!ZwOpenThread";
  table[202] = "ntdll.dll!NtOpenThreadToken";
  table[203] = "ntdll.dll!NtOpenThreadTokenEx";
  table[204] = "ntdll.dll!ZwOpenTimer";
  table[205] = "ntdll.dll!NtPlugPlayControl";
  table[206] = "ntdll.dll!ZwPowerInformation";
  table[207] = "ntdll.dll!ZwPrivilegeCheck";
  table[208] = "ntdll.dll!ZwPrivilegeObjectAuditAlarm";
  table[209] = "ntdll.dll!NtPrivilegedServiceAuditAlarm";
  table[210] = "ntdll.dll!ZwProtectVirtualMemory";
  table[211] = "ntdll.dll!ZwPulseEvent";
  table[212] = "ntdll.dll!ZwQueryAttributesFile";
  table[213] = "ntdll.dll!ZwQueryBootEntryOrder";
  table[214] = "ntdll.dll!ZwQueryBootOptions";
  table[215] = "ntdll.dll!NtQueryDebugFilterState";
  table[216] = "ntdll.dll!NtQueryDefaultLocale";
  table[217] = "ntdll.dll!ZwQueryDefaultUILanguage";
  table[218] = "ntdll.dll!ZwQueryDirectoryFile";
  table[219] = "ntdll.dll!ZwQueryDirectoryObject";
  table[220] = "ntdll.dll!NtQueryDriverEntryOrder";
  table[221] = "ntdll.dll!ZwQueryEaFile";
  table[222] = "ntdll.dll!NtQueryEvent";
  table[223] = "ntdll.dll!ZwQueryFullAttributesFile";
  table[224] = "ntdll.dll!NtQueryInformationAtom";
  table[225] = "ntdll.dll!ZwQueryInformationFile";
  table[226] = "ntdll.dll!ZwQueryInformationJobObject";
  table[227] = "ntdll.dll!ZwQueryInformationPort";
  table[228] = "ntdll.dll!ZwQueryInformationProcess";
  table[229] = "ntdll.dll!NtQueryInformationThread";
  table[230] = "ntdll.dll!ZwQueryInformationToken";
  table[231] = "ntdll.dll!NtQueryInstallUILanguage";
  table[232] = "ntdll.dll!NtQueryIntervalProfile";
  table[233] = "ntdll.dll!NtQueryIoCompletion";
  table[234] = "ntdll.dll!ZwQueryKey";
  table[235] = "ntdll.dll!NtQueryMultipleValueKey";
  table[236] = "ntdll.dll!NtQueryMutant";
  table[237] = "ntdll.dll!NtQueryObject";
  table[238] = "ntdll.dll!NtQueryOpenSubKeys";
  table[239] = "ntdll.dll!NtQueryOpenSubKeysEx";
  table[240] = "ntdll.dll!NtQueryPerformanceCounter";
  table[241] = "ntdll.dll!ZwQueryQuotaInformationFile";
  table[242] = "ntdll.dll!ZwQuerySection";
  table[243] = "ntdll.dll!NtQuerySecurityObject";
  table[244] = "ntdll.dll!ZwQuerySemaphore";
  table[245] = "ntdll.dll!ZwQuerySymbolicLinkObject";
  table[246] = "ntdll.dll!ZwQuerySystemEnvironmentValue";
  table[247] = "ntdll.dll!ZwQuerySystemEnvironmentValueEx";
  table[248] = "ntdll.dll!NtQuerySystemInformation";
  table[249] = "ntdll.dll!NtQuerySystemTime";
  table[250] = "ntdll.dll!ZwQueryTimer";
  table[251] = "ntdll.dll!NtQueryTimerResolution";
  table[252] = "ntdll.dll!ZwQueryValueKey";
  table[253] = "ntdll.dll!NtQueryVirtualMemory";
  table[254] = "ntdll.dll!NtQueryVolumeInformationFile";
  table[255] = "ntdll.dll!NtQueueApcThread";
  table[256] = "ntdll.dll!ZwRaiseException";
  table[257] = "ntdll.dll!ZwRaiseHardError";
  table[258] = "ntdll.dll!NtReadFile";
  table[259] = "ntdll.dll!NtReadFileScatter";
  table[260] = "ntdll.dll!ZwReadRequestData";
  table[261] = "ntdll.dll!NtReadVirtualMemory";
  table[262] = "ntdll.dll!ZwRegisterThreadTerminatePort";
  table[263] = "ntdll.dll!ZwReleaseMutant";
  table[264] = "ntdll.dll!NtReleaseSemaphore";
  table[265] = "ntdll.dll!ZwRemoveIoCompletion";
  table[266] = "ntdll.dll!ZwRemoveProcessDebug";
  table[267] = "ntdll.dll!ZwRenameKey";
  table[268] = "ntdll.dll!ZwReplaceKey";
  table[269] = "ntdll.dll!NtReplacePartitionUnit";
  table[270] = "ntdll.dll!ZwReplyPort";
  table[271] = "ntdll.dll!NtReplyWaitReceivePort";
  table[272] = "ntdll.dll!NtReplyWaitReceivePortEx";
  table[273] = "ntdll.dll!NtReplyWaitReplyPort";
  table[274] = "ntdll.dll!ZwRequestDeviceWakeup";
  table[275] = "ntdll.dll!ZwRequestPort";
  table[276] = "ntdll.dll!NtRequestWaitReplyPort";
  table[277] = "ntdll.dll!ZwRequestWakeupLatency";
  table[278] = "ntdll.dll!NtResetEvent";
  table[279] = "ntdll.dll!ZwResetWriteWatch";
  table[280] = "ntdll.dll!NtRestoreKey";
  table[281] = "ntdll.dll!ZwResumeProcess";
  table[282] = "ntdll.dll!ZwResumeThread";
  table[283] = "ntdll.dll!NtSaveKey";
  table[284] = "ntdll.dll!NtSaveKeyEx";
  table[285] = "ntdll.dll!NtSaveMergedKeys";
  table[286] = "ntdll.dll!NtSecureConnectPort";
  table[287] = "ntdll.dll!ZwSetBootEntryOrder";
  table[288] = "ntdll.dll!ZwSetBootOptions";
  table[289] = "ntdll.dll!ZwSetContextThread";
  table[290] = "ntdll.dll!NtSetDebugFilterState";
  table[291] = "ntdll.dll!NtSetDefaultHardErrorPort";
  table[292] = "ntdll.dll!NtSetDefaultLocale";
  table[293] = "ntdll.dll!ZwSetDefaultUILanguage";
  table[294] = "ntdll.dll!NtSetDriverEntryOrder";
  table[295] = "ntdll.dll!ZwSetEaFile";
  table[296] = "ntdll.dll!NtSetEvent";
  table[297] = "ntdll.dll!NtSetEventBoostPriority";
  table[298] = "ntdll.dll!NtSetHighEventPair";
  table[299] = "ntdll.dll!NtSetHighWaitLowEventPair";
  table[300] = "ntdll.dll!ZwSetInformationDebugObject";
  table[301] = "ntdll.dll!ZwSetInformationFile";
  table[302] = "ntdll.dll!ZwSetInformationJobObject";
  table[303] = "ntdll.dll!ZwSetInformationKey";
  table[304] = "ntdll.dll!ZwSetInformationObject";
  table[305] = "ntdll.dll!ZwSetInformationProcess";
  table[306] = "ntdll.dll!ZwSetInformationThread";
  table[307] = "ntdll.dll!ZwSetInformationToken";
  table[308] = "ntdll.dll!NtSetIntervalProfile";
  table[309] = "ntdll.dll!NtSetIoCompletion";
  table[310] = "ntdll.dll!ZwSetLdtEntries";
  table[311] = "ntdll.dll!ZwSetLowEventPair";
  table[312] = "ntdll.dll!ZwSetLowWaitHighEventPair";
  table[313] = "ntdll.dll!ZwSetQuotaInformationFile";
  table[314] = "ntdll.dll!NtSetSecurityObject";
  table[315] = "ntdll.dll!ZwSetSystemEnvironmentValue";
  table[316] = "ntdll.dll!ZwSetSystemEnvironmentValueEx";
  table[317] = "ntdll.dll!ZwSetSystemInformation";
  table[318] = "ntdll.dll!ZwSetSystemPowerState";
  table[319] = "ntdll.dll!ZwSetSystemTime";
  table[320] = "ntdll.dll!ZwSetThreadExecutionState";
  table[321] = "ntdll.dll!ZwSetTimer";
  table[322] = "ntdll.dll!NtSetTimerResolution";
  table[323] = "ntdll.dll!ZwSetUuidSeed";
  table[324] = "ntdll.dll!ZwSetValueKey";
  table[325] = "ntdll.dll!NtSetVolumeInformationFile";
  table[326] = "ntdll.dll!ZwShutdownSystem";
  table[327] = "ntdll.dll!ZwSignalAndWaitForSingleObject";
  table[328] = "ntdll.dll!NtStartProfile";
  table[329] = "ntdll.dll!ZwStopProfile";
  table[330] = "ntdll.dll!ZwSuspendProcess";
  table[331] = "ntdll.dll!ZwSuspendThread";
  table[332] = "ntdll.dll!NtSystemDebugControl";
  table[333] = "ntdll.dll!ZwTerminateJobObject";
  table[334] = "ntdll.dll!ZwTerminateProcess";
  table[335] = "ntdll.dll!ZwTerminateThread";
  table[336] = "ntdll.dll!NtTestAlert";
  table[337] = "ntdll.dll!ZwThawRegistry";
  table[338] = "ntdll.dll!NtThawTransactions";
  table[339] = "ntdll.dll!NtTraceEvent";
  table[340] = "ntdll.dll!ZwTraceControl";
  table[341] = "ntdll.dll!NtTranslateFilePath";
  table[342] = "ntdll.dll!ZwUnloadDriver";
  table[343] = "ntdll.dll!NtUnloadKey";
  table[344] = "ntdll.dll!ZwUnloadKey2";
  table[345] = "ntdll.dll!ZwUnloadKeyEx";
  table[346] = "ntdll.dll!ZwUnlockFile";
  table[347] = "ntdll.dll!NtUnlockVirtualMemory";
  table[348] = "ntdll.dll!NtUnmapViewOfSection";
  table[349] = "ntdll.dll!NtVdmControl";
  table[350] = "ntdll.dll!NtWaitForDebugEvent";
  table[351] = "ntdll.dll!NtWaitForMultipleObjects";
  table[352] = "ntdll.dll!ZwWaitForSingleObject";
  table[353] = "ntdll.dll!ZwWaitHighEventPair";
  table[354] = "ntdll.dll!NtWaitLowEventPair";
  table[355] = "ntdll.dll!NtWriteFile";
  table[356] = "ntdll.dll!NtWriteFileGather";
  table[357] = "ntdll.dll!NtWriteRequestData";
  table[358] = "ntdll.dll!NtWriteVirtualMemory";
  table[359] = "ntdll.dll!ZwYieldExecution";
  table[360] = "ntdll.dll!ZwCreateKeyedEvent";
  table[361] = "ntdll.dll!NtOpenKeyedEvent";
  table[362] = "ntdll.dll!NtReleaseKeyedEvent";
  table[363] = "ntdll.dll!NtWaitForKeyedEvent";
  table[364] = "ntdll.dll!ZwQueryPortInformationProcess";
  table[365] = "ntdll.dll!NtGetCurrentProcessorNumber";
  table[366] = "ntdll.dll!NtWaitForMultipleObjects32";
  table[367] = "ntdll.dll!ZwGetNextProcess";
  table[368] = "ntdll.dll!ZwGetNextThread";
  table[369] = "ntdll.dll!NtCancelIoFileEx";
  table[370] = "ntdll.dll!NtCancelSynchronousIoFile";
  table[371] = "ntdll.dll!ZwRemoveIoCompletionEx";
  table[372] = "ntdll.dll!ZwRegisterProtocolAddressInformation";
  table[373] = "ntdll.dll!NtPropagationComplete";
  table[374] = "ntdll.dll!ZwPropagationFailed";
  table[375] = "ntdll.dll!NtCreateWorkerFactory";
  table[376] = "ntdll.dll!ZwReleaseWorkerFactoryWorker";
  table[377] = "ntdll.dll!NtWaitForWorkViaWorkerFactory";
  table[378] = "ntdll.dll!ZwSetInformationWorkerFactory";
  table[379] = "ntdll.dll!ZwQueryInformationWorkerFactory";
  table[380] = "ntdll.dll!NtWorkerFactoryWorkerReady";
  table[381] = "ntdll.dll!NtShutdownWorkerFactory";
  table[382] = "ntdll.dll!NtCreateThreadEx";
  table[383] = "ntdll.dll!NtCreateUserProcess";
  table[384] = "ntdll.dll!NtQueryLicenseValue";
  table[385] = "ntdll.dll!ZwMapCMFModule";
  table[386] = "ntdll.dll!ZwIsUILanguageComitted";
  table[387] = "ntdll.dll!ZwFlushInstallUILanguage";
  table[388] = "ntdll.dll!NtGetMUIRegistryInfo";
  table[389] = "ntdll.dll!ZwAcquireCMFViewOwnership";
  table[390] = "ntdll.dll!NtReleaseCMFViewOwnership";
  table[4545] = "imm32.dll!NtUserGetThreadState";
  table[4520] = "imm32.dll!NtUserGetImeInfoEx";
  table[4600] = "imm32.dll!NtUserQueryWindow";
  table[4598] = "imm32.dll!NtUserQueryInputContext";
  table[4581] = "imm32.dll!NtUserNotifyIMEStatus";
  table[4412] = "imm32.dll!NtUserAssociateInputContext";
  table[4429] = "imm32.dll!NtUserCallOneParam";
  table[4463] = "imm32.dll!NtUserDisableThreadIme";
  table[4635] = "imm32.dll!NtUserSetImeInfoEx";
  table[4697] = "imm32.dll!NtUserUpdateInputContext";
  table[4417] = "imm32.dll!NtUserBuildHimcList";
  table[4704] = "imm32.dll!NtUserValidateHandleSecure";
  table[4450] = "imm32.dll!NtUserCreateInputContext";
  table[4460] = "imm32.dll!NtUserDestroyInputContext";
  table[4492] = "imm32.dll!NtUserGetAppImeLevel";
  table[4519] = "imm32.dll!NtUserGetImeHotKey";
  table[4623] = "imm32.dll!NtUserSetAppImeLevel";
  table[4657] = "imm32.dll!NtUserSetThreadLayoutHandles";
  table[4560] = "user32.dll!NtUserInitializeClientPfnArrays";
  table[4596] = "user32.dll!NtUserProcessConnect";
  table[4453] = "user32.dll!NtUserCreateWindowStation";
  table[4449] = "user32.dll!NtUserCreateDesktopEx";
  table[4695] = "user32.dll!NtUserUnregisterUserApiHook";
  table[4607] = "user32.dll!NtUserRegisterUserApiHook";
  table[4634] = "user32.dll!NtUserSetImeHotKey";
  table[4670] = "user32.dll!NtUserSetWindowStationUser";
  table[4568] = "user32.dll!NtUserLoadKeyboardLayoutEx";
  table[4702] = "user32.dll!NtUserUpdatePerUserSystemParameters";
  table[4465] = "user32.dll!NtUserDoSoundConnect";
  table[4720] = "user32.dll!NtUserRegisterSessionPort";
  table[4423] = "user32.dll!NtUserCallHwndOpt";
  table[4651] = "user32.dll!NtUserSetShellWindowEx";
  table[4421] = "user32.dll!NtUserCallHwnd";
  table[4723] = "user32.dll!NtUserDwmStartRedirection";
  table[4609] = "user32.dll!NtUserRegisterRawInputDevices";
  table[4495] = "user32.dll!NtUserGetCaretBlinkTime";
  table[4681] = "user32.dll!NtUserThunkedMenuInfo";
  table[4570] = "user32.dll!NtUserLockWindowUpdate";
  table[4445] = "user32.dll!NtUserCopyAcceleratorTable";
  table[4478] = "user32.dll!NtUserEndMenu";
  table[4458] = "user32.dll!DestroyAcceleratorTable";
  table[4625] = "user32.dll!NtUserSetClassLong";
  table[4613] = "user32.dll!NtUserRemoveMenu";
  table[4643] = "user32.dll!NtUserSetMenuDefaultItem";
  table[4461] = "user32.dll!NtUserDestroyMenu";
  table[4553] = "user32.dll!NtUserGhostWindowFromHungWindow";
  table[4590] = "user32.dll!NtUserPaintMonitor";
  table[4589] = "user32.dll!NtUserPaintDesktop";
  table[4454] = "user32.dll!NtUserDdeInitialize";
  table[4663] = "user32.dll!NtUserSetWindowPlacement";
  table[4669] = "user32.dll!NtUserSetWindowsHookEx";
  table[4457] = "user32.dll!NtUserDeleteMenu";
  table[4565] = "user32.dll!NtUserInvalidateRgn";
  table[4638] = "user32.dll!NtUserSetInformationThread";
  table[4493] = "user32.dll!NtUserGetAsyncKeyState";
  table[4434] = "user32.dll!NtUserCheckDesktopByThreadId";
  table[4727] = "user32.dll!NtUserGetWindowMinimizeRect";
  table[4672] = "user32.dll!NtUserSetWinEventHook";
  table[4508] = "user32.dll!NtUserGetCPD";
  table[4665] = "user32.dll!NtUserSetWindowRgn";
  table[4569] = "user32.dll!NtUserLockWindowStation";
  table[4485] = "user32.dll!NtUserFillWindow";
  table[4677] = "user32.dll!NtUserSoundSentry";
  table[4696] = "user32.dll!NtUserUnregisterHotKey";
  table[4524] = "user32.dll!NtUserGetKeyboardState";
  table[4691] = "user32.dll!NtUserUnhookWinEvent";
  table[4621] = "user32.dll!NtUserSendInput";
  table[4658] = "user32.dll!NtUserSetThreadState";
  table[4624] = "user32.dll!NtUserSetCapture";
  table[4633] = "user32.dll!NtUserSetFocus";
  table[4636] = "user32.dll!NtUserSetImeOwnerWindow";
  table[4425] = "user32.dll!NtUserCallHwndParamLock";
  table[4686] = "user32.dll!NtUserCalcMenuBar";
  table[4546] = "user32.dll!NtUserGetTitleBarInfo";
  table[4512] = "user32.dll!NtUserGetDCEx";
  table[4528] = "user32.dll!NtUserGetMenuBarInfo";
  table[4678] = "user32.dll!NtUserSwitchDesktop";
  table[4522] = "user32.dll!NtUserGetKeyboardLayoutList";
  table[4675] = "user32.dll!NtUserShowWindow";
  table[4660] = "user32.dll!NtUserSetProcessDPIAware";
  table[4646] = "user32.dll!NtUserSetParent";
  table[4693] = "user32.dll!NtUserUnlockWindowStation";
  table[4684] = "user32.dll!NtUserTrackMouseEvent";
  table[4608] = "user32.dll!NtUserRegisterHotKey";
  table[4701] = "user32.dll!NtUserSetLayeredWindowAttributes";
  table[4580] = "user32.dll!NtUserMoveWindow";
  table[4699] = "user32.dll!NtUserUpdateLayeredWindow";
  table[4542] = "user32.dll!NtUserGetScrollBarInfo";
  table[4447] = "user32.dll!NtUserCreateAcceleratorTable";
  table[4630] = "user32.dll!NtUserSetCursor";
  table[4586] = "user32.dll!NtUserOpenInputDesktop";
  table[4514] = "user32.dll!NtUserGetForegroundWindow";
  table[4548] = "user32.dll!GetUpdateRect";
  table[4656] = "user32.dll!NtUserSetThreadDesktop";
  table[4536] = "user32.dll!NtUserGetProcessWindowStation";
  table[4647] = "user32.dll!NtUserSetProcessWindowStation";
  table[4605] = "user32.dll!NtUserRegisterClassExWOW";
  table[4494] = "user32.dll!NtUserGetAtomName";
  table[4697] = "user32.dll!NtUserUpdateInputContext";
  table[4661] = "user32.dll!NtUserSetWindowFNID";
  table[4498] = "user32.dll!NtUserGetClassName";
  table[4516] = "user32.dll!NtUserGetGUIThreadInfo";
  table[4585] = "user32.dll!NtUserOpenDesktop";
  table[4419] = "user32.dll!NtUserBuildNameList";
  table[4617] = "user32.dll!NtUserSBGetParms";
  table[4674] = "user32.dll!NtUserShowScrollBar";
  table[4588] = "user32.dll!NtUserOpenWindowStation";
  table[4694] = "user32.dll!NtUserUnregisterClass";
  table[4481] = "user32.dll!NtUserEnumDisplayMonitors";
  table[4462] = "user32.dll!NtUserDestroyWindow";
  table[4441] = "user32.dll!NtUserCloseDesktop";
  table[4459] = "user32.dll!NtUserDestroyCursor";
  table[4442] = "user32.dll!NtUserCloseWindowStation";
  table[4418] = "user32.dll!NtUserBuildHwndList";
  table[4594] = "user32.dll!NtUserPostThreadMessage";
  table[4614] = "user32.dll!NtUserRemoveProp";
  table[4662] = "user32.dll!NtUserSetWindowLong";
  table[4664] = "user32.dll!NtUserSetWindowPos";
  table[4422] = "user32.dll!NtUserCallHwndLock";
  table[4649] = "user32.dll!NtUserSetProp";
  table[4477] = "user32.dll!NtUserEndDeferWindowPosEx";
  table[4455] = "user32.dll!NtUserDeferWindowPos";
  table[4632] = "user32.dll!NtUserSetCursorIconData";
  table[4486] = "user32.dll!NtUserFindExistingCursorIcon";
  table[4533] = "user32.dll!NtUserGetObjectInformation";
  table[4452] = "user32.dll!NtUserCreateWindowEx";
  table[4682] = "user32.dll!NtUserThunkedMenuItemInfo";
  table[4543] = "user32.dll!NtUserGetSystemMenu";
  table[4676] = "user32.dll!NtUserShowWindowAsync";
  table[4600] = "user32.dll!NtUserQueryWindow";
  table[4517] = "user32.dll!NtUserGetIconInfo";
  table[4518] = "user32.dll!NtUserGetIconSize";
  table[4583] = "user32.dll!NtUserNotifyWinEvent";
  table[4562] = "user32.dll!NtUserInternalGetWindowText";
  table[4666] = "user32.dll!NtUserGetWindowRgnEx";
  table[4472] = "user32.dll!NtUserDrawIconEx";
  table[4424] = "user32.dll!NtUserCallHwndParam";
  table[4409] = "user32.dll!NtUserActivateKeyboardLayout";
  table[4629] = "user32.dll!NtUserSetConsoleReserveKeys";
  table[4557] = "user32.dll!NtUserHungWindowFromGhostWindow";
  table[4622] = "user32.dll!NtUserSetActiveWindow";
  table[4544] = "user32.dll!NtUserGetThreadDesktop";
  table[4497] = "user32.dll!NtUserGetClassInfoEx";
  table[4480] = "user32.dll!NtUserEnumDisplayDevices";
  table[4482] = "user32.dll!NtUserEnumDisplaySettings";
  table[4650] = "user32.dll!NtUserSetScrollInfo";
  table[4526] = "user32.dll!NtUserGetKeyState";
  table[4575] = "user32.dll!NtUserMessageCall";
  table[4706] = "user32.dll!NtUserValidateTimerCallback";
  table[4611] = "user32.dll!NtUserRegisterWindowMessage";
  table[4511] = "user32.dll!NtUserGetDC";
  table[4602] = "user32.dll!NtUserRealInternalGetMessage";
  table[4487] = "user32.dll!NtUserFindWindowEx";
  table[4500] = "user32.dll!NtUserGetClipboardFormatName";
  table[4545] = "user32.dll!NtUserGetThreadState";
  table[4679] = "user32.dll!NtUserSystemParametersInfo";
  table[4593] = "user32.dll!NtUserPostMessage";
  table[4659] = "user32.dll!NtUserSetTimer";
  table[4567] = "user32.dll!NtUserKillTimer";
  table[4414] = "user32.dll!NtUserBeginPaint";
  table[4479] = "user32.dll!NtUserEndPaint";
  table[4604] = "user32.dll!NtUserRedrawWindow";
  table[4491] = "user32.dll!NtUserGetAncestor";
  table[4555] = "user32.dll!NtUserHideCaret";
  table[4673] = "user32.dll!NtUserShowCaret";
  table[4448] = "user32.dll!NtUserCreateCaret";
  table[4531] = "user32.dll!NtUserGetMessage";
  table[4591] = "user32.dll!PeekMessageW";
  table[4429] = "user32.dll!NtUserCallOneParam";
  table[4428] = "user32.dll!NtUserCallNoParam";
  table[4464] = "user32.dll!NtUserDispatchMessage";
  table[4648] = "user32.dll!NtUserGetProp";
  table[4550] = "user32.dll!NtUserGetWindowDC";
  table[4513] = "user32.dll!NtUserGetDoubleClickTime";
  table[4710] = "user32.dll!NtUserWaitMessage";
  table[4564] = "user32.dll!NtUserInvalidateRect";
  table[4430] = "user32.dll!NtUserCallTwoParam";
  table[4618] = "user32.dll!NtUserScrollDC";
  table[4704] = "user32.dll!NtUserValidateHandleSecure";
  table[4439] = "user32.dll!NtUserClipCursor";
  table[4571] = "user32.dll!NtUserLockWorkStation";
  table[4724] = "user32.dll!NtUserDwmStopRedirection";
  table[4534] = "user32.dll!NtUserGetOpenClipboardWindow";
  table[4484] = "user32.dll!NtUserExcludeUpdateRgn";
  table[4707] = "user32.dll!NtUserVkKeyScanEx";
  table[4654] = "user32.dll!NtUserSetSystemMenu";
  table[4438] = "user32.dll!NtUserChildWindowFromPointEx";
  table[4671] = "user32.dll!NtUserSetWindowWord";
  table[4476] = "user32.dll!NtUserEnableScrollBar";
  table[4415] = "user32.dll!NtUserBitBltSysBmp";
  table[4509] = "user32.dll!NtUserGetCursorFrameInfo";
  table[4427] = "user32.dll!NtUserCallNextHookEx";
  table[4628] = "user32.dll!NtUserSetClipboardViewer";
  table[4437] = "user32.dll!CheckMenuItem";
  table[4566] = "user32.dll!NtUserIsClipboardFormatAvailable";
  table[4440] = "user32.dll!NtUserCloseClipboard";
  table[4584] = "user32.dll!NtUserOpenClipboard";
  table[4502] = "user32.dll!NtUserGetClipboardSequenceNumber";
  table[4431] = "user32.dll!NtUserChangeClipboardChain";
  table[4688] = "user32.dll!NtUserTranslateAccelerator";
  table[4705] = "user32.dll!NtUserValidateRect";
  table[4667] = "user32.dll!NtUserSetWindowRgnEx";
  table[4475] = "user32.dll!NtUserEnableMenuItem";
  table[4496] = "user32.dll!NtUserGetCaretPos";
  table[4505] = "user32.dll!NtUserGetComboBoxInfo";
  table[4426] = "user32.dll!NtUserCallMsgFilter";
  table[4690] = "user32.dll!NtUserUnhookWindowsHookEx";
  table[4416] = "user32.dll!NtUserBlockInput";
  table[4595] = "user32.dll!NtUserPrintWindow";
  table[4501] = "user32.dll!NtUserGetClipboardOwner";
  table[4413] = "user32.dll!NtUserAttachThreadInput";
  table[4446] = "user32.dll!NtUserCountClipboardFormats";
  table[4572] = "user32.dll!NtUserLogicalToPhysicalPoint";
  table[4592] = "user32.dll!NtUserPhysicalToLogicalPoint";
  table[4712] = "user32.dll!NtUserWindowFromPhysicalPoint";
  table[4685] = "user32.dll!NtUserTrackPopupMenuEx";
  table[4641] = "user32.dll!NtUserSetMenu";
  table[4432] = "user32.dll!NtUserChangeDisplaySettings";
  table[4726] = "user32.dll!NtUserDwmGetDxRgn";
  table[4725] = "user32.dll!NtUserDwmHintDxUpdate";
  table[4573] = "user32.dll!NtUserMapVirtualKeyEx";
  table[4640] = "user32.dll!NtUserSetKeyboardState";
  table[4708] = "user32.dll!NtUserWaitForInputIdle";
  table[4549] = "user32.dll!NtUserGetUpdateRgn";
  table[4456] = "user32.dll!NtUserDefSetText";
  table[4506] = "user32.dll!NtUserGetControlBrush";
  table[4488] = "user32.dll!NtUserFlashWindowEx";
  table[4689] = "user32.dll!NtUserTranslateMessage";
  table[4619] = "user32.dll!NtUserScrollWindowEx";
  table[4687] = "user32.dll!NtUserPaintMenuBar";
  table[4551] = "user32.dll!NtUserGetWindowPlacement";
  table[4713] = "user32.dll!NtUserWindowFromPoint";
  table[4410] = "user32.dll!NtUserAddClipboardFormatListener";
  table[4411] = "user32.dll!NtUserAlterWindowStyle";
  table[4420] = "user32.dll!NtUserBuildPropList";
  table[4433] = "user32.dll!NtUserCheckAccessForIntegrityLevel";
  table[4435] = "user32.dll!NtUserCheckWindowThreadDesktop";
  table[4444] = "user32.dll!NtUserConvertMemHandle";
  table[4451] = "user32.dll!NtUserCreateLocalMemHandle";
  table[4466] = "user32.dll!NtUserDoSoundDisconnect";
  table[4467] = "user32.dll!NtUserDragDetect";
  table[4468] = "user32.dll!NtUserDragObject";
  table[4469] = "user32.dll!NtUserDrawAnimatedRects";
  table[4470] = "user32.dll!NtUserDrawCaption";
  table[4471] = "user32.dll!NtUserDrawCaptionTemp";
  table[4473] = "user32.dll!NtUserDrawMenuBarTemp";
  table[4474] = "user32.dll!NtUserEmptyClipboard";
  table[4483] = "user32.dll!NtUserEvent";
  table[4489] = "user32.dll!NtUserFrostCrashedWindow";
  table[4490] = "user32.dll!NtUserGetAltTabInfo";
  table[4499] = "user32.dll!NtUserGetClipboardData";
  table[4503] = "user32.dll!NtUserGetClipboardViewer";
  table[4504] = "user32.dll!NtUserGetClipCursor";
  table[4507] = "user32.dll!NtUserGetControlColor";
  table[4510] = "user32.dll!NtUserGetCursorInfo";
  table[4515] = "user32.dll!NtUserGetGuiResources";
  table[4519] = "user32.dll!NtUserGetImeHotKey";
  table[4521] = "user32.dll!NtUserGetInternalWindowPos";
  table[4523] = "user32.dll!NtUserGetKeyboardLayoutName";
  table[4525] = "user32.dll!NtUserGetKeyNameText";
  table[4527] = "user32.dll!NtUserGetListBoxInfo";
  table[4529] = "user32.dll!NtUserGetMenuIndex";
  table[4530] = "user32.dll!NtUserGetMenuItemRect";
  table[4532] = "user32.dll!NtUserGetMouseMovePointsEx";
  table[4535] = "user32.dll!NtUserGetPriorityClipboardFormat";
  table[4537] = "user32.dll!NtUserGetRawInputBuffer";
  table[4538] = "user32.dll!NtUserGetRawInputData";
  table[4539] = "user32.dll!NtUserGetRawInputDeviceInfo";
  table[4540] = "user32.dll!NtUserGetRawInputDeviceList";
  table[4541] = "user32.dll!NtUserGetRegisteredRawInputDevices";
  table[4547] = "user32.dll!NtUserGetUpdatedClipboardFormats";
  table[4552] = "user32.dll!NtUserGetWOWClass";
  table[4556] = "user32.dll!NtUserHiliteMenuItem";
  table[4558] = "user32.dll!NtUserImpersonateDdeClientWindow";
  table[4561] = "user32.dll!NtUserInitTask";
  table[4563] = "user32.dll!NtUserInternalGetWindowIcon";
  table[4574] = "user32.dll!NtUserMenuItemFromPoint";
  table[4576] = "user32.dll!NtUserMinMaximize";
  table[4577] = "user32.dll!NtUserMNDragLeave";
  table[4578] = "user32.dll!NtUserMNDragOver";
  table[4579] = "user32.dll!NtUserModifyUserStartupInfoFlags";
  table[4581] = "user32.dll!NtUserNotifyIMEStatus";
  table[4587] = "user32.dll!NtUserOpenThreadDesktop";
  table[4599] = "user32.dll!NtUserQuerySendMessage";
  table[4601] = "user32.dll!NtUserRealChildWindowFromPoint";
  table[4603] = "user32.dll!NtUserRealWaitMessageEx";
  table[4606] = "user32.dll!NtUserRegisterErrorReportingDialog";
  table[4610] = "user32.dll!NtUserRegisterTasklist";
  table[4612] = "user32.dll!NtUserRemoveClipboardFormatListener";
  table[4616] = "user32.dll!NtUserResolveDesktopForWOW";
  table[4626] = "user32.dll!NtUserSetClassWord";
  table[4627] = "user32.dll!NtUserSetClipboardData";
  table[4631] = "user32.dll!NtUserSetCursorContents";
  table[4639] = "user32.dll!NtUserSetInternalWindowPos";
  table[4642] = "user32.dll!NtUserSetMenuContextHelpId";
  table[4644] = "user32.dll!NtUserSetMenuFlagRtoL";
  table[4645] = "user32.dll!NtUserSetObjectInformation";
  table[4652] = "user32.dll!NtUserSetSysColors";
  table[4653] = "user32.dll!NtUserSetSystemCursor";
  table[4655] = "user32.dll!NtUserSetSystemTimer";
  table[4668] = "user32.dll!NtUserSetWindowsHookAW";
  table[4680] = "user32.dll!NtUserTestForInteractiveUser";
  table[4683] = "user32.dll!NtUserToUnicodeEx";
  table[4692] = "user32.dll!NtUserUnloadKeyboardLayout";
  table[4698] = "user32.dll!NtUserUpdateInstance";
  table[4700] = "user32.dll!NtUserGetLayeredWindowAttributes";
  table[4703] = "user32.dll!NtUserUserHandleGrantAccess";
  table[4709] = "user32.dll!NtUserWaitForMsgAndEvent";
  table[4711] = "user32.dll!NtUserWin32PoolAllocationStats";
  table[4714] = "user32.dll!NtUserYieldTask";
  table[4721] = "user32.dll!NtUserUnregisterSessionPort";
  table[4722] = "user32.dll!NtUserUpdateWindowTransform";
  table[4866] = "user32.dll!NtUserSetMirrorRendering";
  table[4867] = "user32.dll!NtUserShowSystemCursor";
}

  return table;
}

#endif  // TRACELINE_SYSCALL_MAP_H_
