#
# $Id: FindADNS.cmake 30104 2009-09-23 19:40:25Z jmayer $
#
# - Find adns
# Find the native ADNS includes and library
#
#  ADNS_INCLUDE_DIRS - where to find adns.h, etc.
#  ADNS_LIBRARIES    - List of libraries when using adns.
#  ADNS_FOUND        - True if adns found.


IF (ADNS_INCLUDE_DIRS)
  # Already in cache, be silent
  SET(ADNS_FIND_QUIETLY TRUE)
ENDIF (ADNS_INCLUDE_DIRS)

FIND_PATH(ADNS_INCLUDE_DIR adns.h)

SET(ADNS_NAMES adns)
FIND_LIBRARY(ADNS_LIBRARY NAMES ${ADNS_NAMES} )

# handle the QUIETLY and REQUIRED arguments and set ADNS_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(ADNS DEFAULT_MSG ADNS_LIBRARY ADNS_INCLUDE_DIR)

IF(ADNS_FOUND)
  SET( ADNS_LIBRARIES ${ADNS_LIBRARY} )
  SET( ADNS_INCLUDE_DIRS ${ADNS_INCLUDE_DIR} )
ELSE(ADNS_FOUND)
  SET( ADNS_LIBRARIES )
  SET( ADNS_INCLUDE_DIRS )
ENDIF(ADNS_FOUND)

MARK_AS_ADVANCED( ADNS_LIBRARIES ADNS_INCLUDE_DIRS )
