/*
 *
 *            ttest - throughput performance test.
 *
 *            Copyright (c) 1999-2011 Roman Drahtmueller
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define TTEST_VERSION "0.7"
#define TTEST_DATE "20110121"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>             /* sleep(3), alarm(2) */
#include <time.h>               /* time(2) */
#include <math.h>               /* exp() */
#include <signal.h>             /* sigaction(2) */
#include <errno.h>
#include <fcntl.h>              /* ioctl(2) */

#if 0
#ifdef sun
#include <sys/page.h>
#else
#include <asm/page.h>           /* PAGE_SIZE */
#endif


#define DEF_BUFFERSIZE PAGE_SIZE
#endif

#define DEF_SLEEP 1

#define STDIN_READ 0
#define STDOUT_WRITE 1
#define STDIO_RDWR 2

double bufcount_avg[3], bytecount_avg[3];
double bytestotal_avg;
double avg_exp[3];
int sleeptime;
long count;
unsigned long long buffersrdwr,bufferstotal;
unsigned long long bytesrdwr,bytestotal;
unsigned int buffersize;
int operation_mode;
struct sigaction alrmact;
time_t time_begin,time_count;

/* protos: */
void alrmhandler();
void printstats();
void calc_stats();
int setupalarm();

/*------------------------------------------------------------------------------------*/

void alrmhandler( ) {
        calc_stats();
        printstats();
        buffersrdwr = 0;                        
        bytesrdwr = 0;
        setupalarm();
        alarm(sleeptime);

}
/*------------------------------------------------------------------------------------*/

                /* set up the alrm handler */
int setupalarm() {
        alrmact.sa_handler = &alrmhandler;
        memset(&alrmact.sa_mask, 0, sizeof(alrmact.sa_mask));
        alrmact.sa_flags = 0 | SA_RESTART ;
        return(sigaction(SIGALRM, &alrmact, NULL));
}

/*------------------------------------------------------------------------------------*/

void calc_stats () {
        int i;
        time_count=time(NULL);
        count = time_count - time_begin;
/*         count += sleeptime; */
        if(count>10) {
        for(i=0;i<=2;i++) {     /* Calc buffers/s averages: */    
        bufcount_avg[i] = bufcount_avg[i] +
                        ( ((double) buffersrdwr - bufcount_avg[i]) 
                           * avg_exp[i] );
                                /* Same for bytes/s. */
        bytecount_avg[i] = bytecount_avg[i] +
                        ( ((double) bytesrdwr - bytecount_avg[i])
                           * avg_exp[i] );
        
        }
        } else if(count==10) {
                for(i=0;i<=2;i++) { /* set avg values to reasonable values. */
                        bufcount_avg[i] = (double) buffersrdwr;
                        bytecount_avg[i] = (double) bytesrdwr;
                }
        }
        bufferstotal += buffersrdwr;
        bytestotal += bytesrdwr;
        bytestotal_avg = ( (double) bytestotal) / count;
}


void printstats() {
int i,j;
#ifdef DEBUG
        fprintf(stderr,"\nbytestotal: %lld\n",bytestotal);
#endif /* DEBUG */
        if(count == 0) 
                j=1;
        else
                j=count;
#ifdef DEBUG
        fprintf(stderr,"\rcount: %d ",j);
#endif /* DEBUG */
        fprintf(stderr,"%lld kB, avg: ",bytesrdwr/1024);
        for(i=0;i<=2;i++) fprintf(stderr,"%2.2f ",bytecount_avg[i]/1024);
        fprintf(stderr,"  total: %lldkB",bytestotal/1024);
        fprintf(stderr," in %i sec",j);
        fprintf(stderr," (%2.2fkB/s)  \r",bytestotal_avg/1024 );
        fflush(NULL);
}

int do_rdwr(char *buf, int size) {
int retval;
        errno=0;
        switch(operation_mode) {
          case STDIN_READ:  /* read mode */
                retval=read(STDIN_FILENO, buf, size);
#ifdef DEBUG
                if((retval < 0) && (errno == EINTR)) {
                fprintf(stderr,"\nread returned EINTR.\n");
                        return(0);
                }
#endif
                if((retval < 0) && (errno != EINTR)) {
                        perror("\nread");
                        exit(0);
                } else {
                        return(retval);
                }
            break;
          case STDOUT_WRITE:
                retval=write(STDOUT_FILENO, buf, size);
                if((retval < 0) && (errno == EINTR)) {
                        return(0); /* may have been waiting for net... */
                }
                if((retval < 0) && (errno != EINTR)) {
                        perror("\nwrite");
                        exit(0);
                } else {
                        return(retval);
                }
            break;
          case STDIO_RDWR:
                retval=read(STDIN_FILENO, buf, size);
#ifdef DEBUG
                if((retval < 0) && (errno == EINTR)) {
                fprintf(stderr,"\nread returned EINTR.\n");
                        return(0);
                }
#endif
                if((retval < 0) && (errno != EINTR)) {
                        perror("\nread");
                        exit(0);
                } else {
                        retval=write(STDOUT_FILENO, buf, retval);
                        if((retval < 0) && (errno == EINTR)) {
                                return(0); /* may have been waiting for net... */
                        }
                        if((retval < 0) && (errno != EINTR)) {
                            perror("\nwrite");
                            exit(0);
                        } else {
                        return(retval);
                        }
                }
            break;
        }               /* switch */
        return 0;
}                       /* do_rdwr() */

void usage(char *progname) {
        fprintf(stderr,"usage: %s [buffersize] \n", progname);
        fprintf(stderr,"buffersize examples: 100k 1m 200\n");
        fprintf(stderr,"At least one out of stdin/stdout must not be a terminal.\n");
        fprintf(stderr,"Averages are 1-, 5- and 15-minute average values.\n");
	fprintf(stderr,"ttest version %s dated %s\n", TTEST_VERSION, TTEST_DATE);
        exit(-1);
}


/*--  MAIN  --------------------------------------------------------------------------*/

int main(int argc, char **argv) {
char *buf;
int len,i,j;
                                /* initialisations */
        sleeptime=DEF_SLEEP;
        for(i=0;i<=2;i++) bufcount_avg[i]=0;
                /* 1 minute avg weight */
        avg_exp[0] = (1 - 1/exp(((double) sleeptime/60)));
                /* 5 minute avg ... */          
        avg_exp[1] = (1 - 1/exp(((double) sleeptime/(5*60))));
                /* 15 minute avg ... */
        avg_exp[2] = (1 - 1/exp(((double) sleeptime/(15*60)))); 
#ifdef DEBUG
        fprintf(stderr,"avg 0,1,2: %f %f %f\n",avg_exp[0],avg_exp[1],avg_exp[2]);   
#endif /* DEBUG */
        len = 0;
        count = 0;
        bytesrdwr = 0;
        bytestotal = 0;
        bytestotal_avg = 0;
        buffersrdwr = 0;
        bufferstotal = 0;
#if 0
        buffersize = DEF_BUFFERSIZE;
#else
        buffersize = getpagesize();
#endif
                                /* See where we put our junk to. */
        operation_mode = STDIN_READ;    /* prevent harm if sth fails. */
/*------------------------------------------------------------------------------------*/
                                /* determine operation mode */
/*------------------------------------------------------------------------------------*/
        if(isatty(STDIN_FILENO) && ( ! isatty(STDOUT_FILENO))) {
/*                ioctl(STDOUT_FILENO, F_SETFL, O_NONBLOCK); */
                operation_mode = STDOUT_WRITE;
        }
        else if ((! isatty(STDIN_FILENO)) && isatty(STDOUT_FILENO)) {
/*                ioctl(STDIN_FILENO, F_SETFL, O_NONBLOCK); */
                operation_mode = STDIN_READ;
        }
        else if ((! isatty(STDIN_FILENO)) && (! isatty(STDOUT_FILENO))) {
/*                ioctl(STDIN_FILENO, F_SETFL, O_NONBLOCK); */
/*                ioctl(STDOUT_FILENO, F_SETFL, O_NONBLOCK); */
                operation_mode = STDIO_RDWR;
        }
        if(isatty(STDIN_FILENO) && isatty(STDOUT_FILENO))
                usage(argv[0]); /* spit if both fd's are terminals (makes no sense). */
/*------------------------------------------------------------------------------------*/
                                /* read the commandline. */
/*------------------------------------------------------------------------------------*/
    if(argc!=1) {
        switch(argv[1][+strlen(argv[1])-1]) {
            case 'k':       /* kilobytes... */
                i=1024;     /* factor */
                argv[1][strlen(argv[1])-1] = 0;
                break;
            case 'm': case 'M':     /* he wants megs... Stepan? */
                i=1024*1024;    /* megs */
                argv[1][strlen(argv[1])-1] = 0;
                break;
            default:
                i=1;
                break;
        }       /* switch(last byte of first word) */        

        for(j=0;argv[1][j];j++) {
            if (!isdigit(argv[1][j])) 
                usage(argv[0]);
        }        /* for */

        buffersize=i*(atoi(argv[1]));
    } else {
#if 0
        buffersize = DEF_BUFFERSIZE;
#else
        buffersize= getpagesize();
#endif
    }
#ifdef DEBUG
        fprintf(stderr,"buffersize: %i\n",buffersize);
#endif

/*------------------------------------------------------------------------------------*/

        buf = (void *) malloc(buffersize);
        if(setupalarm()<0) {    /* will be repeated within the alarmhandler */
                perror("sigaction");
                exit(-1);
        }
        
        fprintf(stderr,"buffersize: %i bytes\n",buffersize);
        time_begin=time(NULL);
        time_count=time_begin;
        alarm(sleeptime);

    /* main loop: */
        
        while(1) {              /* loop forever. do_rdwr() exits on error. -> len >= 0 */
                len = do_rdwr(buf,buffersize);
                if(len == 0) {
			/* huh. do_rdwr() did catch -EINTR, so we're at EOF? */
			if(errno == 0) {
				alarm(0);
				calc_stats();
				printstats();
				fprintf(stderr,"\n");
				return(0);
			}
			usleep(1000); /* don't remember where this one came from, but
					 it fixed something... */
                }
                buffersrdwr++;
                bytesrdwr += len;
        }

    /* End of mail loop */

        return(0);
}
