#
# spec file for package kernel-probes-kmp (Version 1.2.0)
#
# Copyright (c) 2008 SUSE LINUX Products GmbH, Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

# norootforbuild
# usedforbuild    aaa_base acl attr audit-libs autoconf automake bash bind-libs bind-utils binutils bison bzip2 coreutils cpio cpp cracklib cvs cyrus-sasl db diffutils e2fsprogs file filesystem fillup findutils flex gawk gcc gdbm gdbm-devel gettext gettext-devel glibc glibc-32bit glibc-devel glibc-locale gpm grep groff gzip info insserv kernel-source kernel-syms klogd less libacl libattr libcom_err libgcc libgssapi libmudflap libnscd libstdc++ libtool libxcrypt libzio m4 make man mktemp module-init-tools ncurses ncurses-devel net-tools netcfg openldap2-client openssl pam pam-modules patch perl permissions popt procinfo procps psmisc pwdutils rcs readline rpm sed sharutils strace sysvinit tar tcpd texinfo timezone unzip util-linux vim zlib zlib-devel

Name:           kprobes-kmp
BuildRequires:  kernel-source kernel-syms
BuildRequires:  sharutils
Summary:        Kernel Module for debugging using KProbes
Version:        1.0
Release:        1.0
Group:          System/Kernel
License:        GPL v2 or later
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#Provides:
#Requires:    
#Conflicts:   
AutoReqProv:    on
Source:         kprobes-%{version}.tar.gz
Source2:        kprobes-Makefile
Source3:        preamble
ExclusiveArch:  %ix86 x86_64 ppc64 ia64
%suse_kernel_module_package -n kprobes -p %_sourcedir/preamble kdump um

%description
This package contains a kernel module implementing debugging using kprobes.

%prep
%setup -n kprobes-%version
cp %{SOURCE2} Makefile

%build
cd ..
mkdir obj
for flavor in %flavors_to_build ; do
  rm -rf obj/$flavor
  mkdir obj/$flavor
  cp -r kprobes-%{version} obj/$flavor/
  make -C /usr/src/linux-obj/%_target_cpu/$flavor modules \
       M=$PWD/obj/$flavor/kprobes-%{version}
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
cd ..
for flavor in %flavors_to_build ; do
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules_install \
         M=$PWD/obj/$flavor/kprobes-%{version}
done

%clean
test -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != "/" && rm -rf $RPM_BUILD_ROOT

%changelog
* Mon Jan 28 2008 - jack@suse.cz
- created package
