/*
 * Photo Image Print System
 * Copyright (C) 2002-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2002-2005.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON AVASYS Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON AVASYS Public License and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON AVASYS Public License.
 */

#ifndef	MAKEPPD_PPD_GENERATOR_H
#define MAKEPPD_PPD_GENERATOR_H
 
#include "definitions.h"
#include "utility.h"
#include "files_parser.h"

STATUS ppd_init(
	const char	*model,
	const char	*paperlist_path, 
	const char	*prtoptlist_path
);

STATUS ppd_generate(
	const char	*ppd_dir
);

STATUS ppd_done();

const char* ppd_translate_error(const STATUS status);

#endif /* MAKEPPD_PPD_GENERATOR_H */


