/*
 * Photo Image Print System
 * Copyright (C) 2002-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2002-2005.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON AVASYS Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON AVASYS Public License and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON AVASYS Public License.
 */

#ifndef MAKEPPD_UTILITY_H
#define MAKEPPD_UTILITY_H

#define ASSERT(expression) \
	if (!(expression))\
	{\
		assert(#expression, __FILE__, __LINE__);\
	}\

typedef void	*PVOID;
typedef char	UNIT[5]; /* "mm", "in", "dpi" or "pts" */
typedef unsigned char byte;

typedef enum {
	false,
		true
} bool;

typedef struct {
	double	width;
	double	height;
	UNIT	unit;
} PaperSize;

void papersize_cpy(PaperSize* dest, const PaperSize* src);

typedef struct {
	double	left;
	double	top;
	double	right;
	double	bottom;
	UNIT	unit;
} PaperMargin;

void papermargin_cpy(PaperMargin* dest, const PaperMargin* src);

PaperSize* convert_size_unit(
	PaperSize	*paper_size,
	const UNIT	dest_unit
);

PaperMargin* convert_margin_unit(
	PaperMargin	*paper_margin,
	const UNIT	dest_unit
);

char* ltrim(
	char	*target
);

char* rtrim(
	char	*target
);

char* abbreviate(
	const char	*source,
	char		*dest
);

void assert(char* msg, char* file, int line);

#ifdef UNIX
void *strupr(char *s);
void *strlwr(char *s);
#endif


/* ListInfo class */

typedef void	(*Done)(PVOID* item);
typedef PVOID*	(*GetNext)(PVOID cur_item);
typedef int		(*Compare)(const PVOID* item1, const PVOID* item2);
typedef	int		(*EachItem)(PVOID* cur_item, PVOID user_data);

typedef struct {
	PVOID		*index_list;
	PVOID		first_item;
	PVOID		last_item;
	int			count;
	Done		done;
	GetNext		get_next;
	Compare		compare;
} ListInfo, *ListHandle;

ListHandle list_init(
	PVOID		*_index_list,
	PVOID		_first_item,
	int			_count,
	Done		_done,
	GetNext		_get_next,
	Compare		_compare
);

int		list_count(ListHandle list_handle);

void	list_done(ListHandle *list_handle_addr);

bool	list_create_index(ListHandle list_handle);

PVOID*	list_find_item(ListHandle list_handle, const PVOID* key);

void	list_close_index(ListHandle list_handle);

void	list_add_item(ListHandle, PVOID item);

void	list_release(ListHandle list_handle);

bool	list_for_each(ListHandle list_handle, EachItem each_item_proc, PVOID user_data);

#endif /* MAKEPPD_UTILITY_H */


