/*
 * Photo Image Print System
 * Copyright (C) 2000-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2005.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON AVASYS Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON AVASYS Public License and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON AVASYS Public License.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef __PIPS_DEF_H__
#define __PIPS_DEF_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef __PIPSDEF_H__
	typedef unsigned char UCHAR;
	typedef unsigned short USHORT;
	typedef unsigned int UINT;
	typedef unsigned long ULONG;
	typedef struct _POINT
	{
		long x;
		long y;
	} POINT, *LP_POINT;
#endif /*  __PIPSDEF_H__ */

	typedef int BOOL;
	typedef void* HANDLE;


	typedef struct _DOUBLE_POINT
	{
		double x;
		double y;
	} DPOINT, *LP_DPOINT;

/* print¤ ѥ᡼Ǽ */
	typedef struct _PP_PRINT_STRUCT
	{
		UCHAR paper;
		UCHAR ink;
		UCHAR media_type;
		UCHAR qlevel;

		int brightness;
		int contrast;
		int saturation;
		POINT ratio;
		POINT margin;
		POINT paper_size;
		POINT paper_area;
		POINT default_margin;
		int fit_page;	 /* add -Fri Oct  5 2001 */
		UCHAR borderless_print;
	} PRT_STRUCT, *LP_PRT_STRUCT;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /*  __PIPS_DEF_H__ */
