/*
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h> 
#endif 

#include <gnome.h> 

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "commands.h"

#include <stdio.h> 

enum { AVI, PLAYLIST };

int g_currentFrame = -1;
char g_playlist_name[1024];
int g_filetype;

extern GtkWidget *statusbar1;
extern GtkWidget *statusbar2;
extern GtkWidget *statusbar3;

gboolean
on_main_window_delete_event (GtkWidget *widget,
                             GdkEvent *event,
                             gpointer user_data)
{
    gtk_exit(0);
    return FALSE;
}


gboolean
on_main_window_key_press_event (GtkWidget *widget,
                                GdkEventKey *event,
                                gpointer user_data)
{
    int	start, end;
    GtkWidget *video_drawingarea = lookup_widget(widget, "drawingarea1");
    GtkWidget *dialog;
    static char cmd[16] = { 0 };

    switch (event->keyval) {
    case 0x0000ff51:
        strcpy(cmd, "h");
        break;
    case 0x0000ff52:
        strcpy(cmd, "k");
        break;
    case 0x0000ff53:
        strcpy(cmd, "l");
        break;
    case 0x0000ff54:
        strcpy(cmd, "j");
        break;

    default:
        strcat(cmd, event->string);
        break;
    }

    if (event->keyval == 0x0000ff1b) {
        cmd[0] = 0;
    }

    /* Navigation */

    /* advance one frame */

    else if ((strcmp(cmd, "l") == 0) || (strcmp(cmd, " ") == 0)) {
        g_currentFrame = Play(video_drawingarea, g_currentFrame + 1, g_currentFrame + 1);
        cmd[0] = 0;
    }

    /* backspace one frame */

    else if ((strcmp(cmd, "h") == 0) || (strcmp(cmd, "\010") == 0)) {
        g_currentFrame = Play(video_drawingarea, g_currentFrame - 1, g_currentFrame - 1);
        cmd[0] = 0;
    }

    /* advance one second */

    else if ((strcmp(cmd, "w") == 0) || (strcmp(cmd, "W") == 0) || (strcmp(cmd, "e") == 0) || (strcmp(cmd, "E") == 0)) {
        g_currentFrame = Play(video_drawingarea, g_currentFrame + 25, g_currentFrame + 25);
        cmd[0] = 0;
    }

    /* backspace one second */

    else if ((strcmp(cmd, "b") == 0) || (strcmp(cmd, "B") == 0)) {
        g_currentFrame = Play(video_drawingarea, g_currentFrame - 25, g_currentFrame - 25);
        cmd[0] = 0;
    }

    /* start of sequence */

    else if ((strcmp(cmd, "0") == 0) || (strcmp(cmd, "^") == 0)) {
        g_currentFrame = FindStartOfSequence(g_currentFrame);
        g_currentFrame = Play(video_drawingarea, g_currentFrame, g_currentFrame);
        cmd[0] = 0;
    }

    /* end of sequence */

    else if (strcmp(cmd, "$") == 0) {
        g_currentFrame = FindEndOfSequence(g_currentFrame);
        g_currentFrame = Play(video_drawingarea, g_currentFrame, g_currentFrame);
        cmd[0] = 0;
    }

    /* move forward 5 sequences */

    else if (strcmp(cmd, "\006") == 0) {
        g_currentFrame = FindEndOfSequence(g_currentFrame);
        g_currentFrame = FindEndOfSequence(g_currentFrame + 1);
        g_currentFrame = FindEndOfSequence(g_currentFrame + 1);
        g_currentFrame = FindEndOfSequence(g_currentFrame + 1);
        g_currentFrame = Play(video_drawingarea, g_currentFrame + 1, g_currentFrame + 1);
        cmd[0] = 0;
    }

    /* move backwards 5 sequences */

    else if (strcmp(cmd, "\002") == 0) {
        g_currentFrame = FindStartOfSequence(g_currentFrame);
        g_currentFrame = FindStartOfSequence(g_currentFrame - 1);
        g_currentFrame = FindStartOfSequence(g_currentFrame - 1);
        g_currentFrame = FindStartOfSequence(g_currentFrame - 1);
        g_currentFrame = FindStartOfSequence(g_currentFrame - 1);
        g_currentFrame = Play(video_drawingarea, g_currentFrame, g_currentFrame);
        cmd[0] = 0;
    }

    /* start of next sequence */

    else if ((strcmp(cmd, "j") == 0) || (strcmp(cmd, "\015") == 0) || (strcmp(cmd, "+") == 0)) {
        g_currentFrame = FindEndOfSequence(g_currentFrame) + 1;
        g_currentFrame = FindStartOfSequence(g_currentFrame);
        g_currentFrame = Play(video_drawingarea, g_currentFrame, g_currentFrame);
        cmd[0] = 0;
    }

    /* start of previous sequence */

    else if ((strcmp(cmd, "k") == 0) || (strcmp(cmd, "-") == 0)) {
        g_currentFrame = FindStartOfSequence(g_currentFrame) - 1;
        if (g_currentFrame > 0)
            g_currentFrame = FindStartOfSequence(g_currentFrame);
        g_currentFrame = Play(video_drawingarea, g_currentFrame, g_currentFrame);
        cmd[0] = 0;
    }

    /* first frame */

    else if (strcmp(cmd, "gg") == 0) {
        g_currentFrame = Play(video_drawingarea, 0, 0);
        cmd[0] = 0;
    }

    /* last frame */

    else if (strcmp(cmd, "G") == 0) {
        g_currentFrame = Play(video_drawingarea, 0x7fffffff, 0x7fffffff);
        cmd[0] = 0;
    }

    /* delete current frame */

    else if ((strcmp(cmd, "x") == 0) || (strcmp(cmd, "d ") == 0) || (strcmp(cmd, "dl") == 0) || (strcmp(cmd, "\177") == 0)) {
        CopyFrames(g_currentFrame, g_currentFrame);
        DeleteFrames(g_currentFrame, g_currentFrame);
        g_currentFrame = Play(video_drawingarea, g_currentFrame, g_currentFrame);
        cmd[0] = 0;
    }

    /* delete current sequence */

    else if (strcmp(cmd, "dd") == 0) {
        start = FindStartOfSequence(g_currentFrame);
        end = FindEndOfSequence(g_currentFrame);
        CopyFrames(start, end);
        DeleteFrames(start, end);
        g_currentFrame = Play(video_drawingarea, start, start);
        cmd[0] = 0;
    }

    /* delete from current frame up to end of sequence */

    else if (strcmp(cmd, "d$") == 0) {
        end = FindEndOfSequence(g_currentFrame);
        CopyFrames(g_currentFrame, end);
        DeleteFrames(g_currentFrame, end);
        g_currentFrame = Play(video_drawingarea, g_currentFrame - 1, g_currentFrame - 1);
        cmd[0] = 0;
    }

    /* delete from start of sequence just before current frame */

    else if ((strcmp(cmd, "d0") == 0) || strcmp(cmd, "d^") == 0) {
        start = FindStartOfSequence(g_currentFrame);
        if (start < g_currentFrame) {
            CopyFrames(start, g_currentFrame - 1);
            DeleteFrames(start, g_currentFrame - 1);
            g_currentFrame = Play(video_drawingarea, start, start);
        }
        cmd[0] = 0;
    }

    /* copy current frame */

    else if ((strcmp(cmd, "y ") == 0) || (strcmp(cmd, "yl") == 0)) {
        CopyFrames(g_currentFrame, g_currentFrame);
        cmd[0] = 0;
    }

    /* copy current sequence */

    else if ((strcmp(cmd, "yy") == 0) || (strcmp(cmd, "Y") == 0)) {
        start = FindStartOfSequence(g_currentFrame);
        end = FindEndOfSequence(g_currentFrame);
        CopyFrames(start, end);
        cmd[0] = 0;
    }

    /* copy from current frame up to end of sequence */

    else if (strcmp(cmd, "y$") == 0) {
        end = FindEndOfSequence(g_currentFrame);
        CopyFrames(g_currentFrame, end);
        cmd[0] = 0;
    }

    /* copy from start of sequence just before current frame */

    else if ((strcmp(cmd, "y0") == 0) || strcmp(cmd, "y^") == 0) {
        start = FindStartOfSequence(g_currentFrame);
        if (start < g_currentFrame) {
            CopyFrames(start, g_currentFrame - 1);
            g_currentFrame = Play(video_drawingarea, start, start);
        }
        cmd[0] = 0;
    }

    /* paste after current frame */

    else if (strcmp(cmd, "p") == 0) {
        PasteFrames(g_currentFrame + 1);
        cmd[0] = 0;
    }

    /* paste before current frame */

    else if (strcmp(cmd, "P") == 0) {
        PasteFrames(g_currentFrame);
        end = FindEndOfSequence(g_currentFrame + 1);
        g_currentFrame = Play(video_drawingarea, end, end);
        cmd[0] = 0;
    }

    /* read AVI or PlayList */

    else if (strcmp(cmd, ":r") == 0) {
        dialog = create_open_file_dialog();
        gtk_window_set_title (GTK_WINDOW (dialog), "Choose an AVI file or a playlist");
        gtk_widget_show(dialog);
        cmd[0] = 0;
    }

    /* write AVI file */

    else if (strcmp(cmd, ":w") == 0) {
        dialog = create_save_file_dialog();
        g_filetype = AVI;
        gtk_window_set_title (GTK_WINDOW (dialog), "Save an AVI file");
        gtk_widget_show(dialog);
        cmd[0] = 0;
    }

    /* write PlayList */

    else if (strcmp(cmd, ":W") == 0) {
        dialog = create_save_file_dialog();
        g_filetype = PLAYLIST;
        gtk_window_set_title (GTK_WINDOW (dialog), "Save the playlist");
        gtk_widget_show(dialog);
        cmd[0] = 0;
    }

    /* quit */

    else if (strcmp(cmd, ":q") == 0) {
	gtk_exit(0);
    }
    else {
        printf("send_event: %2.2x\n", event->send_event);
        printf("time  : %8.8x\n", event->time);
        printf("state : %8.8x\n", event->state);
        printf("keyval: %8.8x\n", event->keyval);
        printf("length: %8.8x\n", event->length);
        printf("string: %s\n", event->string);
        printf("(hex) : %2.2x\n", event->string[0]);
        printf("cmd   : %s\n", cmd);

    }

    return FALSE;
}


void
on_new_activate (GtkMenuItem *menuitem,
                 gpointer user_data)
{
}



void
on_open_activate (GtkMenuItem *menuitem,
                  gpointer user_data)
{
    GtkWidget *dialog = create_open_file_dialog();
    gtk_window_set_title (GTK_WINDOW (dialog), "Choose an AVI file or a playlist");
    gtk_widget_show(dialog);

}


void
on_save_activate (GtkMenuItem *menuitem,
                  gpointer user_data)
{
    SavePlayList(g_playlist_name);
}


void
on_save_as_activate (GtkMenuItem *menuitem,
                     gpointer user_data)
{
    GtkWidget *dialog = create_save_file_dialog();
    g_filetype = PLAYLIST;
    gtk_window_set_title (GTK_WINDOW (dialog), "Save the playlist");
    gtk_widget_show(dialog);
}


void
on_exit_activate (GtkMenuItem *menuitem,
                  gpointer user_data)
{
    gtk_exit(0);
}


void
on_undo_activate (GtkMenuItem *menuitem,
                  gpointer user_data)
{
}



void
on_redo_activate (GtkMenuItem *menuitem,
                  gpointer user_data)
{
}



void
on_cut_current_frame_activate (GtkMenuItem *menuitem,
                               gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    CopyFrames(g_currentFrame, g_currentFrame);
    DeleteFrames(g_currentFrame, g_currentFrame);
    g_currentFrame = Play(video_drawingarea, g_currentFrame, g_currentFrame);
}


void
on_cut_to_end_of_sequence_activate (GtkMenuItem *menuitem,
                                    gpointer user_data)
{
    int end;
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    end = FindEndOfSequence(g_currentFrame);
    CopyFrames(g_currentFrame, end);
    DeleteFrames(g_currentFrame, end);
    g_currentFrame = Play(video_drawingarea, g_currentFrame - 1, g_currentFrame - 1);
}


void
on_cut_current_sequence_activate (GtkMenuItem *menuitem,
                                  gpointer user_data)
{
    int start;
    int end;
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    start = FindStartOfSequence(g_currentFrame);
    end = FindEndOfSequence(g_currentFrame);
    CopyFrames(start, end);
    DeleteFrames(start, end);
    g_currentFrame = Play(video_drawingarea, start, start);
}


void
on_copy_current_frame_activate (GtkMenuItem *menuitem,
                                gpointer user_data)
{
    CopyFrames(g_currentFrame, g_currentFrame);
}


void
on_copy_current_sequence_activate (GtkMenuItem *menuitem,
                                   gpointer user_data)
{
    int start;
    int end;
    start = FindStartOfSequence(g_currentFrame);
    end = FindEndOfSequence(g_currentFrame);
    CopyFrames(start, end);
}


void
on_paste_before_current_frame_activate (GtkMenuItem *menuitem,
                                        gpointer user_data)
{
    int end;
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    PasteFrames(g_currentFrame);
    end = FindEndOfSequence(g_currentFrame + 1);
    g_currentFrame = Play(video_drawingarea, end, end);
}


void
on_paste_after_current_frame_activate (GtkMenuItem *menuitem,
                                       gpointer user_data)
{
    PasteFrames(g_currentFrame + 1);
}


void
on_insert_movie_activate (GtkMenuItem *menuitem,
                          gpointer user_data)
{

    GtkWidget *dialog = create_open_file_dialog();
    gtk_window_set_title (GTK_WINDOW (dialog), "Choose an AVI file or a playlist");
    gtk_widget_show(dialog);
}


void
on_save_movie_activate (GtkMenuItem *menuitem,
                        gpointer user_data)
{
    GtkWidget *dialog = create_save_file_dialog();
    g_filetype = AVI;
    gtk_window_set_title (GTK_WINDOW (dialog), "Save an AVI file");
    gtk_widget_show(dialog);
}


void
on_move_one_frame_forward_activate (GtkMenuItem *menuitem,
                                    gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    g_currentFrame = Play(video_drawingarea, g_currentFrame + 1, g_currentFrame + 1);
}


void
on_move_one_frame_backwards_activate (GtkMenuItem *menuitem,
                                      gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    g_currentFrame = Play(video_drawingarea, g_currentFrame - 1, g_currentFrame - 1);
}


void
on_move_to_start_of_sequence_activate (GtkMenuItem *menuitem,
                                       gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    g_currentFrame = FindStartOfSequence(g_currentFrame);
    g_currentFrame = Play(video_drawingarea, g_currentFrame, g_currentFrame);
}


void
on_move_to_end_of_sequence_activate (GtkMenuItem *menuitem,
                                     gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    g_currentFrame = FindEndOfSequence(g_currentFrame);
    g_currentFrame = Play(video_drawingarea, g_currentFrame, g_currentFrame);
}


void
on_move_to_start_of_next_sequence_activate
(GtkMenuItem *menuitem,
 gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    g_currentFrame = FindEndOfSequence(g_currentFrame) + 1;
    g_currentFrame = FindStartOfSequence(g_currentFrame);
    g_currentFrame = Play(video_drawingarea, g_currentFrame, g_currentFrame);

}


void
on_move_to_start_of_previous_sequence_activate
(GtkMenuItem *menuitem,
 gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    g_currentFrame = FindStartOfSequence(g_currentFrame) - 1;
    if (g_currentFrame > 0)
        g_currentFrame = FindStartOfSequence(g_currentFrame);
    g_currentFrame = Play(video_drawingarea, g_currentFrame, g_currentFrame);
}


void
on_move_forward_one_second_activate (GtkMenuItem *menuitem,
                                     gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    g_currentFrame = Play(video_drawingarea, g_currentFrame + 25, g_currentFrame + 25);
}


void
on_move_backwards_one_second_activate (GtkMenuItem *menuitem,
                                       gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    g_currentFrame = Play(video_drawingarea, g_currentFrame - 25, g_currentFrame - 25);
}


void
on_move_to_first_frame_activate (GtkMenuItem *menuitem,
                                 gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    g_currentFrame = Play(video_drawingarea, 0, 0);
}


void
on_move_to_last_frame_activate (GtkMenuItem *menuitem,
                                gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(menuitem), "drawingarea1");
    g_currentFrame = Play(video_drawingarea, 0x7fffffff, 0x7fffffff);
}


void
on_player_window_first_button_clicked (GtkButton *button,
                                       gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(button), "drawingarea1");
    g_currentFrame = Play(video_drawingarea, 0, 0);
}


void
on_player_window_back_button_clicked (GtkButton *button,
                                      gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(button), "drawingarea1");
    g_currentFrame = Play(video_drawingarea, g_currentFrame - 1, g_currentFrame - 1);
}


void
on_player_window_forward_button_clicked
(GtkButton *button,
 gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(button), "drawingarea1");
    g_currentFrame = Play(video_drawingarea, g_currentFrame + 1, g_currentFrame + 1);

}


void
on_player_window_last_button_clicked (GtkButton *button,
                                      gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(button), "drawingarea1");
    g_currentFrame = Play(video_drawingarea, 0x7fffffff, 0x7fffffff);
}


void
on_player_window_run_button_clicked (GtkButton *button,
                                     gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(GTK_WIDGET(button), "drawingarea1");
    g_currentFrame = Play(video_drawingarea, 0, 0x7fffffff);
}


gboolean
on_video_drawingarea1_expose_event (GtkWidget *widget,
                                    GdkEventExpose *event,
                                    gpointer user_data)
{
    GtkWidget *video_drawingarea = lookup_widget(widget, "drawingarea1");
    g_currentFrame = Play(video_drawingarea, g_currentFrame, g_currentFrame);

    return FALSE;
}


gboolean
on_open_file_dialog_delete_event (GtkWidget *widget,
                                  GdkEvent *event,
                                  gpointer user_data)
{
    GtkWidget *dialog = gtk_widget_get_toplevel(widget);
    gtk_widget_destroy(dialog);

    return FALSE;
}


void
on_open_file_dialog_ok_button_clicked (GtkButton *button,
                                       gpointer user_data)
{
    gchar *filename;
    FILE	*f;
    char	buffer[20];
    char	name[256];

    GtkWidget *dialog = gtk_widget_get_toplevel(GTK_WIDGET(button));
    filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(dialog));
    f = fopen(filename, "r");
    if (f != NULL) {
        memset(buffer, 0, 20);
        fread(buffer, 20, 1, f);
        if ((strncmp(buffer, "RIFF", 4) == 0) && (strncmp(buffer + 8, "AVI ", 4) == 0)) {
            strcpy(name, filename);
            gtk_widget_destroy(dialog);
            LoadAVI(name, g_currentFrame + 1);
        } else if (strncmp(buffer, "#kino-playlist", 14) == 0) {
            strcpy(g_playlist_name, filename);
            gtk_widget_destroy(dialog);
            LoadPlayList(g_playlist_name, g_currentFrame + 1);
        }
        fclose(f);
        g_currentFrame++;
    }
}


void
on_open_file_dialog_cancel_button_clicked
(GtkButton *button,
 gpointer user_data)
{
    GtkWidget *dialog = gtk_widget_get_toplevel(GTK_WIDGET(button));
    gtk_widget_destroy(dialog);
}


gboolean
on_save_file_dialog_delete_event (GtkWidget *widget,
                                  GdkEvent *event,
                                  gpointer user_data)
{
    GtkWidget *dialog = gtk_widget_get_toplevel(widget);
    gtk_widget_destroy(dialog);

    return FALSE;
}


void
on_save_file_dialog_ok_button_clicked (GtkButton *button,
                                       gpointer user_data)
{
    GtkWidget *dialog = gtk_widget_get_toplevel(GTK_WIDGET(button));
    gchar *filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(dialog));
    switch (g_filetype) {
    case AVI:
        SaveAVI(filename);
        break;

    case PLAYLIST:
        strcpy(g_playlist_name, filename);
        SavePlayList(g_playlist_name);
        break;
    }
    gtk_widget_destroy(dialog);
}


void
on_save_file_dialog_cancel_button_clicked
(GtkButton *button,
 gpointer user_data)
{
    GtkWidget *dialog = gtk_widget_get_toplevel(GTK_WIDGET(button));
    gtk_widget_destroy(dialog);
}

