/*
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "riff.h"
#include "avi.h"
#include "playlist.h"

extern "C" {

#include <gnome.h>
#include <math.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "commands.h"

GtkWidget *player_window;
extern  GtkWidget *statusbar1;
extern  GtkWidget *statusbar2;
extern  GtkWidget *statusbar3;


PlayList g_playlist;
PlayList g_copiedPlayList;

pthread_t player_thread;
pthread_mutex_t player_mutex;

guint8 		g_rgb_frame[720*576*3];

int Play(GtkWidget *drawingarea, int first, int last)
{
	int currentFrame;
	gboolean 	isPAL;
	char	msg[256];


	if (g_playlist.framelist.size() == 0)
		return -1;

	if (first < 0)
		first = 0;
	if (first >= g_playlist.framelist.size()) 
		first = g_playlist.framelist.size() - 1;
	if (last < 0)
		last = 0;
	if (last >= g_playlist.framelist.size()) 
		last = g_playlist.framelist.size() - 1;

	if (first <= last) {

		currentFrame = first;
		for (int i = first; i <= last; ++i) {
			Frame frame;
			sprintf(msg, "%d / %d %s", i + 1, g_playlist.framelist.size(), g_playlist.framelist[i].filename);
  			gtk_statusbar_push (GTK_STATUSBAR (statusbar3), 1, msg);
			g_playlist.GetFrame(i, frame);
			frame.ExtractRGB(g_rgb_frame);
    			isPAL = frame.IsPAL();
			gdk_draw_rgb_image(drawingarea->window, drawingarea->style->fg_gc[drawingarea->state],
			       0,0,720,isPAL?576:480,GDK_RGB_DITHER_MAX,g_rgb_frame,720*3);
			currentFrame = i;
		}
		return currentFrame;
	} else
		return -1;
}

int FindStartOfSequence(int last) {

	struct tm tm0;
	struct tm tm1;
	time_t t0;
	time_t t1;
	Frame frame;

	int first = 0;
	if (last < 0)
		last = 0;
	if (last >= g_playlist.framelist.size())
		last = g_playlist.framelist.size() - 1;

	g_playlist.GetFrame(last, frame);
	frame.GetRecordingDate(tm0);
	t0 = mktime(&tm0);

	for (int i = last - 20; i >= first; i -= 20) {
		g_playlist.GetFrame(i, frame);
		frame.GetRecordingDate(tm1);
		t1 = mktime(&tm1);
		if (fabs(difftime(t1, t0)) > 2.0) {
			for (int j = i + 19; j >= i; --j) {
				g_playlist.GetFrame(j, frame);
				frame.GetRecordingDate(tm1);
				t1 = mktime(&tm1);
				if (fabs(difftime(t1, t0)) > 1.0)
					return j + 1;
			}
			assert(0);
		}
		t0 = t1;
	}
	return 0;
}


int FindEndOfSequence(int first) {

	struct tm tm0;
	struct tm tm1;
	time_t t0;
	time_t t1;
	Frame frame;

	int last = g_playlist.framelist.size() - 1;
	if (first < 0)
		first = 0;
	if (first > last)
		first = last;

	g_playlist.GetFrame(first, frame);
	frame.GetRecordingDate(tm0);
	t0 = mktime(&tm0);

	/* find significant change in timecode */

	for (int i = first + 20; i <= last; i += 20) {
		g_playlist.GetFrame(i, frame);
		frame.GetRecordingDate(tm1);
		t1 = mktime(&tm1);
		if (fabs(difftime(t1, t0)) > 2.0) {
			for (int j = i - 19; j <= i; ++j) {
				g_playlist.GetFrame(j, frame);
				frame.GetRecordingDate(tm1);
				t1 = mktime(&tm1);
				if (fabs(difftime(t1, t0)) > 1.0)
					return j - 1;
			}
			assert(0);
		}
		t0 = t1;
	}
	return last;
}


int CopyFrames(int first, int last)
{
	char	msg[256];

	g_copiedPlayList = g_playlist.GetPlayList(first, last);
	sprintf(msg, "%d frames copied", g_playlist.framelist.size());
  	gtk_statusbar_push (GTK_STATUSBAR (statusbar2), 1, msg);
}


int PasteFrames(int before)
{
	char	msg[256];

	g_playlist.InsertPlayList(g_copiedPlayList, before);
	sprintf(msg, "%d frames inserted", g_playlist.framelist.size());
  	gtk_statusbar_push (GTK_STATUSBAR (statusbar2), 1, msg);
}


int DeleteFrames(int first, int last)
{
	char	msg[256];
	int before, after;

	before = g_playlist.framelist.size();
	g_playlist.Delete(first, last);
	after = g_playlist.framelist.size();
	sprintf(msg, "%d frames deleted", before - after);
  	gtk_statusbar_push (GTK_STATUSBAR (statusbar2), 1, msg);
}


int LoadAVI(char *filename, int before)
{
	PlayList newList;

	newList.LoadAVI(filename);
	g_playlist.InsertPlayList(newList, before);
}


int SaveAVI(char *file)
{
	Frame frame;
	AVI1File *avi = new AVI1File(file);
	g_playlist.GetFrame(0, frame);
	avi->Init(frame.IsPAL() ? AVI_PAL : AVI_NTSC, 48000);
	for (int i = 0; i < g_playlist.framelist.size(); ++i) {
		g_playlist.GetFrame(i, frame);
		avi->WriteFrame(frame);
	}
	avi->WriteRIFF();
	delete avi;
}


int LoadPlayList(char *file, int before)
{
	PlayList newList;

	newList.LoadPlayList(file);
	g_playlist.InsertPlayList(newList, before);
}


int SavePlayList(char *file)
{
	g_playlist.SavePlayList(file);
}


int BulkLoad(int argc, char* argv[])
{
	FILE *f;
	char *filename;
	char buffer[20];

  for (int i = 1; i <= argc; ++i) {
    filename = argv[i];
    f = fopen(filename, "r");
    if (f != NULL) {
        memset(buffer, 0, 20);
        fread(buffer, 20, 1, f);
        if ((strncmp(buffer, "RIFF", 4) == 0) && (strncmp(buffer + 8, "AVI ", 4) == 0)) {
            LoadAVI(filename, g_playlist.framelist.size());
        } else if (strncmp(buffer, "#kino-playlist", 14) == 0) {
            LoadPlayList(filename, g_playlist.framelist.size());
        }
        fclose(f);
    }
  }
}

	
} // extern "C" 
