/*
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h> 
#include "playlist.h"

void PlayList::GetFrame(int abs_frame_num, Frame &frame)
{

    int rel_frame_num = framelist[abs_frame_num].frame;
    AVIFile *avi = framelist[abs_frame_num].avi;
    avi->GetDVFrame(frame, rel_frame_num);
}


PlayList PlayList::GetPlayList(int first, int last)
{
    PlayList playlist;

    for (int i = first; i <= last; ++i) {
        playlist.framelist.insert(playlist.framelist.end(), framelist[i]);
    }
    return playlist;
}


void PlayList::InsertPlayList(PlayList &playlist, int before)
{
    if (before < 0)
        before = 0;
    if (before > framelist.size())
        before = framelist.size();

    /* Add all framelist entries to our playlist. */

    for (int i = 0; i < playlist.framelist.size(); ++i) {
        FrameListEntry framelist_entry = playlist.framelist[i];
        framelist.insert(framelist.begin() + before + i, framelist_entry);
    }
}


void PlayList::Delete(int first, int last)
{
    framelist.erase(framelist.begin() + first, framelist.begin() + last + 1);
}


void PlayList::LoadAVI(char *filename)
{
    FrameListEntry framelist_entry;

    AVIFile *avi = new AVIFile(filename);
    avi->ParseRIFF();
    avi->ReadIndex();

    for (int i = 0; i < avi->GetTotalFrames(); ++i) {
        framelist_entry.filename = strdup(filename);
        framelist_entry.avi = avi;
        framelist_entry.frame = i;
        framelist.insert(framelist.end(), framelist_entry);
    }
}


void PlayList::LoadPlayList(char *filename)
{
    char	avifile[256];
    FrameListEntry framelist_entry;
    FILE *file = fopen(filename, "r");
    framelist_entry.filename = "";
    if (file != NULL) {
        fscanf(file, "#kino-playlist-0.1\n");
        while (feof(file) == 0) {
            fscanf(file, "%d;%s\n", &framelist_entry.frame, avifile);
            if (strcmp(avifile, framelist_entry.filename) != 0) {
                framelist_entry.avi = new AVIFile(avifile);
                framelist_entry.avi->ParseRIFF();
                framelist_entry.avi->ReadIndex();
                framelist_entry.filename = strdup(avifile);
            }
            framelist.insert(framelist.end(), framelist_entry);
        }
        fclose(file);
    }
}


void PlayList::SavePlayList(char *filename)
{
    FILE *file = fopen(filename, "w+");
    if (file != NULL) {
        fprintf(file, "#kino-playlist-0.1\n");
        for (int i = 0; i < framelist.size(); ++i) {
            fprintf(file, "%d;%s\n", framelist[i].frame, framelist[i].filename);
        }
        fclose(file);
    }
}


