/* Doors for Linux.
   Copyright (C) 1998 Jason Lango

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
** door_cred.c
** Jason Lango <jal@cs.brown.edu>
*/

#include "door.h"
#include "door_ioctl.h"
#include "libdoor.h"
#include <sys/ioctl.h>
#include <errno.h>

int __door_cred(door_cred_t *cred)
{
	/* N.B.: door_cred() will crash rather than return EFAULT if
	 * "cred" is invalid, since this is a library call rather than
	 * a system call.
	 */

	struct door_thread_priv *priv;

	if (!cred) {
		__set_errno(EFAULT);
		return -1;
	}

	if (!__door_svr_create_thr_started) {
		/* door_cred() called, but this can't be a server
		 * thread.
		 */
		__set_errno(EINVAL);
		return -1;
	}

	priv = __door_get_priv();
	if (!priv) {
		/* door_cred() can't return ENOMEM, however this
		 * situation indicates that this thread isn't a server
		 * thread.
		 */
		__set_errno(EINVAL);
		return -1;
	}

	if (!priv->dp_toplevel_initialized) {
		__set_errno(EINVAL);
		return -1;
	}

	*cred = priv->dp_serve_args.cred;
	return 0;
}

weak_alias(__door_cred, door_cred)
