/* Doors for Linux.
   Copyright (C) 1998 Jason Lango

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
**  libdoorsP.h - Interface structures and defines for doors driver.
**  Jason Lango <jal@cs.brown.edu>
*/

#ifndef __LIBDOORSP_H__
#define __LIBDOORSP_H__

#include "door.h"

#define DOOR_ARGBUF_SIZE	(16 * 1024)

/* /dev/door ioctl() numbers. */
/* XXX: Should use _IOWR(), etc. */
#define DOOR_CREATE		1
#define DOOR_CALL		2
#define DOOR_FATTACH		3
#define DOOR_FDETACH		4
#define DOOR_RETURN		5
#define DOOR_WAIT_SVR_CREATE	6
#define DOOR_INFO		7

struct door_create_args {
	void *server_procedure;
	void *cookie;
	u_int attributes;
};

struct door_fattach_args {
	int fd;
	const char *name;
};

struct door_fdetach_args {
	const char *name;
};

struct door_call_args {
	int fd;
	door_arg_t params;
	door_arg_t *rparams;
};

struct door_return_outargs {
	/* server_proc arguments */
	void			*proc;
	void			*cookie;
	char			*data_ptr;
	size_t			data_size;
	door_desc_t		*desc_ptr;
	size_t			desc_num;

	void			*munmap_addr;
	size_t			munmap_len;

	/* door_cred values */
	door_cred_t		cred;
};

struct door_return_args {
	void			*data_ptr;
	size_t			data_size;
	door_desc_t		*desc_ptr;
	size_t			num_desc;

	char			*argstash;
	size_t			argstash_size;

	void			*munmap_addr;
	size_t			munmap_len;

	struct door_return_outargs	*outargs;
};

struct door_wait_svr_create_args {
	door_info_t info;
};

struct door_info_args {
	int			fd;
	struct door_info	*info;
};

#endif /* __LIBDOORSP_H__ */
