/* Doors for Linux.
   Copyright (C) 1998 Jason Lango

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
** np_door_fdetach.c
** Jason Lango <jal@cs.brown.edu>
*/

#include "door.h"
#include "door_ioctl.h"
#include "libdoor.h"
#include <errno.h>
#include <sys/ioctl.h>

int __np_door_fdetach(const char *name)
{
	struct door_fdetach_args args;

	DOOR_INIT();

	args.name = name;

	return ioctl(__door_dev_fd, DOOR_FDETACH, &args);
}

weak_alias(__np_door_fdetach, np_door_fdetach)
