/* Doors for Linux.
   Copyright (C) 1998 Jason Lango

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
** door_error.c - Print door error messages
** Jason Lango <jal@rampant.org>
*/

#include "libdoor.h"
#include <stdarg.h>
#include <stdio.h>

void
__door_error (const char *fmt, ...)
{
  va_list pvar;

  va_start (pvar, fmt);

  fputs ("libdoor: ERROR: ", stderr);
  vfprintf (stderr, fmt, pvar);
  fputs ("\n", stderr);

  va_end (pvar);
}
