/* Doors for Linux.
   Copyright (C) 1998 Jason Lango

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
** door_call.c
** Jason Lango <jal@rampant.org>
*/

#include <errno.h>
#include "door.h"
#include "door_ioctl.h"
#include "libdoor.h"
#include <sys/ioctl.h>

int __door_call(int d, door_arg_t *params)
{
  struct door_call_args   args;
  door_karg_t             rparams;
  int                     error;

  DOOR_INIT();

  args.fd = d;
  args.rparams = DOOR_PTR(&rparams);

  args.params.data_ptr = DOOR_PTR(params->data_ptr);
  args.params.data_size = params->data_size;
  args.params.desc_ptr = DOOR_PTR(params->desc_ptr);
  args.params.desc_num = params->desc_num;
  args.params.rbuf = DOOR_PTR(params->rbuf);
  args.params.rsize = params->rsize;

  error = __ioctl (__door_dev_fd, DOOR_CALL, &args);

  if (!error) {
    params->data_ptr = (char*)DOOR_UINTPTR(rparams.data_ptr);
    params->data_size = rparams.data_size;
    params->desc_ptr = (door_desc_t*)DOOR_UINTPTR(rparams.desc_ptr);
    params->desc_num = rparams.desc_num;
    params->rbuf = (char*)DOOR_UINTPTR(rparams.rbuf);
    params->rsize = rparams.rsize;
  }
  return error;
}
